/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.ocr.OcrEngine;
import com.google.android.apps.common.testing.accessibility.framework.ocr.OcrResult;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Parameters {
    private @Nullable Image screenCapture;
    private @Nullable Double customTextContrastRatio;
    private @Nullable Double customImageContrastRatio;
    private @Nullable Integer customTouchTargetSize;
    private @Nullable Boolean enableEnhancedContrastEvaluation;
    private @Nullable Boolean saveViewImage;
    private @Nullable OcrEngine ocrEngine;
    private @Nullable OcrResult ocrResult;

    public @Nullable Image getScreenCapture() {
        return this.screenCapture;
    }

    public void putScreenCapture(Image image) {
        this.screenCapture = (Image)Preconditions.checkNotNull((Object)image);
    }

    public void setSaveViewImages(boolean save2) {
        this.saveViewImage = save2;
    }

    public @Nullable Boolean getSaveViewImages() {
        return this.saveViewImage;
    }

    @Deprecated
    public @Nullable Double getCustomContrastRatio() {
        throw new UnsupportedOperationException();
    }

    public @Nullable Double getCustomTextContrastRatio() {
        return this.customTextContrastRatio;
    }

    public @Nullable Double getCustomImageContrastRatio() {
        return this.customImageContrastRatio;
    }

    @Deprecated
    public void putCustomContrastRatio(double contrastRatio) {
        this.putCustomTextContrastRatio(contrastRatio);
        this.putCustomImageContrastRatio(contrastRatio);
    }

    public void putCustomTextContrastRatio(double textContrastRatio) {
        this.customTextContrastRatio = textContrastRatio;
    }

    public void putCustomImageContrastRatio(double imageContrastRatio) {
        this.customImageContrastRatio = imageContrastRatio;
    }

    public @Nullable Integer getCustomTouchTargetSize() {
        return this.customTouchTargetSize;
    }

    public void putCustomTouchTargetSize(int touchTargetSize) {
        this.customTouchTargetSize = touchTargetSize;
    }

    public @Nullable Boolean getEnableEnhancedContrastEvaluation() {
        return this.enableEnhancedContrastEvaluation;
    }

    public void setEnableEnhancedContrastEvaluation(boolean enableEnhancedContrastEvaluation) {
        this.enableEnhancedContrastEvaluation = enableEnhancedContrastEvaluation;
    }

    public void putOcrEngine(OcrEngine ocrEngine) {
        Preconditions.checkState((this.ocrResult == null ? 1 : 0) != 0, (Object)"An OcrResult has already been provided.");
        this.ocrEngine = ocrEngine;
    }

    public void putOcrResult(OcrResult ocrResult) {
        Preconditions.checkState((this.ocrEngine == null ? 1 : 0) != 0, (Object)"An OcrEngine has already been provided.");
        this.ocrResult = ocrResult;
    }

    public synchronized @Nullable OcrResult getOcrResult() {
        if (this.ocrResult == null && this.screenCapture != null && this.ocrEngine != null) {
            this.ocrResult = this.ocrEngine.detect(this.screenCapture);
        }
        return this.ocrResult;
    }
}

