/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AnswerType;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.QuestionHandler;
import com.google.android.apps.common.testing.accessibility.framework.QuestionType;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.common.annotations.Beta;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

@Beta
public class Question {
    private final int questionId;
    private final Class<? extends QuestionType> questionTypeClass;
    private final Class<? extends AnswerType> answerTypeClass;
    private final Class<? extends QuestionHandler> questionHandlerClass;
    private final AccessibilityHierarchyCheckResult originalResult;
    private final @Nullable ResultMetadata metadata;

    public Question(int questionId, Class<? extends QuestionType> questionTypeClass, Class<? extends AnswerType> answerTypeClass, QuestionHandler questionHandler, AccessibilityHierarchyCheckResult originalResult, @Nullable ResultMetadata metadata) {
        this.questionId = questionId;
        this.questionTypeClass = questionTypeClass;
        this.answerTypeClass = answerTypeClass;
        this.questionHandlerClass = questionHandler.getClass();
        this.originalResult = originalResult;
        this.metadata = metadata;
    }

    public Question(int questionId, Class<? extends QuestionType> questionTypeClass, Class<? extends AnswerType> answerTypeClass, Class<? extends QuestionHandler> questionHandlerClass, AccessibilityHierarchyCheckResult originalResult, @Nullable ResultMetadata metadata) {
        this.questionId = questionId;
        this.questionTypeClass = questionTypeClass;
        this.answerTypeClass = answerTypeClass;
        this.questionHandlerClass = questionHandlerClass;
        this.originalResult = originalResult;
        this.metadata = metadata;
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public Class<? extends QuestionType> getQuestionTypeClass() {
        return this.questionTypeClass;
    }

    public Class<? extends AnswerType> getAnswerTypeClass() {
        return this.answerTypeClass;
    }

    public Class<? extends QuestionHandler> getQuestionHandlerClass() {
        return this.questionHandlerClass;
    }

    public AccessibilityHierarchyCheckResult getOriginalResult() {
        return this.originalResult;
    }

    @Pure
    public @Nullable ResultMetadata getMetadata() {
        return this.metadata;
    }

    public AccessibilityEvaluationProtos.QuestionProto toProto() {
        AccessibilityEvaluationProtos.QuestionProto.Builder builder2 = AccessibilityEvaluationProtos.QuestionProto.newBuilder();
        builder2.setQuestionId(this.getQuestionId());
        builder2.setQuestionTypeClass(this.getQuestionTypeClass().getName());
        builder2.setAnswerTypeClass(this.getAnswerTypeClass().getName());
        builder2.setQuestionHandlerClass(this.getQuestionHandlerClass().getName());
        builder2.setOriginalResult(this.getOriginalResult().toProto());
        if (this.getMetadata() instanceof HashMapResultMetadata) {
            builder2.setMetadata(((HashMapResultMetadata)this.getMetadata()).toProto());
        }
        return (AccessibilityEvaluationProtos.QuestionProto)builder2.build();
    }

    public static Question fromProto(AccessibilityEvaluationProtos.QuestionProto proto, AccessibilityHierarchy associatedHierarchy) {
        int questionId = proto.getQuestionId();
        Class<QuestionType> questionTypeClass = null;
        Class<AnswerType> answerTypeClass = null;
        Class<QuestionHandler> questionHandlerClass = null;
        try {
            questionTypeClass = Class.forName(proto.getQuestionTypeClass()).asSubclass(QuestionType.class);
            answerTypeClass = Class.forName(proto.getAnswerTypeClass()).asSubclass(AnswerType.class);
            questionHandlerClass = Class.forName(proto.getQuestionHandlerClass()).asSubclass(QuestionHandler.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        AccessibilityHierarchyCheckResult result = AccessibilityHierarchyCheckResult.fromProto(proto.getOriginalResult(), associatedHierarchy);
        HashMapResultMetadata metadata = proto.hasMetadata() ? HashMapResultMetadata.fromProto(proto.getMetadata()) : null;
        return new Question(questionId, questionTypeClass, answerTypeClass, questionHandlerClass, result, (ResultMetadata)metadata);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Question)) {
            return false;
        }
        Question that = (Question)o;
        if (!this.getOriginalResult().equals(that.getOriginalResult())) {
            return false;
        }
        if (this.getQuestionId() != that.getQuestionId()) {
            return false;
        }
        if (this.getAnswerTypeClass() != that.getAnswerTypeClass()) {
            return false;
        }
        if (this.getQuestionTypeClass() != that.getQuestionTypeClass()) {
            return false;
        }
        if (this.getQuestionHandlerClass() != that.getQuestionHandlerClass()) {
            return false;
        }
        return Objects.equals(this.getMetadata(), that.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getQuestionId(), this.getQuestionTypeClass(), this.getAnswerTypeClass(), this.getQuestionHandlerClass(), this.getOriginalResult(), this.getMetadata());
    }

    public String toString() {
        return String.format("Question %s %s %s %s %s %s", this.getQuestionId(), this.getQuestionTypeClass().getSimpleName(), this.getAnswerTypeClass().getSimpleName(), this.getQuestionHandlerClass().getSimpleName(), this.getOriginalResult(), this.getMetadata());
    }
}

