/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.res.Resources;
import android.graphics.Rect;
import android.os._Original_Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewAccessibilityUtils {
    private static final String TAG = "ViewA11yUtils";

    private ViewAccessibilityUtils() {
    }

    public static Set<View> getAllViewsInHierarchy(View rootView) {
        HashSet<View> allViews = new HashSet<View>();
        allViews.add(rootView);
        ViewAccessibilityUtils.addAllChildrenToSet(rootView, allViews);
        return allViews;
    }

    public static boolean isImportantForAccessibility(View view2) {
        if (view2 == null) {
            return false;
        }
        if (_Original_Build.VERSION.SDK_INT >= 21) {
            return view2.isImportantForAccessibility();
        }
        if (_Original_Build.VERSION.SDK_INT < 16) {
            return true;
        }
        int mode = view2.getImportantForAccessibility();
        if (mode == 2 || mode == 4) {
            return false;
        }
        ViewParent parent = view2.getParent();
        while (parent instanceof View) {
            if (((View)((Object)parent)).getImportantForAccessibility() == 4) {
                return false;
            }
            parent = parent.getParent();
        }
        return mode == 1 || ViewAccessibilityUtils.isActionableForAccessibility(view2) || ViewAccessibilityUtils.hasListenersForAccessibility(view2) || view2.getAccessibilityNodeProvider() != null || ViewAccessibilityUtils.isAccessibilityLiveRegion(view2);
    }

    public static boolean isActionableForAccessibility(View view2) {
        if (view2 == null) {
            return false;
        }
        return view2.isClickable() || view2.isLongClickable() || view2.isFocusable();
    }

    public static boolean isVisibleToUser(View view2) {
        if (view2 == null) {
            return false;
        }
        Object current = view2;
        while (current instanceof View) {
            Object currentView = current;
            if (((View)currentView).getAlpha() <= 0.0f || ((View)currentView).getVisibility() != 0) {
                return false;
            }
            current = ((View)currentView).getParent();
        }
        return view2.getGlobalVisibleRect(new Rect());
    }

    @RequiresApi(value=16)
    public static boolean shouldFocusView(View view2) {
        if (view2 == null) {
            return false;
        }
        if (!ViewAccessibilityUtils.isVisibleToUser(view2) || !ViewAccessibilityUtils.isImportantForAccessibility(view2)) {
            return false;
        }
        if (ViewAccessibilityUtils.isAccessibilityFocusable(view2)) {
            if (!(view2 instanceof ViewGroup) || view2 instanceof ViewGroup && !ViewAccessibilityUtils.hasAnyImportantDescendant((ViewGroup)view2)) {
                return true;
            }
            return ViewAccessibilityUtils.isSpeakingView(view2);
        }
        return ViewAccessibilityUtils.hasText(view2) && !ViewAccessibilityUtils.hasFocusableAncestor(view2);
    }

    public static @Nullable View getLabelForView(View view2) {
        if (_Original_Build.VERSION.SDK_INT < 17) {
            return null;
        }
        int idToFind = view2.getId();
        if (idToFind == -1) {
            return null;
        }
        View childToSkip = null;
        View labelingView;
        while ((labelingView = ViewAccessibilityUtils.lookForLabelForViewInViewAndChildren(view2, childToSkip, idToFind)) == null) {
            ViewParent parent = view2.getParent();
            childToSkip = view2;
            if (!(parent instanceof View)) {
                return null;
            }
            view2 = (View)((Object)parent);
        }
        return labelingView;
    }

    public static @Nullable Boolean isViewEditable(View view2) {
        if (view2 == null) {
            return null;
        }
        if (view2 instanceof EditText) {
            return true;
        }
        if (view2 instanceof TextView) {
            return ((TextView)view2).getEditableText() != null;
        }
        return false;
    }

    public static @Nullable String getResourceNameForView(View view2) {
        if (view2 == null || view2.getId() == 0 || view2.getId() == -1 || view2.getResources() == null) {
            return null;
        }
        if (!ViewAccessibilityUtils.isViewIdGenerated(view2.getId())) {
            try {
                return view2.getResources().getResourceName(view2.getId());
            }
            catch (Resources.NotFoundException nfe) {
                LogUtils.w(TAG, "Unable to resolve resource name from view ID.", new Object[0]);
            }
        }
        return null;
    }

    public static boolean isViewIdGenerated(int resourceId) {
        return (resourceId & 0xFF000000) == 0 && (resourceId & 0xFFFFFF) != 0;
    }

    @RequiresApi(value=17)
    private static @Nullable View lookForLabelForViewInViewAndChildren(View view2, @Nullable View childToSkip, int idToFind) {
        if (view2.getLabelFor() == idToFind) {
            return view2;
        }
        if (!(view2 instanceof ViewGroup)) {
            return null;
        }
        ViewGroup viewGroup = (ViewGroup)view2;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View labelingView;
            View child = viewGroup.getChildAt(i);
            if (child.equals(childToSkip) || (labelingView = ViewAccessibilityUtils.lookForLabelForViewInViewAndChildren(child, null, idToFind)) == null) continue;
            return labelingView;
        }
        return null;
    }

    private static void addAllChildrenToSet(View rootView, Set<View> theSet) {
        if (!(rootView instanceof ViewGroup)) {
            return;
        }
        ViewGroup rootViewGroup = (ViewGroup)rootView;
        for (int i = 0; i < rootViewGroup.getChildCount(); ++i) {
            View nextView = rootViewGroup.getChildAt(i);
            theSet.add(nextView);
            ViewAccessibilityUtils.addAllChildrenToSet(nextView, theSet);
        }
    }

    private static boolean hasListenersForAccessibility(View view2) {
        if (view2 == null) {
            return false;
        }
        boolean result = false;
        return result |= view2.getTouchDelegate() != null;
    }

    private static boolean isAccessibilityLiveRegion(View view2) {
        return _Original_Build.VERSION.SDK_INT >= 19 && view2.getAccessibilityLiveRegion() != 0;
    }

    @RequiresApi(value=16)
    private static boolean hasFocusableAncestor(View view2) {
        if (view2 == null) {
            return false;
        }
        ViewParent parent = view2.getParentForAccessibility();
        if (!(parent instanceof View)) {
            return false;
        }
        if (ViewAccessibilityUtils.isAccessibilityFocusable((View)((Object)parent))) {
            return true;
        }
        return ViewAccessibilityUtils.hasFocusableAncestor((View)((Object)parent));
    }

    @RequiresApi(value=16)
    private static boolean isAccessibilityFocusable(View view2) {
        if (view2 == null) {
            return false;
        }
        if (view2.getVisibility() != 0) {
            return false;
        }
        if (!ViewAccessibilityUtils.isImportantForAccessibility(view2)) {
            return false;
        }
        if (ViewAccessibilityUtils.isActionableForAccessibility(view2)) {
            return true;
        }
        return ViewAccessibilityUtils.isChildOfScrollableContainer(view2) && ViewAccessibilityUtils.isSpeakingView(view2);
    }

    @RequiresApi(value=16)
    private static boolean isChildOfScrollableContainer(View view2) {
        if (view2 == null) {
            return false;
        }
        ViewParent viewParent = view2.getParentForAccessibility();
        if (viewParent == null || !(viewParent instanceof View)) {
            return false;
        }
        View parent = (View)((Object)viewParent);
        if (parent.isScrollContainer()) {
            return true;
        }
        return (parent instanceof AdapterView || parent instanceof ScrollView || parent instanceof HorizontalScrollView) && !(parent instanceof Spinner);
    }

    @RequiresApi(value=16)
    private static boolean isSpeakingView(View view2) {
        if (ViewAccessibilityUtils.hasText(view2)) {
            return true;
        }
        if (view2 instanceof Checkable) {
            return true;
        }
        return ViewAccessibilityUtils.hasNonActionableSpeakingChildren(view2);
    }

    @RequiresApi(value=16)
    private static boolean hasNonActionableSpeakingChildren(View view2) {
        if (view2 == null || !(view2 instanceof ViewGroup)) {
            return false;
        }
        ViewGroup group = (ViewGroup)view2;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            if (child == null || child.getVisibility() != 0 || ViewAccessibilityUtils.isAccessibilityFocusable(child) || !ViewAccessibilityUtils.isImportantForAccessibility(child) || !ViewAccessibilityUtils.isSpeakingView(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasText(View view2) {
        if (!TextUtils.isEmpty(view2.getContentDescription())) {
            return true;
        }
        if (view2 instanceof TextView) {
            TextView textView = (TextView)view2;
            return !TextUtils.isEmpty(textView.getText()) || !TextUtils.isEmpty(textView.getHint());
        }
        return false;
    }

    private static boolean hasAnyImportantDescendant(ViewGroup group) {
        if (group == null) {
            return false;
        }
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            if (ViewAccessibilityUtils.isImportantForAccessibility(child)) {
                return true;
            }
            if (!(child instanceof ViewGroup) || !ViewAccessibilityUtils.hasAnyImportantDescendant((ViewGroup)child)) continue;
            return true;
        }
        return false;
    }
}

