/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPresetAndroid;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@CheckReturnValue
public class ViewChecker {
    private static final String TAG = "ViewChecker";
    private boolean obtainCharacterLocations = false;

    @CanIgnoreReturnValue
    public ViewChecker setObtainCharacterLocations(boolean obtainCharacterLocations) {
        this.obtainCharacterLocations = obtainCharacterLocations;
        return this;
    }

    ImmutableList<AccessibilityViewCheckResult> runCheckOnView(AccessibilityHierarchyCheck check, View root, @Nullable Parameters parameters) {
        return this.runChecksOnView((ImmutableSet<AccessibilityHierarchyCheck>)ImmutableSet.of((Object)check), root, parameters);
    }

    public ImmutableList<AccessibilityViewCheckResult> runChecksOnView(ImmutableSet<AccessibilityHierarchyCheck> checks, View root, @Nullable Parameters parameters) {
        ViewHierarchyElementAndroid evalRoot;
        View actualRoot = root.getRootView();
        HashBiMap mapFromElementIdToView = HashBiMap.create();
        AccessibilityHierarchyAndroid hierarchy = AccessibilityHierarchyAndroid.newBuilder(actualRoot).setViewOriginMap((BiMap<Long, View>)mapFromElementIdToView).setObtainCharacterLocations(this.obtainCharacterLocations).build();
        Long rootId = (Long)mapFromElementIdToView.inverse().get((Object)root);
        ViewHierarchyElementAndroid viewHierarchyElementAndroid = evalRoot = rootId != null ? hierarchy.getViewById(rootId) : null;
        if (evalRoot == null) {
            LogUtils.e(TAG, "Unable to determine root View for evaluation, using full hierarchy.", new Object[0]);
        }
        ImmutableList.Builder results = ImmutableList.builder();
        for (AccessibilityHierarchyCheck check : checks) {
            List<AccessibilityHierarchyCheckResult> hierarchyCheckResults = check.runCheckOnHierarchy(hierarchy, evalRoot, parameters);
            for (AccessibilityHierarchyCheckResult hierarchyCheckResult : hierarchyCheckResults) {
                ViewHierarchyElement element = hierarchyCheckResult.getElement();
                View checkedView = element != null ? (View)mapFromElementIdToView.get((Object)element.getCondensedUniqueId()) : null;
                results.add((Object)new AccessibilityViewCheckResult(check.getClass(), hierarchyCheckResult, checkedView));
            }
        }
        return results.build();
    }

    public ImmutableList<AccessibilityViewCheckResult> runViewChecksOnView(ImmutableSet<AccessibilityViewHierarchyCheck> checks, View root, @Nullable Parameters parameters) {
        return this.runChecksOnView(ViewChecker.convertViewChecks(checks), root, parameters);
    }

    private static ImmutableSet<AccessibilityHierarchyCheck> convertViewChecks(ImmutableSet<AccessibilityViewHierarchyCheck> viewChecks) {
        ImmutableSet.Builder checks = ImmutableSet.builder();
        for (AccessibilityViewHierarchyCheck viewCheck : viewChecks) {
            checks.add((Object)((AccessibilityCheckPresetAndroid.DelegatedViewHierarchyCheck)viewCheck).getAccessibilityHierarchyCheck());
        }
        return checks.build();
    }
}

