/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableStringBuilder;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewHierarchyElementUtils {
    public static final String ABS_LIST_VIEW_CLASS_NAME = "android.widget.AbsListView";
    public static final String ADAPTER_VIEW_CLASS_NAME = "android.widget.AdapterView";
    public static final String SCROLL_VIEW_CLASS_NAME = "android.widget.ScrollView";
    public static final String HORIZONTAL_SCROLL_VIEW_CLASS_NAME = "android.widget.HorizontalScrollView";
    public static final String SPINNER_CLASS_NAME = "android.widget.Spinner";
    public static final String TEXT_VIEW_CLASS_NAME = "android.widget.TextView";
    public static final String EDIT_TEXT_CLASS_NAME = "android.widget.EditText";
    public static final String IMAGE_VIEW_CLASS_NAME = "android.widget.ImageView";
    public static final String WEB_VIEW_CLASS_NAME = "android.webkit.WebView";
    public static final String SWITCH_CLASS_NAME = "android.widget.Switch";
    public static final String TOGGLE_BUTTON_CLASS_NAME = "android.widget.ToggleButton";
    public static final String COMPOSE_VIEW_CLASS_NAME = "androidx.compose.ui.platform.ComposeView";
    private static final String ANDROIDX_SCROLLING_VIEW_CLASS_NAME = "androidx.core.view.ScrollingView";
    private static final ImmutableList<String> SCROLLABLE_CONTAINER_CLASS_NAME_LIST = ImmutableList.of((Object)"android.widget.AdapterView", (Object)"android.widget.ScrollView", (Object)"android.widget.HorizontalScrollView", (Object)"androidx.core.view.ScrollingView");

    private ViewHierarchyElementUtils() {
    }

    @Deprecated
    public static SpannableString getSpeakableTextForElement(ViewHierarchyElement element) {
        return ViewHierarchyElementUtils.getSpeakableTextForElement(element, Locale.ENGLISH);
    }

    public static SpannableString getSpeakableTextForElement(ViewHierarchyElement element, Locale locale) {
        SpannableString label;
        ViewHierarchyElement labeledBy;
        SpannableString speakableText = ViewHierarchyElementUtils.getSpeakableTextFromElementSubtree(element, locale);
        if (element.isImportantForAccessibility() && (labeledBy = element.getLabeledBy()) != null && !TextUtils.isEmpty(label = ViewHierarchyElementUtils.getSpeakableElementTextOrLabel(labeledBy))) {
            return new SpannableString(String.format(locale, StringManager.getString(locale, "template_labeled_item"), speakableText, label), (List<Span>)ImmutableList.of());
        }
        return speakableText;
    }

    private static SpannableString getSpeakableTextFromElementSubtree(ViewHierarchyElement element, Locale locale) {
        SpannableString hint;
        if (element.checkInstanceOf(TOGGLE_BUTTON_CLASS_NAME) || element.checkInstanceOf(SWITCH_CLASS_NAME)) {
            return ViewHierarchyElementUtils.ruleSwitch(element, locale);
        }
        SpannableStringBuilder returnStringBuilder = new SpannableStringBuilder();
        if (element.isImportantForAccessibility()) {
            SpannableString contentDescription;
            CharSequence stateDescription = ViewHierarchyElementUtils.getDescriptionForTreeStatus(element, locale);
            if (stateDescription != null) {
                returnStringBuilder.appendWithSeparator(stateDescription);
            }
            if (!TextUtils.isEmpty(contentDescription = element.getContentDescription())) {
                return returnStringBuilder.appendWithSeparator(contentDescription).build();
            }
            SpannableString text = element.getText();
            if (!TextUtils.isEmpty(text) && TextUtils.getTrimmedLength(text) > 0) {
                returnStringBuilder.appendWithSeparator(text);
            }
            if (element.checkInstanceOf(ABS_LIST_VIEW_CLASS_NAME) && element.getChildViewCount() == 0) {
                returnStringBuilder.appendWithSeparator(String.format(locale, StringManager.getString(locale, "template_containers_quantity_other"), StringManager.getString(locale, "value_listview"), 0));
            }
        }
        for (int i = 0; i < element.getChildViewCount(); ++i) {
            SpannableString childDesc;
            ViewHierarchyElement child = element.getChildView(i);
            if (ViewHierarchyElementUtils.isFocusableOrClickableForAccessibility(child) || TextUtils.isEmpty(childDesc = ViewHierarchyElementUtils.getSpeakableTextFromElementSubtree(child, locale))) continue;
            returnStringBuilder.appendWithSeparator(childDesc);
        }
        if (element.isImportantForAccessibility() && !TextUtils.isEmpty(hint = element.getHintText()) && TextUtils.getTrimmedLength(hint) > 0) {
            returnStringBuilder.appendWithSeparator(hint);
        }
        return returnStringBuilder.build();
    }

    private static @Nullable CharSequence getDescriptionForTreeStatus(ViewHierarchyElement element, Locale locale) {
        if (element.getStateDescription() != null) {
            return element.getStateDescription();
        }
        if (Boolean.TRUE.equals(element.isCheckable())) {
            if (Boolean.TRUE.equals(element.isChecked())) {
                return StringManager.getString(locale, "value_checked");
            }
            if (Boolean.FALSE.equals(element.isChecked())) {
                return StringManager.getString(locale, "value_not_checked");
            }
        }
        return null;
    }

    private static SpannableString ruleSwitch(ViewHierarchyElement element, Locale locale) {
        if (element.isImportantForAccessibility()) {
            return ViewHierarchyElementUtils.dedupeJoin(ViewHierarchyElementUtils.getSwitchState(element, locale), ViewHierarchyElementUtils.getSwitchContent(element));
        }
        return new SpannableString("", (List<Span>)ImmutableList.of());
    }

    private static @Nullable CharSequence getSwitchContent(ViewHierarchyElement element) {
        SpannableString contentDescription = element.getContentDescription();
        if (!TextUtils.isEmpty(contentDescription)) {
            return contentDescription;
        }
        SpannableString stateDescription = element.getStateDescription();
        SpannableString text = element.getText();
        if (stateDescription != null && !TextUtils.isEmpty(text) && TextUtils.getTrimmedLength(text) > 0) {
            return text;
        }
        return null;
    }

    private static @Nullable CharSequence getSwitchState(ViewHierarchyElement element, Locale locale) {
        if (element.getStateDescription() != null) {
            return element.getStateDescription();
        }
        SpannableString text = element.getText();
        if (!TextUtils.isEmpty(text) && TextUtils.getTrimmedLength(text) > 0) {
            return text;
        }
        if (Boolean.TRUE.equals(element.isChecked())) {
            return StringManager.getString(locale, "value_on");
        }
        if (Boolean.FALSE.equals(element.isChecked())) {
            return StringManager.getString(locale, "value_off");
        }
        return null;
    }

    private static @Nullable SpannableString getSpeakableElementTextOrLabel(ViewHierarchyElement element) {
        if (element.isImportantForAccessibility()) {
            SpannableString contentDescription = element.getContentDescription();
            if (!TextUtils.isEmpty(contentDescription)) {
                return contentDescription;
            }
            SpannableString text = element.getText();
            if (!TextUtils.isEmpty(text) && TextUtils.getTrimmedLength(text) > 0) {
                return text;
            }
        }
        return null;
    }

    public static boolean shouldFocusView(ViewHierarchyElement view2) {
        if (!Boolean.TRUE.equals(view2.isVisibleToUser())) {
            return false;
        }
        if (ViewHierarchyElementUtils.isAccessibilityFocusable(view2)) {
            if (!ViewHierarchyElementUtils.hasAnyImportantDescendant(view2)) {
                return true;
            }
            return ViewHierarchyElementUtils.isSpeakingView(view2);
        }
        return (ViewHierarchyElementUtils.hasText(view2) || !TextUtils.isEmpty(view2.getStateDescription())) && view2.isImportantForAccessibility() && !ViewHierarchyElementUtils.hasFocusableAncestor(view2);
    }

    public static @Nullable ViewHierarchyElement getFocusableForAccessibilityAncestor(ViewHierarchyElement view2) {
        ViewHierarchyElement currentView;
        for (currentView = view2; currentView != null && !ViewHierarchyElementUtils.isAccessibilityFocusable(currentView); currentView = currentView.getParentView()) {
        }
        return currentView;
    }

    private static boolean hasFocusableAncestor(ViewHierarchyElement view2) {
        ViewHierarchyElement parent = ViewHierarchyElementUtils.getImportantForAccessibilityAncestor(view2);
        if (parent == null) {
            return false;
        }
        if (ViewHierarchyElementUtils.isAccessibilityFocusable(parent)) {
            return true;
        }
        return ViewHierarchyElementUtils.hasFocusableAncestor(parent);
    }

    private static boolean isAccessibilityFocusable(ViewHierarchyElement view2) {
        if (!Boolean.TRUE.equals(view2.isVisibleToUser())) {
            return false;
        }
        if (!view2.isImportantForAccessibility()) {
            return false;
        }
        if (ViewHierarchyElementUtils.isFocusableOrClickableForAccessibility(view2)) {
            return true;
        }
        return ViewHierarchyElementUtils.isChildOfScrollableContainer(view2) && ViewHierarchyElementUtils.isSpeakingView(view2);
    }

    private static boolean isFocusableOrClickableForAccessibility(ViewHierarchyElement view2) {
        return !Boolean.FALSE.equals(view2.isVisibleToUser()) && view2.isImportantForAccessibility() && (view2.isScreenReaderFocusable() || view2.isClickable() || view2.isFocusable() || view2.isLongClickable());
    }

    private static boolean isChildOfScrollableContainer(ViewHierarchyElement view2) {
        ViewHierarchyElement parent = ViewHierarchyElementUtils.getImportantForAccessibilityAncestor(view2);
        if (parent == null) {
            return false;
        }
        if (Boolean.TRUE.equals(parent.isScrollable())) {
            return true;
        }
        if (parent.checkInstanceOf(SPINNER_CLASS_NAME)) {
            return false;
        }
        return parent.checkInstanceOfAny((List<String>)SCROLLABLE_CONTAINER_CLASS_NAME_LIST);
    }

    private static boolean isSpeakingView(ViewHierarchyElement view2) {
        if (view2.isImportantForAccessibility()) {
            if (ViewHierarchyElementUtils.hasText(view2)) {
                return true;
            }
            if (Boolean.TRUE.equals(view2.isCheckable())) {
                return true;
            }
        }
        return ViewHierarchyElementUtils.hasNonFocusableSpeakingChildren(view2);
    }

    private static boolean hasNonFocusableSpeakingChildren(ViewHierarchyElement view2) {
        for (int i = 0; i < view2.getChildViewCount(); ++i) {
            ViewHierarchyElement child = view2.getChildView(i);
            if (child == null || !Boolean.TRUE.equals(child.isVisibleToUser()) || ViewHierarchyElementUtils.isAccessibilityFocusable(child) || !ViewHierarchyElementUtils.isSpeakingView(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasText(ViewHierarchyElement view2) {
        return !TextUtils.isEmpty(view2.getText()) || !TextUtils.isEmpty(view2.getContentDescription()) || !TextUtils.isEmpty(view2.getHintText());
    }

    private static @Nullable ViewHierarchyElement getImportantForAccessibilityAncestor(ViewHierarchyElement view2) {
        ViewHierarchyElement parent;
        for (parent = view2.getParentView(); parent != null && !parent.isImportantForAccessibility(); parent = parent.getParentView()) {
        }
        return parent;
    }

    private static boolean hasAnyImportantDescendant(ViewHierarchyElement element) {
        for (int i = 0; i < element.getChildViewCount(); ++i) {
            ViewHierarchyElement child = element.getChildView(i);
            if (child.isImportantForAccessibility()) {
                return true;
            }
            if (child.getChildViewCount() <= 0 || !ViewHierarchyElementUtils.hasAnyImportantDescendant(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntersectedByOverlayWindow(ViewHierarchyElement viewHierarchyElement) {
        AccessibilityHierarchy hierarchy = viewHierarchyElement.getWindow().getAccessibilityHierarchy();
        Integer activeWindowLayer = hierarchy.getActiveWindow().getLayer();
        if (activeWindowLayer == null) {
            return false;
        }
        for (WindowHierarchyElement windowHierarchyElement : hierarchy.getAllWindows()) {
            if (windowHierarchyElement.getLayer() == null || (Integer)Preconditions.checkNotNull((Object)windowHierarchyElement.getLayer()) <= activeWindowLayer || !Rect.intersects(viewHierarchyElement.getBoundsInScreen(), windowHierarchyElement.getBoundsInScreen())) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntersectedByOverlayView(ViewHierarchyElement element) {
        if (element.getDrawingOrder() == null) {
            return false;
        }
        AccessibilityHierarchy hierarchy = element.getWindow().getAccessibilityHierarchy();
        ViewHierarchyElement rootView = hierarchy.getActiveWindow().getRootView();
        ViewHierarchyElement view2 = element;
        while (view2 != rootView) {
            ViewHierarchyElement parentView = (ViewHierarchyElement)Preconditions.checkNotNull((Object)view2.getParentView());
            for (int i = 0; i < parentView.getChildViewCount(); ++i) {
                ViewHierarchyElement siblingView = parentView.getChildView(i);
                if (siblingView.getDrawingOrder() == null || (Integer)Preconditions.checkNotNull((Object)siblingView.getDrawingOrder()) <= (Integer)Preconditions.checkNotNull((Object)view2.getDrawingOrder()) || !Rect.intersects(element.getBoundsInScreen(), siblingView.getBoundsInScreen())) continue;
                return true;
            }
            view2 = parentView;
        }
        return false;
    }

    public static boolean isPotentiallyObscured(ViewHierarchyElement viewHierarchyElement) {
        return ViewHierarchyElementUtils.isIntersectedByOverlayWindow(viewHierarchyElement) || ViewHierarchyElementUtils.isIntersectedByOverlayView(viewHierarchyElement);
    }

    private static SpannableString dedupeJoin(CharSequence ... values2) {
        SpannableStringBuilder returnStringBuilder = new SpannableStringBuilder();
        HashSet<String> uniqueValues = new HashSet<String>();
        for (CharSequence value2 : values2) {
            String lvalue;
            if (TextUtils.isEmpty(value2) || uniqueValues.contains(lvalue = Ascii.toLowerCase((String)value2.toString()))) continue;
            uniqueValues.add(lvalue);
            returnStringBuilder.appendWithSeparator(value2);
        }
        return returnStringBuilder.build();
    }
}

