/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DuplicateSpeakableTextCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_CLICKABLE_SAME_SPEAKABLE_TEXT = 1;
    public static final int RESULT_ID_NON_CLICKABLE_SAME_SPEAKABLE_TEXT = 2;
    public static final int RESULT_ID_CLICKABLE_SPEAKABLE_TEXT = 3;
    public static final int RESULT_ID_NON_CLICKABLE_SPEAKABLE_TEXT = 4;
    public static final String KEY_SPEAKABLE_TEXT = "KEY_SPEAKABLE_TEXT";
    public static final String KEY_CONFLICTING_VIEW_COUNT = "KEY_CONFLICTING_VIEW_COUNT";

    @Override
    protected String getHelpTopic() {
        return "7102513";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.CONTENT_LABELING;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        Map<String, List<ViewHierarchyElement>> textToViewMap = this.getSpeakableTextToViewMap(hierarchy.getActiveWindow().getAllViews(), hierarchy.getDeviceState().getLocale());
        for (String speakableText : textToViewMap.keySet()) {
            HashMapResultMetadata resultMetadata;
            if (textToViewMap.get(speakableText).size() < 2) continue;
            ArrayList<ViewHierarchyElement> clickableViews = new ArrayList<ViewHierarchyElement>();
            ArrayList<ViewHierarchyElement> nonClickableViews = new ArrayList<ViewHierarchyElement>();
            List<? extends ViewHierarchyElement> viewsToEval = fromRoot != null ? fromRoot.getSelfAndAllDescendants() : null;
            for (ViewHierarchyElement view2 : textToViewMap.get(speakableText)) {
                if (viewsToEval != null && !viewsToEval.contains(view2)) continue;
                if (Boolean.TRUE.equals(view2.isClickable())) {
                    clickableViews.add(view2);
                    continue;
                }
                nonClickableViews.add(view2);
            }
            if (!clickableViews.isEmpty()) {
                resultMetadata = new HashMapResultMetadata();
                resultMetadata.putString(KEY_SPEAKABLE_TEXT, speakableText);
                resultMetadata.putInt(KEY_CONFLICTING_VIEW_COUNT, clickableViews.size() + nonClickableViews.size() - 1);
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, (ViewHierarchyElement)clickableViews.get(0), 1, resultMetadata));
                clickableViews.remove(0);
                continue;
            }
            if (nonClickableViews.isEmpty()) continue;
            resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_SPEAKABLE_TEXT, speakableText);
            resultMetadata.putInt(KEY_CONFLICTING_VIEW_COUNT, clickableViews.size() + nonClickableViews.size() - 1);
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.INFO, (ViewHierarchyElement)nonClickableViews.get(0), 2, resultMetadata));
            nonClickableViews.remove(0);
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata);
        switch (resultId) {
            case 1: {
                return String.format(locale, StringManager.getString(locale, "result_message_same_speakable_text"), StringManager.getString(locale, "clickable"), metadata.getString(KEY_SPEAKABLE_TEXT), metadata.getInt(KEY_CONFLICTING_VIEW_COUNT));
            }
            case 2: {
                return String.format(locale, StringManager.getString(locale, "result_message_same_speakable_text"), StringManager.getString(locale, "non_clickable"), metadata.getString(KEY_SPEAKABLE_TEXT), metadata.getInt(KEY_CONFLICTING_VIEW_COUNT));
            }
            case 3: {
                return String.format(locale, StringManager.getString(locale, "result_message_speakable_text"), StringManager.getString(locale, "clickable"), metadata.getString(KEY_SPEAKABLE_TEXT));
            }
            case 4: {
                return String.format(locale, StringManager.getString(locale, "result_message_speakable_text"), StringManager.getString(locale, "non_clickable"), metadata.getString(KEY_SPEAKABLE_TEXT));
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        switch (resultId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return StringManager.getString(locale, "result_message_brief_same_speakable_text");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public @Nullable Double getSecondaryPriority(AccessibilityHierarchyCheckResult result) {
        ResultMetadata metadata = result.getMetadata();
        switch (result.getResultId()) {
            case 1: 
            case 2: {
                return ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getInt(KEY_CONFLICTING_VIEW_COUNT, 0);
            }
        }
        return null;
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_duplicate_speakable_text");
    }

    private Map<String, List<ViewHierarchyElement>> getSpeakableTextToViewMap(Collection<? extends ViewHierarchyElement> allViews, Locale locale) {
        HashMap<String, List<ViewHierarchyElement>> textToViewMap = new HashMap<String, List<ViewHierarchyElement>>();
        for (ViewHierarchyElement viewHierarchyElement : allViews) {
            String speakableText;
            if (!ViewHierarchyElementUtils.shouldFocusView(viewHierarchyElement) || TextUtils.isEmpty(speakableText = ViewHierarchyElementUtils.getSpeakableTextForElement(viewHierarchyElement, locale).toString().trim())) continue;
            if (!textToViewMap.containsKey(speakableText)) {
                textToViewMap.put(speakableText, new ArrayList());
            }
            ((List)textToViewMap.get(speakableText)).add(viewHierarchyElement);
        }
        return textToViewMap;
    }
}

