/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RedundantDescriptionCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_ENGLISH_LOCALE_ONLY = 1;
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 2;
    public static final int RESULT_ID_NO_CONTENT_DESC = 3;
    public static final int RESULT_ID_CONTENT_DESC_ENDS_WITH_VIEW_TYPE = 4;
    public static final int RESULT_ID_CONTENT_DESC_CONTAINS_ITEM_TYPE = 5;
    public static final int RESULT_ID_NOT_VISIBLE = 6;
    public static final int RESULT_ID_CONTENT_DESC_CONTAINS_STATE = 7;
    public static final int RESULT_ID_CONTENT_DESC_CONTAINS_ACTION = 8;
    public static final String KEY_CONTENT_DESCRIPTION = "KEY_CONTENT_DESCRIPTION";
    public static final String KEY_REDUNDANT_WORD = "KEY_REDUNDANT_WORD";
    private static final ImmutableList<String> ITEM_TYPE_WORD_KEYS = ImmutableList.of((Object)"button_item_type", (Object)"checkbox_item_type", (Object)"checkbox_item_type_separate_words");
    private static final ImmutableList<String> STATE_WORD_KEYS = ImmutableList.of((Object)"checked_state", (Object)"unchecked_state", (Object)"selected_state", (Object)"unselected_state");
    private static final ImmutableList<String> ACTION_WORD_KEYS = ImmutableList.of((Object)"click_action", (Object)"swipe_action", (Object)"tap_action");

    @Override
    protected String getHelpTopic() {
        return "6378990";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.CONTENT_LABELING;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        Locale recordedLocale = RedundantDescriptionCheck.getRecordedLocale(hierarchy);
        List<? extends ViewHierarchyElement> viewsToEval = RedundantDescriptionCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 6, null));
                continue;
            }
            if (!viewHierarchyElement.isImportantForAccessibility()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            SpannableString contentDescription = viewHierarchyElement.getContentDescription();
            if (TextUtils.isEmpty(contentDescription)) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            this.checkForWords(5, ITEM_TYPE_WORD_KEYS, recordedLocale, viewHierarchyElement, results);
            this.checkForWords(7, STATE_WORD_KEYS, recordedLocale, viewHierarchyElement, results);
            this.checkForWords(8, ACTION_WORD_KEYS, recordedLocale, viewHierarchyElement, results);
        }
        return results;
    }

    private void checkForWords(int resultId, ImmutableList<String> wordKeys, Locale locale, ViewHierarchyElement view2, List<AccessibilityHierarchyCheckResult> results) {
        CharSequence contentDescription = (CharSequence)Preconditions.checkNotNull((Object)view2.getContentDescription());
        for (String wordKey : wordKeys) {
            String word = StringManager.getString(locale, wordKey);
            if (!RedundantDescriptionCheck.containsWordIgnoreCase(contentDescription, word)) continue;
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_CONTENT_DESCRIPTION, contentDescription.toString());
            resultMetadata.putString(KEY_REDUNDANT_WORD, word.toString());
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view2, resultId, resultMetadata));
        }
    }

    @Override
    public String getMessageForResult(Locale locale, AccessibilityHierarchyCheckResult result) {
        ResultMetadata metadata;
        if (!(result.getResultId() != 4 || (metadata = result.getMetadata()) != null && metadata.containsKey(KEY_CONTENT_DESCRIPTION) || result.getElement() == null)) {
            ViewHierarchyElement culprit = result.getElement();
            ResultMetadata updatedMetadata = metadata != null ? metadata.clone() : new HashMapResultMetadata();
            updatedMetadata.putString(KEY_CONTENT_DESCRIPTION, ((SpannableString)Preconditions.checkNotNull((Object)culprit.getContentDescription())).toString());
            AccessibilityHierarchyCheckResult updatedResult = new AccessibilityHierarchyCheckResult(this.getClass(), result.getType(), culprit, result.getResultId(), updatedMetadata);
            return super.getMessageForResult(locale, updatedResult);
        }
        return super.getMessageForResult(locale, result);
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = RedundantDescriptionCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        Preconditions.checkNotNull((Object)metadata);
        switch (resultId) {
            case 5: {
                return String.format(locale, StringManager.getString(locale, "result_message_content_desc_contains_redundant_word"), metadata.getString(KEY_CONTENT_DESCRIPTION), metadata.getString(KEY_REDUNDANT_WORD));
            }
            case 4: {
                return String.format(locale, StringManager.getString(locale, "result_message_content_desc_ends_with_view_type"), metadata.getString(KEY_CONTENT_DESCRIPTION));
            }
            case 7: {
                return String.format(locale, StringManager.getString(locale, "result_message_content_desc_contains_state"), metadata.getString(KEY_CONTENT_DESCRIPTION), metadata.getString(KEY_REDUNDANT_WORD));
            }
            case 8: {
                return String.format(locale, StringManager.getString(locale, "result_message_content_desc_contains_action"), metadata.getString(KEY_CONTENT_DESCRIPTION), metadata.getString(KEY_REDUNDANT_WORD));
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = RedundantDescriptionCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return StringManager.getString(locale, "result_message_brief_content_desc_contains_redundant_word");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_redundant_description");
    }

    private static boolean containsWordIgnoreCase(CharSequence sequence, CharSequence word) {
        return Pattern.matches("(?s).*\\b(?i)" + word + "\\b.*", sequence.toString());
    }

    private static Locale getRecordedLocale(AccessibilityHierarchy hierarchy) {
        return hierarchy.getDeviceState().getLocale();
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 6: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 1: {
                return StringManager.getString(locale, "result_message_english_locale_only");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_no_content_desc");
            }
        }
        return null;
    }
}

