/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.LayoutParams;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextSizeCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_TEXT_VIEW = 2;
    public static final int RESULT_ID_TEXTVIEW_EMPTY = 3;
    public static final int RESULT_ID_SMALL_FIXED_TEXT_SIZE = 4;
    public static final int RESULT_ID_FIXED_TEXT_SIZE = 5;
    public static final int RESULT_ID_TEXT_SIZE_NOT_AVAILABLE = 6;
    public static final int RESULT_ID_TOOLBAR_TITLE_IN_DIP = 9;
    public static final int RESULT_ID_DIALOG_TITLE_IN_PX = 10;
    public static final int RESULT_ID_TAB_IN_PX = 11;
    public static final int RESULT_ID_TEXT_SIZE_IN_PX = 12;
    public static final int RESULT_ID_FIXED_WIDTH_TEXT_VIEW_WITH_SCALABLE_TEXT = 31;
    public static final int RESULT_ID_FIXED_HEIGHT_TEXT_VIEW_WITH_SCALABLE_TEXT = 32;
    public static final int RESULT_ID_FIXED_SIZE_TEXT_VIEW_WITH_SCALABLE_TEXT = 33;
    public static final int RESULT_ID_FIXED_WIDTH_VIEW_GROUP_WITH_SCALABLE_TEXT = 34;
    public static final int RESULT_ID_FIXED_HEIGHT_VIEW_GROUP_WITH_SCALABLE_TEXT = 35;
    public static final int RESULT_ID_FIXED_SIZE_VIEW_GROUP_WITH_SCALABLE_TEXT = 36;
    @VisibleForTesting
    static final float MIN_TEXT_SIZE = 16.0f;
    @VisibleForTesting
    static final float ADEQUATE_TEXT_SIZE = 28.0f;
    private static final float OCCUPIED_FRACTION_THRESHOLD = 0.7f;
    @VisibleForTesting
    static final int COMPLEX_UNIT_DIP = 1;
    @VisibleForTesting
    static final int COMPLEX_UNIT_IN = 4;
    @VisibleForTesting
    static final int COMPLEX_UNIT_MM = 5;
    @VisibleForTesting
    static final int COMPLEX_UNIT_PX = 0;
    @VisibleForTesting
    static final int COMPLEX_UNIT_PT = 3;
    @VisibleForTesting
    static final int COMPLEX_UNIT_SP = 2;
    private static final ImmutableMap<Integer, String> SIZE_UNIT_TO_STRING_MAP = ImmutableMap.builder().put((Object)1, (Object)"dip").put((Object)4, (Object)"in").put((Object)5, (Object)"mm").put((Object)3, (Object)"pt").put((Object)0, (Object)"px").buildOrThrow();
    public static final String KEY_TEXT_SIZE_UNIT = "KEY_TEXT_SIZE_UNIT";
    public static final String KEY_ESTIMATED_TEXT_SIZE_DP = "KEY_ESTIMATED_TEXT_SIZE_DP";
    public static final String KEY_IS_AGAINST_SCROLLABLE_EDGE = "KEY_IS_AGAINST_SCROLLABLE_EDGE";
    public static final String KEY_TEXT = "KEY_TEXT";
    private static final String KEY_OCCUPIED_FRACTION_OF_WIDTH = "KEY_OCCUPIED_FRACTION_OF_WIDTH";
    private static final String KEY_OCCUPIED_FRACTION_OF_HEIGHT = "KEY_OCCUPIED_FRACTION_OF_HEIGHT";
    private static final Class<? extends AccessibilityHierarchyCheck> CHECK_CLASS = TextSizeCheck.class;
    private static final String DIALOG_TITLE_CLASS_NAME = "com.android.internal.widget.DialogTitle";
    private static final String MATERIAL_TAB_LAYOUT = "com.google.android.material.tabs.TabLayout";
    private static final ImmutableList<String> TOOLBAR_CLASS_NAME_LIST = ImmutableList.of((Object)"android.support.v7.widget.Toolbar", (Object)"android.widget.Toolbar", (Object)"androidx.appcompat.widget.Toolbar");

    @Override
    protected @Nullable String getHelpTopic() {
        return "12159181";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        ArrayListMultimap collector = ArrayListMultimap.create();
        List<? extends ViewHierarchyElement> viewsToEval = TextSizeCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.checkInstanceOf("android.widget.TextView")) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (TextUtils.isEmpty(viewHierarchyElement.getText()) && TextUtils.isEmpty(viewHierarchyElement.getHintText())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            Float textSize = viewHierarchyElement.getTextSize();
            Integer textSizeUnit = viewHierarchyElement.getTextSizeUnit();
            if (textSize == null || textSizeUnit == null || textSizeUnit < 0) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, null, 6, null));
                continue;
            }
            AccessibilityHierarchyCheckResult result = textSizeUnit == 2 ? TextSizeCheck.checkTextViewWithScalingText(viewHierarchyElement, (ListMultimap<ViewHierarchyElement, ViewHierarchyElement>)collector) : TextSizeCheck.checkTextViewWithNonScalingText(hierarchy, viewHierarchyElement, textSize.floatValue(), textSizeUnit);
            if (result == null) continue;
            results.add(result);
        }
        TextSizeCheck.processCollectedViewGroups((ListMultimap<ViewHierarchyElement, ViewHierarchyElement>)collector, results);
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextSizeCheck.generateMessageForResultId(locale, resultId, metadata);
        if (generated != null) {
            return generated;
        }
        StringBuilder builder2 = new StringBuilder(this.getBaseMessageForResultData(locale, resultId));
        TextSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
        return builder2.toString();
    }

    private String getBaseMessageForResultData(Locale locale, int resultId) {
        switch (resultId) {
            case 5: 
            case 12: {
                return StringManager.getString(locale, "result_message_fixed_text_size");
            }
            case 4: {
                return StringManager.getString(locale, "result_message_small_fixed_text_size");
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return StringManager.getString(locale, "result_message_fixed_size_text_view_with_scaled_text");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextSizeCheck.generateMessageForResultId(locale, resultId, metadata);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 4: 
            case 5: 
            case 12: {
                return String.format(locale, StringManager.getString(locale, "result_message_brief_text_size_unit"), TextSizeCheck.unitToString(((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getInt(KEY_TEXT_SIZE_UNIT)));
            }
            case 31: {
                return StringManager.getString(locale, "result_message_brief_fixed_width_text_view_with_scaled_text");
            }
            case 32: {
                return StringManager.getString(locale, "result_message_brief_fixed_height_text_view_with_scaled_text");
            }
            case 33: {
                return StringManager.getString(locale, "result_message_brief_fixed_size_text_view_with_scaled_text");
            }
            case 34: {
                return StringManager.getString(locale, "result_message_brief_fixed_width_view_group_with_scaled_text");
            }
            case 35: {
                return StringManager.getString(locale, "result_message_brief_fixed_height_view_group_with_scaled_text");
            }
            case 36: {
                return StringManager.getString(locale, "result_message_brief_fixed_size_view_group_with_scaled_text");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_text_size");
    }

    private static void appendMetadataStringsToMessageIfNeeded(Locale locale, @Nullable ResultMetadata metadata, StringBuilder builder2) {
        if (metadata == null) {
            return;
        }
        if (metadata.getBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, false)) {
            builder2.append(' ').append(StringManager.getString(locale, "result_message_addendum_against_scrollable_edge"));
        }
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        switch (resultId) {
            case 6: {
                return StringManager.getString(locale, "result_message_no_text_size_unit");
            }
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_text_view");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_textview_empty");
            }
            case 9: {
                return String.format(locale, StringManager.getString(locale, "result_message_item_type_with_text_size_unit"), "Toolbar", TextSizeCheck.unitToString(((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getInt(KEY_TEXT_SIZE_UNIT)));
            }
            case 10: {
                return String.format(locale, StringManager.getString(locale, "result_message_item_type_with_text_size_unit"), "DialogTitle", TextSizeCheck.unitToString(((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getInt(KEY_TEXT_SIZE_UNIT)));
            }
            case 11: {
                return String.format(locale, StringManager.getString(locale, "result_message_item_type_with_text_size_unit"), "Tab", TextSizeCheck.unitToString(((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getInt(KEY_TEXT_SIZE_UNIT)));
            }
        }
        return null;
    }

    private static @Nullable AccessibilityHierarchyCheckResult checkTextViewWithScalingText(ViewHierarchyElement textView, ListMultimap<ViewHierarchyElement, ViewHierarchyElement> collector) {
        LayoutParams layoutParams = textView.getLayoutParams();
        if (layoutParams != null && (TextSizeCheck.isFixed(layoutParams.getWidth()) || TextSizeCheck.isFixed(layoutParams.getHeight()))) {
            HashMapResultMetadata metadata = new HashMapResultMetadata();
            if (textView.isAgainstScrollableEdge()) {
                metadata.putBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, true);
            }
            OccupiedFractions occupiedFractions = TextSizeCheck.addOccupiedFractions(metadata, textView.getBoundsInScreen(), TextSizeCheck.union(textView.getTextCharacterLocations()));
            Float fontScale = textView.getWindow().getAccessibilityHierarchy().getDeviceState().getFontScale();
            if (fontScale != null) {
                metadata.putFloat("FONT_SCALE", fontScale.floatValue());
            }
            float threshold = 0.7f * (fontScale != null ? fontScale.floatValue() : 1.0f);
            int resultId = TextSizeCheck.isFixed(layoutParams.getWidth()) ? (TextSizeCheck.isFixed(layoutParams.getHeight()) ? 33 : 31) : 32;
            AccessibilityCheckResult.AccessibilityCheckResultType resultType = !textView.isAgainstScrollableEdge() && (occupiedFractions.ofWidth >= threshold && TextSizeCheck.isFixed(layoutParams.getWidth()) || occupiedFractions.ofHeight >= threshold && TextSizeCheck.isFixed(layoutParams.getHeight())) ? AccessibilityCheckResult.AccessibilityCheckResultType.WARNING : AccessibilityCheckResult.AccessibilityCheckResultType.INFO;
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, resultType, textView, resultId, metadata);
        }
        TextSizeCheck.checkViewGroupWithTextViewWithScalingText(textView.getParentView(), textView, collector);
        return null;
    }

    private static void checkViewGroupWithTextViewWithScalingText(@Nullable ViewHierarchyElement viewGroup, ViewHierarchyElement textView, ListMultimap<ViewHierarchyElement, ViewHierarchyElement> collector) {
        if (viewGroup == null) {
            return;
        }
        if (Boolean.TRUE.equals(viewGroup.canScrollForward()) || Boolean.TRUE.equals(viewGroup.canScrollBackward())) {
            return;
        }
        LayoutParams layoutParams = viewGroup.getLayoutParams();
        if (layoutParams != null && (TextSizeCheck.isFixed(layoutParams.getWidth()) || TextSizeCheck.isFixed(layoutParams.getHeight()))) {
            collector.put((Object)viewGroup, (Object)textView);
            return;
        }
        TextSizeCheck.checkViewGroupWithTextViewWithScalingText(viewGroup.getParentView(), textView, collector);
    }

    private static void processCollectedViewGroups(ListMultimap<ViewHierarchyElement, ViewHierarchyElement> collector, List<AccessibilityHierarchyCheckResult> results) {
        for (Map.Entry entry : collector.asMap().entrySet()) {
            results.add(TextSizeCheck.createViewGroupResult((ViewHierarchyElement)entry.getKey(), (List)entry.getValue()));
        }
    }

    private static AccessibilityHierarchyCheckResult createViewGroupResult(ViewHierarchyElement viewGroup, List<ViewHierarchyElement> scalableTextViews) {
        HashMapResultMetadata metadata = new HashMapResultMetadata();
        SpannableString text = scalableTextViews.get(0).getText();
        metadata.putString(KEY_TEXT, text == null ? "" : text.toString());
        if (viewGroup.isAgainstScrollableEdge()) {
            metadata.putBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, true);
        }
        Rect unionOfUnions = TextSizeCheck.union(Lists.transform(scalableTextViews, v -> TextSizeCheck.union(v.getTextCharacterLocations())));
        OccupiedFractions occupiedFractions = TextSizeCheck.addOccupiedFractions(metadata, viewGroup.getBoundsInScreen(), unionOfUnions);
        Float fontScale = viewGroup.getWindow().getAccessibilityHierarchy().getDeviceState().getFontScale();
        if (fontScale != null) {
            metadata.putFloat("FONT_SCALE", fontScale.floatValue());
        }
        float threshold = 0.7f * (fontScale != null ? fontScale.floatValue() : 1.0f);
        LayoutParams layoutParams = (LayoutParams)Preconditions.checkNotNull((Object)viewGroup.getLayoutParams());
        int resultId = TextSizeCheck.isFixed(layoutParams.getWidth()) ? (TextSizeCheck.isFixed(layoutParams.getHeight()) ? 36 : 34) : 35;
        AccessibilityCheckResult.AccessibilityCheckResultType resultType = !viewGroup.isAgainstScrollableEdge() && (occupiedFractions.ofWidth >= threshold && TextSizeCheck.isFixed(layoutParams.getWidth()) || occupiedFractions.ofHeight >= threshold && TextSizeCheck.isFixed(layoutParams.getHeight())) ? AccessibilityCheckResult.AccessibilityCheckResultType.WARNING : AccessibilityCheckResult.AccessibilityCheckResultType.INFO;
        return new AccessibilityHierarchyCheckResult(CHECK_CLASS, resultType, viewGroup, resultId, metadata);
    }

    private static boolean isFixed(int dimension) {
        return dimension != -1 && dimension != -2 && dimension != 0;
    }

    private static OccupiedFractions addOccupiedFractions(ResultMetadata metadata, Rect boundsInScreen, Rect union) {
        float occupiedFractionOfWidth = boundsInScreen.getWidth() > 0 ? (float)union.getWidth() / (float)boundsInScreen.getWidth() : 0.0f;
        float occupiedFractionOfHeight = boundsInScreen.getHeight() > 0 ? (float)union.getHeight() / (float)boundsInScreen.getHeight() : 0.0f;
        metadata.putFloat(KEY_OCCUPIED_FRACTION_OF_WIDTH, occupiedFractionOfWidth);
        metadata.putFloat(KEY_OCCUPIED_FRACTION_OF_HEIGHT, occupiedFractionOfHeight);
        return new OccupiedFractions(occupiedFractionOfWidth, occupiedFractionOfHeight);
    }

    private static Rect union(List<Rect> rectangles) {
        if ((rectangles = ImmutableList.copyOf((Iterable)Iterables.filter(rectangles, (Predicate)Predicates.not(Rect::isEmpty)))).isEmpty()) {
            return Rect.EMPTY;
        }
        int left = ((Rect)rectangles.get(0)).getLeft();
        int top = ((Rect)rectangles.get(0)).getTop();
        int right2 = ((Rect)rectangles.get(0)).getRight();
        int bottom2 = ((Rect)rectangles.get(0)).getBottom();
        for (Rect r : rectangles.subList(1, rectangles.size())) {
            left = Math.min(left, r.getLeft());
            top = Math.min(top, r.getTop());
            right2 = Math.max(right2, r.getRight());
            bottom2 = Math.max(bottom2, r.getBottom());
        }
        return new Rect(left, top, right2, bottom2);
    }

    private static @Nullable AccessibilityHierarchyCheckResult checkTextViewWithNonScalingText(AccessibilityHierarchy hierarchy, ViewHierarchyElement view2, float textSize, int textSizeUnit) {
        float textSizeDp = textSize / TextSizeCheck.getDensity(hierarchy);
        if (textSizeDp >= 28.0f) {
            return null;
        }
        boolean isSmallText = textSizeDp < 16.0f;
        boolean isToolbarTitleInDip = textSizeUnit == 1 && TextSizeCheck.isToolbarTitle(view2);
        boolean isDialogTitleInPx = textSizeUnit == 0 && TextSizeCheck.isDialogTitle(view2);
        boolean inMaterialTabLayoutInPx = textSizeUnit == 0 && TextSizeCheck.inMaterialTabLayout(view2);
        HashMapResultMetadata metadata = new HashMapResultMetadata();
        metadata.putInt(KEY_TEXT_SIZE_UNIT, textSizeUnit);
        metadata.putFloat(KEY_ESTIMATED_TEXT_SIZE_DP, textSizeDp);
        return new AccessibilityHierarchyCheckResult(CHECK_CLASS, TextSizeCheck.getResultTypeForFixedTextSize(isSmallText, isToolbarTitleInDip, isDialogTitleInPx, inMaterialTabLayoutInPx, textSizeUnit == 0), view2, TextSizeCheck.getResultIdForFixedTextSize(isSmallText, isToolbarTitleInDip, isDialogTitleInPx, inMaterialTabLayoutInPx, textSizeUnit == 0), metadata);
    }

    private static AccessibilityCheckResult.AccessibilityCheckResultType getResultTypeForFixedTextSize(boolean isSmallText, boolean isToolbarTitleInDip, boolean isDialogTitleInPx, boolean inMaterialTabLayoutInPx, boolean textSizeInPx) {
        if (isToolbarTitleInDip || isDialogTitleInPx || inMaterialTabLayoutInPx || textSizeInPx) {
            return AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN;
        }
        return isSmallText ? AccessibilityCheckResult.AccessibilityCheckResultType.ERROR : AccessibilityCheckResult.AccessibilityCheckResultType.WARNING;
    }

    private static int getResultIdForFixedTextSize(boolean isSmallText, boolean isToolbarTitleInDip, boolean isDialogTitleInPx, boolean inMaterialTabLayoutInPx, boolean textSizeInPx) {
        if (isToolbarTitleInDip) {
            return 9;
        }
        if (isDialogTitleInPx) {
            return 10;
        }
        if (inMaterialTabLayoutInPx) {
            return 11;
        }
        if (textSizeInPx) {
            return 12;
        }
        if (isSmallText) {
            return 4;
        }
        return 5;
    }

    private static boolean isToolbarTitle(ViewHierarchyElement view2) {
        ViewHierarchyElement parent = view2.getParentView();
        return parent != null && parent.checkInstanceOfAny((List<String>)TOOLBAR_CLASS_NAME_LIST);
    }

    private static boolean isDialogTitle(ViewHierarchyElement view2) {
        return view2.checkInstanceOf(DIALOG_TITLE_CLASS_NAME);
    }

    private static boolean inMaterialTabLayout(ViewHierarchyElement view2) {
        ViewHierarchyElement parent = view2.getParentView();
        return view2.checkInstanceOf(MATERIAL_TAB_LAYOUT) || parent != null && TextSizeCheck.inMaterialTabLayout(parent);
    }

    private static String unitToString(int unit2) {
        return (String)SIZE_UNIT_TO_STRING_MAP.getOrDefault((Object)unit2, (Object)"?");
    }

    private static float getDensity(AccessibilityHierarchy hierarchy) {
        return ((DisplayInfo.Metrics)Preconditions.checkNotNull((Object)hierarchy.getDeviceState().getDefaultDisplayInfo().getRealMetrics())).getScaledDensity();
    }

    private static class OccupiedFractions {
        final float ofWidth;
        final float ofHeight;

        OccupiedFractions(float ofWidth, float ofHeight) {
            this.ofWidth = ofWidth;
            this.ofHeight = ofHeight;
        }
    }
}

