/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Point;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TouchTargetSizeCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_CLICKABLE = 1;
    public static final int RESULT_ID_NOT_VISIBLE = 2;
    public static final int RESULT_ID_SMALL_TOUCH_TARGET_WIDTH_AND_HEIGHT = 3;
    public static final int RESULT_ID_SMALL_TOUCH_TARGET_HEIGHT = 4;
    public static final int RESULT_ID_SMALL_TOUCH_TARGET_WIDTH = 5;
    public static final int RESULT_ID_CUSTOMIZED_SMALL_TOUCH_TARGET_WIDTH_AND_HEIGHT = 6;
    public static final int RESULT_ID_CUSTOMIZED_SMALL_TOUCH_TARGET_HEIGHT = 7;
    public static final int RESULT_ID_CUSTOMIZED_SMALL_TOUCH_TARGET_WIDTH = 8;
    public static final String KEY_HAS_TOUCH_DELEGATE = "KEY_HAS_TOUCH_DELEGATE";
    public static final String KEY_HAS_TOUCH_DELEGATE_WITH_HIT_RECT = "KEY_HAS_TOUCH_DELEGATE_WITH_HIT_RECT";
    public static final String KEY_HAS_CLICKABLE_ANCESTOR = "KEY_HAS_CLICKABLE_ANCESTOR";
    public static final String KEY_IS_AGAINST_SCROLLABLE_EDGE = "KEY_IS_AGAINST_SCROLLABLE_EDGE";
    public static final String KEY_IS_CLIPPED_BY_ANCESTOR = "KEY_IS_CLIPPED_BY_ANCESTOR";
    public static final String KEY_IS_WEB_CONTENT = "KEY_IS_WEB_CONTENT";
    public static final String KEY_HEIGHT = "KEY_HEIGHT";
    public static final String KEY_WIDTH = "KEY_WIDTH";
    public static final String KEY_NONCLIPPED_HEIGHT = "KEY_NONCLIPPED_HEIGHT";
    public static final String KEY_NONCLIPPED_WIDTH = "KEY_NONCLIPPED_WIDTH";
    public static final String KEY_REQUIRED_HEIGHT = "KEY_REQUIRED_HEIGHT";
    public static final String KEY_REQUIRED_WIDTH = "KEY_REQUIRED_WIDTH";
    public static final String KEY_CUSTOMIZED_REQUIRED_WIDTH = "KEY_CUSTOMIZED_REQUIRED_WIDTH";
    public static final String KEY_CUSTOMIZED_REQUIRED_HEIGHT = "KEY_CUSTOMIZED_REQUIRED_HEIGHT";
    public static final String KEY_HIT_RECT_WIDTH = "KEY_HIT_RECT_WIDTH";
    public static final String KEY_HIT_RECT_HEIGHT = "KEY_HIT_RECT_HEIGHT";
    @VisibleForTesting
    static final int TYPE_INPUT_METHOD = 2;
    private static final int TOUCH_TARGET_MIN_HEIGHT = 48;
    private static final int TOUCH_TARGET_MIN_WIDTH = 48;
    private static final int TOUCH_TARGET_MIN_HEIGHT_ON_EDGE = 32;
    private static final int TOUCH_TARGET_MIN_WIDTH_ON_EDGE = 32;
    private static final int TOUCH_TARGET_MIN_HEIGHT_IME_CONTAINER = 32;
    private static final int TOUCH_TARGET_MIN_WIDTH_IME_CONTAINER = 32;

    @Override
    protected String getHelpTopic() {
        return "7101858";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.TOUCH_TARGET_SIZE;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        DisplayInfo defaultDisplay = hierarchy.getDeviceState().getDefaultDisplayInfo();
        DisplayInfo.Metrics metricsWithoutDecorations = defaultDisplay.getMetricsWithoutDecoration();
        List<? extends ViewHierarchyElement> viewsToEval = TouchTargetSizeCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            Integer customizedTouchTargetSize;
            if (!Boolean.TRUE.equals(viewHierarchyElement.isClickable()) && !Boolean.TRUE.equals(viewHierarchyElement.isLongClickable())) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            Rect bounds2 = viewHierarchyElement.getBoundsInScreen();
            Point requiredSize = TouchTargetSizeCheck.getMinimumAllowableSizeForView(viewHierarchyElement, parameters);
            float density = metricsWithoutDecorations.getDensity();
            int actualHeight = Math.round((float)bounds2.getHeight() / density);
            int actualWidth = Math.round((float)bounds2.getWidth() / density);
            if (TouchTargetSizeCheck.meetsRequiredSize(bounds2, requiredSize, density)) continue;
            boolean hasDelegate = false;
            Rect largestDelegateHitRect = null;
            if (TouchTargetSizeCheck.hasTouchDelegateWithHitRects(viewHierarchyElement)) {
                hasDelegate = true;
                if (TouchTargetSizeCheck.hasTouchDelegateOfRequiredSize(viewHierarchyElement, requiredSize, density)) continue;
                largestDelegateHitRect = TouchTargetSizeCheck.getLargestTouchDelegateHitRect(viewHierarchyElement);
            } else {
                hasDelegate = TouchTargetSizeCheck.hasAncestorWithTouchDelegate(viewHierarchyElement);
            }
            boolean hasClickableAncestor = TouchTargetSizeCheck.hasQualifyingClickableAncestor(viewHierarchyElement, parameters);
            boolean isClippedByAncestor = TouchTargetSizeCheck.hasQualifyingClippingAncestor(viewHierarchyElement, requiredSize, density);
            boolean isWebContent = TouchTargetSizeCheck.hasWebViewAncestor(viewHierarchyElement);
            AccessibilityCheckResult.AccessibilityCheckResultType resultType = hasDelegate && largestDelegateHitRect == null || hasClickableAncestor || isClippedByAncestor || isWebContent ? AccessibilityCheckResult.AccessibilityCheckResultType.WARNING : AccessibilityCheckResult.AccessibilityCheckResultType.ERROR;
            boolean isAtScrollableEdge = viewHierarchyElement.isAgainstScrollableEdge();
            resultType = isAtScrollableEdge ? AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN : resultType;
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putInt(KEY_HEIGHT, actualHeight);
            resultMetadata.putInt(KEY_WIDTH, actualWidth);
            if (hasDelegate) {
                if (largestDelegateHitRect != null) {
                    resultMetadata.putBoolean(KEY_HAS_TOUCH_DELEGATE_WITH_HIT_RECT, true);
                    resultMetadata.putInt(KEY_HIT_RECT_WIDTH, Math.round((float)largestDelegateHitRect.getWidth() / density));
                    resultMetadata.putInt(KEY_HIT_RECT_HEIGHT, Math.round((float)largestDelegateHitRect.getHeight() / density));
                } else {
                    resultMetadata.putBoolean(KEY_HAS_TOUCH_DELEGATE, true);
                }
            }
            if (hasClickableAncestor) {
                resultMetadata.putBoolean(KEY_HAS_CLICKABLE_ANCESTOR, true);
            }
            if (isAtScrollableEdge) {
                resultMetadata.putBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, true);
            }
            if (isClippedByAncestor) {
                resultMetadata.putBoolean(KEY_IS_CLIPPED_BY_ANCESTOR, true);
                resultMetadata.putInt(KEY_NONCLIPPED_HEIGHT, (Integer)Preconditions.checkNotNull((Object)viewHierarchyElement.getNonclippedHeight()));
                resultMetadata.putInt(KEY_NONCLIPPED_WIDTH, (Integer)Preconditions.checkNotNull((Object)viewHierarchyElement.getNonclippedWidth()));
            }
            if (isWebContent) {
                resultMetadata.putBoolean(KEY_IS_WEB_CONTENT, true);
            }
            Integer n = customizedTouchTargetSize = parameters == null ? null : parameters.getCustomTouchTargetSize();
            if (customizedTouchTargetSize != null) {
                resultMetadata.putInt(KEY_CUSTOMIZED_REQUIRED_WIDTH, requiredSize.getX());
                resultMetadata.putInt(KEY_CUSTOMIZED_REQUIRED_HEIGHT, requiredSize.getY());
            } else {
                resultMetadata.putInt(KEY_REQUIRED_HEIGHT, requiredSize.getY());
                resultMetadata.putInt(KEY_REQUIRED_WIDTH, requiredSize.getX());
            }
            if (actualHeight < requiredSize.getY() && actualWidth < requiredSize.getX()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), resultType, viewHierarchyElement, customizedTouchTargetSize == null ? 3 : 6, resultMetadata));
                continue;
            }
            if (actualHeight < requiredSize.getY()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), resultType, viewHierarchyElement, customizedTouchTargetSize == null ? 4 : 7, resultMetadata));
                continue;
            }
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), resultType, viewHierarchyElement, customizedTouchTargetSize == null ? 5 : 8, resultMetadata));
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TouchTargetSizeCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        Preconditions.checkNotNull((Object)metadata);
        StringBuilder builder2 = new StringBuilder();
        int requiredHeight = metadata.getInt(KEY_REQUIRED_HEIGHT, 48);
        int requiredWidth = metadata.getInt(KEY_REQUIRED_WIDTH, 48);
        switch (resultId) {
            case 3: {
                builder2.append(String.format(locale, StringManager.getString(locale, "result_message_small_touch_target_width_and_height"), metadata.getInt(KEY_WIDTH), metadata.getInt(KEY_HEIGHT), requiredWidth, requiredHeight));
                TouchTargetSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
                return builder2.toString();
            }
            case 4: {
                builder2.append(String.format(locale, StringManager.getString(locale, "result_message_small_touch_target_height"), metadata.getInt(KEY_HEIGHT), requiredHeight));
                TouchTargetSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
                return builder2.toString();
            }
            case 5: {
                builder2.append(String.format(locale, StringManager.getString(locale, "result_message_small_touch_target_width"), metadata.getInt(KEY_WIDTH), requiredWidth));
                TouchTargetSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
                return builder2.toString();
            }
            case 6: {
                builder2.append(String.format(locale, StringManager.getString(locale, "result_message_customized_small_touch_target_width_and_height"), metadata.getInt(KEY_WIDTH), metadata.getInt(KEY_HEIGHT), metadata.getInt(KEY_CUSTOMIZED_REQUIRED_WIDTH), metadata.getInt(KEY_CUSTOMIZED_REQUIRED_HEIGHT)));
                TouchTargetSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
                return builder2.toString();
            }
            case 7: {
                builder2.append(String.format(locale, StringManager.getString(locale, "result_message_customized_small_touch_target_height"), metadata.getInt(KEY_HEIGHT), metadata.getInt(KEY_CUSTOMIZED_REQUIRED_HEIGHT)));
                TouchTargetSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
                return builder2.toString();
            }
            case 8: {
                builder2.append(String.format(locale, StringManager.getString(locale, "result_message_customized_small_touch_target_width"), metadata.getInt(KEY_WIDTH), metadata.getInt(KEY_CUSTOMIZED_REQUIRED_WIDTH)));
                TouchTargetSizeCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder2);
                return builder2.toString();
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TouchTargetSizeCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return StringManager.getString(locale, "result_message_brief_small_touch_target");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public @Nullable Double getSecondaryPriority(AccessibilityHierarchyCheckResult result) {
        int height2;
        ResultMetadata meta = result.getMetadata();
        if (meta == null) {
            return null;
        }
        int width2 = meta.getInt(KEY_WIDTH, Integer.MAX_VALUE);
        double primary = Math.min(width2, height2 = meta.getInt(KEY_HEIGHT, Integer.MAX_VALUE));
        if (primary == 2.147483647E9) {
            return null;
        }
        double secondary = 1.0 / Math.exp((double)Math.max(width2, height2) / 30.0);
        return -(primary - secondary);
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_touch_target_size");
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_clickable");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
        }
        return null;
    }

    private static Point getMinimumAllowableSizeForView(ViewHierarchyElement view2, @Nullable Parameters parameters) {
        int requiredHeight;
        int requiredWidth;
        int touchTargetMinWidthOnEdge;
        int touchTargetMinHeightOnEdge;
        int touchTargetMinWidthImeContainer;
        int touchTargetMinHeightImeContainer;
        int touchTargetMinHeight;
        int touchTargetMinWidth;
        Integer customizedTargetSize;
        Rect bounds2 = view2.getBoundsInScreen();
        DisplayInfo.Metrics realMetrics = view2.getWindow().getAccessibilityHierarchy().getDeviceState().getDefaultDisplayInfo().getRealMetrics();
        Integer n = customizedTargetSize = parameters == null ? null : parameters.getCustomTouchTargetSize();
        if (customizedTargetSize != null) {
            float targetSize = customizedTargetSize.intValue();
            touchTargetMinWidth = customizedTargetSize;
            touchTargetMinHeight = customizedTargetSize;
            touchTargetMinHeightImeContainer = Math.round(32.0f * targetSize / 48.0f);
            touchTargetMinWidthImeContainer = Math.round(32.0f * targetSize / 48.0f);
            touchTargetMinHeightOnEdge = Math.round(32.0f * targetSize / 48.0f);
            touchTargetMinWidthOnEdge = Math.round(32.0f * targetSize / 48.0f);
        } else {
            touchTargetMinWidth = 48;
            touchTargetMinHeight = 48;
            touchTargetMinHeightImeContainer = 32;
            touchTargetMinWidthImeContainer = 32;
            touchTargetMinHeightOnEdge = 32;
            touchTargetMinWidthOnEdge = 32;
        }
        Integer windowType = view2.getWindow().getType();
        if (windowType != null && windowType == 2) {
            requiredWidth = touchTargetMinWidthImeContainer;
            requiredHeight = touchTargetMinHeightImeContainer;
        } else if (realMetrics != null) {
            boolean viewAgainstSide = bounds2.getLeft() == 0 || bounds2.getRight() == realMetrics.getWidthPixels();
            boolean viewAgainstTopOrBottom = bounds2.getTop() == 0 || bounds2.getBottom() == realMetrics.getHeightPixels();
            requiredWidth = viewAgainstSide ? touchTargetMinWidthOnEdge : touchTargetMinWidth;
            requiredHeight = viewAgainstTopOrBottom ? touchTargetMinHeightOnEdge : touchTargetMinHeight;
        } else {
            requiredWidth = Math.min(touchTargetMinWidthOnEdge, touchTargetMinWidth);
            requiredHeight = Math.min(touchTargetMinHeightOnEdge, touchTargetMinHeight);
        }
        return new Point(requiredWidth, requiredHeight);
    }

    private static boolean meetsRequiredSize(Rect boundingRectInPx, Point requiredSizeInDp, float density) {
        return Math.round((float)boundingRectInPx.getWidth() / density) >= requiredSizeInDp.getX() && Math.round((float)boundingRectInPx.getHeight() / density) >= requiredSizeInDp.getY();
    }

    private static boolean hasTouchDelegateWithHitRects(ViewHierarchyElement view2) {
        return !view2.getTouchDelegateBounds().isEmpty();
    }

    private static boolean hasTouchDelegateOfRequiredSize(ViewHierarchyElement view2, Point requiredSizeInDp, float density) {
        for (Rect hitRect : view2.getTouchDelegateBounds()) {
            if (!TouchTargetSizeCheck.meetsRequiredSize(hitRect, requiredSizeInDp, density)) continue;
            return true;
        }
        return false;
    }

    private static @Nullable Rect getLargestTouchDelegateHitRect(ViewHierarchyElement view2) {
        int largestArea = -1;
        Rect largestHitRect = null;
        for (Rect hitRect : view2.getTouchDelegateBounds()) {
            int area = hitRect.getWidth() * hitRect.getHeight();
            if (area <= largestArea) continue;
            largestArea = area;
            largestHitRect = hitRect;
        }
        return largestHitRect;
    }

    private static boolean hasAncestorWithTouchDelegate(ViewHierarchyElement view2) {
        for (ViewHierarchyElement evalView = view2.getParentView(); evalView != null; evalView = evalView.getParentView()) {
            if (!Boolean.TRUE.equals(evalView.hasTouchDelegate())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasQualifyingClickableAncestor(ViewHierarchyElement view2, @Nullable Parameters parameters) {
        boolean isTargetClickable = Boolean.TRUE.equals(view2.isClickable());
        boolean isTargetLongClickable = Boolean.TRUE.equals(view2.isLongClickable());
        for (ViewHierarchyElement evalView = view2.getParentView(); evalView != null; evalView = evalView.getParentView()) {
            if ((!Boolean.TRUE.equals(evalView.isClickable()) || !isTargetClickable) && (!Boolean.TRUE.equals(evalView.isLongClickable()) || !isTargetLongClickable)) continue;
            Point requiredSize = TouchTargetSizeCheck.getMinimumAllowableSizeForView(evalView, parameters);
            Rect bounds2 = evalView.getBoundsInScreen();
            if (evalView.checkInstanceOf("android.widget.AbsListView") || bounds2.getHeight() < requiredSize.getY() || bounds2.getWidth() < requiredSize.getX()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasQualifyingClippingAncestor(ViewHierarchyElement view2, Point requiredSize, float density) {
        Integer rawNonclippedHeight = view2.getNonclippedHeight();
        Integer rawNonclippedWidth = view2.getNonclippedWidth();
        if (rawNonclippedHeight == null || rawNonclippedWidth == null) {
            return false;
        }
        Rect clippedBounds = view2.getBoundsInScreen();
        int clippedHeight = (int)((float)clippedBounds.getHeight() / density);
        int clippedWidth = (int)((float)clippedBounds.getWidth() / density);
        int nonclippedHeight = (int)((float)rawNonclippedHeight.intValue() / density);
        int nonclippedWidth = (int)((float)rawNonclippedWidth.intValue() / density);
        boolean clippedTooSmallY = clippedHeight < requiredSize.getY();
        boolean clippedTooSmallX = clippedWidth < requiredSize.getX();
        boolean nonclippedTooSmallY = nonclippedHeight < requiredSize.getY();
        boolean nonclippedTooSmallX = nonclippedWidth < requiredSize.getX();
        return clippedTooSmallY && !nonclippedTooSmallY || clippedTooSmallX && !nonclippedTooSmallX;
    }

    private static boolean hasWebViewAncestor(ViewHierarchyElement view2) {
        ViewHierarchyElement parent = view2.getParentView();
        return parent != null && (parent.checkInstanceOf("android.webkit.WebView") || TouchTargetSizeCheck.hasWebViewAncestor(parent));
    }

    private static void appendMetadataStringsToMessageIfNeeded(Locale locale, ResultMetadata resultMetadata, StringBuilder builder2) {
        boolean hasDelegate = resultMetadata.getBoolean(KEY_HAS_TOUCH_DELEGATE, false);
        boolean hasDelegateWithHitRect = resultMetadata.getBoolean(KEY_HAS_TOUCH_DELEGATE_WITH_HIT_RECT, false);
        boolean hasClickableAncestor = resultMetadata.getBoolean(KEY_HAS_CLICKABLE_ANCESTOR, false);
        boolean isClippedByAncestor = resultMetadata.getBoolean(KEY_IS_CLIPPED_BY_ANCESTOR, false);
        boolean isAgainstScrollableEdge = resultMetadata.getBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, false);
        boolean isWebContent = resultMetadata.getBoolean(KEY_IS_WEB_CONTENT, false);
        if (hasDelegateWithHitRect) {
            builder2.append(' ').append(String.format(locale, StringManager.getString(locale, "result_message_addendum_touch_delegate_with_hit_rect"), resultMetadata.getInt(KEY_HIT_RECT_WIDTH), resultMetadata.getInt(KEY_HIT_RECT_HEIGHT)));
        } else if (hasDelegate) {
            builder2.append(' ').append(StringManager.getString(locale, "result_message_addendum_touch_delegate"));
        }
        if (isWebContent) {
            builder2.append(' ').append(StringManager.getString(locale, "result_message_addendum_web_touch_target_size"));
        } else if (hasClickableAncestor) {
            builder2.append(' ').append(StringManager.getString(locale, "result_message_addendum_clickable_ancestor"));
        }
        if (isClippedByAncestor) {
            builder2.append(' ').append(String.format(locale, StringManager.getString(locale, "result_message_addendum_clipped_by_ancestor"), resultMetadata.getInt(KEY_NONCLIPPED_WIDTH), resultMetadata.getInt(KEY_NONCLIPPED_HEIGHT)));
        }
        if (isAgainstScrollableEdge) {
            builder2.append(' ').append(StringManager.getString(locale, "result_message_addendum_against_scrollable_edge"));
        }
    }
}

