/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.ocr;

import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextComponent {
    private final String value;
    private final Rect boundsInScreen;
    private final @Nullable String language;
    private final @Nullable Float confidence;
    private final ImmutableList<TextComponent> components;

    private TextComponent(String value2, Rect boundsInScreen, @Nullable String language, @Nullable Float confidence, ImmutableList<TextComponent> components) {
        this.value = value2;
        this.boundsInScreen = boundsInScreen;
        this.language = language;
        this.confidence = confidence;
        this.components = components;
    }

    TextComponent(AccessibilityEvaluationProtos.TextComponentProto proto) {
        this.value = proto.getValue();
        this.boundsInScreen = new Rect(proto.getBoundsInScreen());
        this.language = proto.hasLanguage() ? proto.getLanguage() : null;
        this.confidence = proto.hasConfidence() ? Float.valueOf(proto.getConfidence()) : null;
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        for (int i = 0; i < proto.getComponentsCount(); ++i) {
            builder2.add((Object)new TextComponent(proto.getComponents(i)));
        }
        this.components = builder2.build();
    }

    public String getValue() {
        return this.value;
    }

    public Rect getBoundsInScreen() {
        return this.boundsInScreen;
    }

    public @Nullable String getLanguage() {
        return this.language;
    }

    public @Nullable Float getConfidence() {
        return this.confidence;
    }

    public List<TextComponent> getComponents() {
        return this.components;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextComponent)) {
            return false;
        }
        TextComponent that = (TextComponent)o;
        return this.value.equals(that.getValue()) && this.boundsInScreen.equals(that.getBoundsInScreen()) && Objects.equals(this.language, that.getLanguage()) && Objects.equals(this.confidence, that.getConfidence()) && this.components.equals(that.getComponents());
    }

    public int hashCode() {
        return Objects.hash(this.value, this.boundsInScreen, this.language, this.confidence, this.components);
    }

    public static Builder newBuilder(String value2, Rect boundsInScreen) {
        return new Builder(value2, boundsInScreen);
    }

    AccessibilityEvaluationProtos.TextComponentProto toProto() {
        AccessibilityEvaluationProtos.TextComponentProto.Builder builder2 = AccessibilityEvaluationProtos.TextComponentProto.newBuilder().setValue(this.value).setBoundsInScreen(this.boundsInScreen.toProto());
        if (this.language != null) {
            builder2.setLanguage(this.language);
        }
        if (this.confidence != null) {
            builder2.setConfidence(this.confidence.floatValue());
        }
        for (TextComponent text : this.components) {
            builder2.addComponents(text.toProto());
        }
        return (AccessibilityEvaluationProtos.TextComponentProto)builder2.build();
    }

    public static class Builder {
        private final Rect boundsInScreen;
        private final String value;
        private @Nullable String language;
        private @Nullable Float confidence;
        private ImmutableList<TextComponent> components = ImmutableList.of();

        private Builder(String value2, Rect boundsInScreen) {
            this.value = value2;
            this.boundsInScreen = boundsInScreen;
        }

        @CanIgnoreReturnValue
        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConfidence(float confidence) {
            this.confidence = Float.valueOf(confidence);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTextComponents(ImmutableList<TextComponent> textComponents) {
            this.components = textComponents;
            return this;
        }

        public TextComponent build() {
            return new TextComponent(this.value, this.boundsInScreen, this.language, this.confidence, this.components);
        }
    }
}

