/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import android.text.NoCopySpan;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.text.style.StyleSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Spans;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SpannableStringAndroid
extends SpannableString {
    public SpannableStringAndroid(CharSequence text) {
        super((CharSequence)Preconditions.checkNotNull((Object)text));
        if (text instanceof Spanned) {
            this.spans = SpannableStringAndroid.getSpansAndroid((Spanned)text);
        } else if (text instanceof SpannableString) {
            SpannableString spannableString = (SpannableString)text;
            this.spans = ImmutableList.copyOf(spannableString.getSpans());
        } else {
            this.spans = ImmutableList.of();
        }
    }

    public static @Nullable SpannableStringAndroid valueOf(@Nullable CharSequence source) {
        if (TextUtils.isEmpty(source)) {
            return null;
        }
        if (source instanceof SpannableStringAndroid) {
            return (SpannableStringAndroid)source;
        }
        return new SpannableStringAndroid(source);
    }

    private static ImmutableList<Span> getSpansAndroid(Spanned spanned) {
        if (TextUtils.isEmpty(spanned)) {
            return ImmutableList.of();
        }
        int length = spanned.length();
        ImmutableList.Builder spansBuilder = ImmutableList.builder();
        Object[] spans = spanned.getSpans(0, length - 1, Object.class);
        for (int i = 0; i < spans.length; ++i) {
            Span newSpan;
            int start = spanned.getSpanStart(spans[i]);
            int end = spanned.getSpanEnd(spans[i]);
            int flags = spanned.getSpanFlags(spans[i]);
            if (spans[i] instanceof NoCopySpan) continue;
            if (spans[i] instanceof URLSpan) {
                URLSpan androidUrlSpan = (URLSpan)spans[i];
                newSpan = new Spans.URLSpan("android.text.style.URLSpan", start, end, flags, androidUrlSpan.getURL());
            } else if (spans[i] instanceof ClickableSpan) {
                newSpan = new Spans.ClickableSpan("android.text.style.ClickableSpan", start, end, flags);
            } else if (spans[i] instanceof StyleSpan) {
                StyleSpan androidStyleSpan = (StyleSpan)spans[i];
                newSpan = new Spans.StyleSpan("android.text.style.StyleSpan", start, end, flags, androidStyleSpan.getStyle());
            } else {
                newSpan = spans[i] instanceof UnderlineSpan ? new Spans.UnderlineSpan("android.text.style.UnderlineSpan", start, end, flags) : new Span(spans[i].getClass().getName(), start, end, flags);
            }
            spansBuilder.add((Object)newSpan);
        }
        return spansBuilder.build();
    }
}

