/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.strings;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AndroidXMLResourceBundle
extends ResourceBundle {
    private static final String ANDROID_STRING_TAG_NAME = "string";
    private static final String ANDROID_STRING_NAME_ATTRIBUTE = "name";
    private final Properties properties = new Properties();

    private AndroidXMLResourceBundle(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull((Object)inputStream);
        Document document = AndroidXMLResourceBundle.getDocument(inputStream);
        inputStream.close();
        AndroidXMLResourceBundle.addStringsToProperties(document, this.properties);
    }

    @Override
    protected @Nullable Object handleGetObject(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.properties.stringPropertyNames());
    }

    private static Document getDocument(InputStream inputStream) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            document = documentBuilder.parse(inputSource);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Could not read xml properties file", e);
        }
        return document;
    }

    private static void addStringsToProperties(Document document, Properties properties2) {
        NodeList stringNodes = document.getElementsByTagName(ANDROID_STRING_TAG_NAME);
        for (int i = 0; i < stringNodes.getLength(); ++i) {
            Node node = stringNodes.item(i);
            if (node == null) continue;
            String key = AndroidXMLResourceBundle.getStringName(node);
            String value2 = AndroidXMLResourceBundle.getStringValue(node);
            if (key == null || value2 == null) continue;
            properties2.setProperty(key, value2);
        }
    }

    private static @Nullable String getStringName(Node node) {
        Node nameNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (nameNode = attributes.getNamedItem(ANDROID_STRING_NAME_ATTRIBUTE)) != null) {
            return nameNode.getNodeValue();
        }
        return null;
    }

    private static @Nullable String getStringValue(Node node) {
        String value2 = node.getTextContent();
        if (value2 == null) {
            return null;
        }
        return value2.trim().replace("\\\"", "\"").replace("\\'", "'");
    }

    static class Control
    extends ResourceBundle.Control {
        private static final String XML_FORMAT = "xml";
        private static final List<String> ACCEPTED_FORMATS = Collections.unmodifiableList(Arrays.asList("xml"));

        Control() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            Preconditions.checkNotNull((Object)baseName);
            return ACCEPTED_FORMATS;
        }

        @Override
        public @Nullable ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            URLConnection urlConnection;
            URL url;
            String resource = this.toResourceName(this.toBundleName(baseName, locale), XML_FORMAT);
            if (resource != null && (url = loader.getResource(resource)) != null && (urlConnection = url.openConnection()) != null) {
                InputStream inputStream;
                if (reload) {
                    urlConnection.setUseCaches(false);
                }
                if ((inputStream = urlConnection.getInputStream()) != null) {
                    AndroidXMLResourceBundle bundle = new AndroidXMLResourceBundle(inputStream);
                    inputStream.close();
                    return bundle;
                }
            }
            return null;
        }

        @Override
        public @Nullable Locale getFallbackLocale(String baseName, Locale locale) {
            return null;
        }

        @Override
        public String toBundleName(String baseName, Locale locale) {
            Preconditions.checkNotNull((Object)locale);
            Preconditions.checkNotNull((Object)baseName);
            Preconditions.checkArgument((!baseName.isEmpty() ? 1 : 0) != 0, (Object)"Attempted to get resource name for empty base name");
            String language = locale.getLanguage();
            StringBuilder localeName = new StringBuilder();
            if (!language.isEmpty()) {
                localeName.append("-");
                localeName.append(language);
                String country = locale.getCountry();
                if (!country.isEmpty()) {
                    localeName.append("-r");
                    localeName.append(country);
                }
            }
            int packageNameDividerIndex = baseName.lastIndexOf(46);
            String packageName = baseName.substring(0, packageNameDividerIndex);
            String fileName = baseName.substring(packageNameDividerIndex + 1);
            return packageName.isEmpty() ? String.format("resources%s.%s", localeName, fileName) : String.format("%s.resources%s.%s", packageName, localeName, fileName);
        }

        static String getBaseName(String packageName, String fileName) {
            return String.format("%s.%s", packageName, fileName);
        }
    }
}

