/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.strings;

import com.google.android.apps.common.testing.accessibility.framework.strings.AndroidXMLResourceBundle;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StringManager {
    private static final String STRINGS_PACKAGE_NAME = "com.google.android.apps.common.testing.accessibility.framework";
    private static final String STRINGS_FILE_NAME = "strings";
    private static @Nullable ResourceBundleProvider resourceBundleProvider;

    private StringManager() {
    }

    public static void setResourceBundleProvider(ResourceBundleProvider provider2) {
        resourceBundleProvider = provider2;
    }

    public static String getString(Locale locale, String name) {
        return StringManager.getResourceBundle(locale).getString(name);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (resourceBundleProvider != null) {
            return resourceBundleProvider.getResourceBundle(locale);
        }
        try {
            return ResourceBundle.getBundle(AndroidXMLResourceBundle.Control.getBaseName(STRINGS_PACKAGE_NAME, STRINGS_FILE_NAME), locale, (ClassLoader)Preconditions.checkNotNull((Object)StringManager.class.getClassLoader()), new AndroidXMLResourceBundle.Control());
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(AndroidXMLResourceBundle.Control.getBaseName("", STRINGS_FILE_NAME), locale, (ClassLoader)Preconditions.checkNotNull((Object)StringManager.class.getClassLoader()), new AndroidXMLResourceBundle.Control());
        }
    }

    public static interface ResourceBundleProvider {
        public ResourceBundle getResourceBundle(Locale var1);
    }
}

