/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.LayoutParams;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.CompoundFixSuggestions;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

class ExpandViewSizeFixSuggestionProducer
implements FixSuggestionProducer<FixSuggestion> {
    private static final String VIEW_ATTRIBUTE_MIN_WIDTH = "minWidth";
    private static final String VIEW_ATTRIBUTE_MIN_HEIGHT = "minHeight";
    private static final String VIEW_ATTRIBUTE_LAYOUT_WIDTH = "layout_width";
    private static final String VIEW_ATTRIBUTE_LAYOUT_HEIGHT = "layout_height";

    ExpandViewSizeFixSuggestionProducer() {
    }

    @Override
    public @Nullable FixSuggestion produceFixSuggestion(AccessibilityHierarchyCheckResult checkResult, AccessibilityHierarchy hierarchy, @Nullable Parameters parameters) {
        ViewHierarchyElement element = checkResult.getElement();
        ResultMetadata resultMetadata = checkResult.getMetadata();
        if (element == null || resultMetadata == null) {
            return null;
        }
        switch (checkResult.getResultId()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ExpandViewSizeFixSuggestionProducer.produceExpandingViewSizeSuggestion(element, resultMetadata, hierarchy);
            }
        }
        return null;
    }

    private static @Nullable FixSuggestion produceExpandingViewSizeSuggestion(ViewHierarchyElement element, ResultMetadata resultMetadata, AccessibilityHierarchy hierarchy) {
        LayoutParams layoutParams = element.getLayoutParams();
        if (layoutParams == null) {
            return null;
        }
        if (resultMetadata.getBoolean("KEY_HAS_TOUCH_DELEGATE", false) || resultMetadata.getBoolean("KEY_HAS_TOUCH_DELEGATE_WITH_HIT_RECT", false)) {
            return null;
        }
        if (resultMetadata.getBoolean("KEY_IS_CLIPPED_BY_ANCESTOR", false)) {
            return null;
        }
        if (!ExpandViewSizeFixSuggestionProducer.isParentViewBigEnoughForExpanding(hierarchy, element, resultMetadata)) {
            return null;
        }
        return ExpandViewSizeFixSuggestionProducer.createFixSuggestion(resultMetadata, layoutParams);
    }

    private static @Nullable FixSuggestion createFixSuggestion(ResultMetadata resultMetadata, LayoutParams layoutParams) {
        ImmutableList fixSuggestions;
        int widthInDp = ExpandViewSizeFixSuggestionProducer.getWidth(resultMetadata);
        int heightInDp = ExpandViewSizeFixSuggestionProducer.getHeight(resultMetadata);
        int requiredWidthInDp = ExpandViewSizeFixSuggestionProducer.getRequiredWidth(resultMetadata);
        int requiredHeightInDp = ExpandViewSizeFixSuggestionProducer.getRequiredHeight(resultMetadata);
        ImmutableList.Builder fixSuggestionBuilder = ImmutableList.builder();
        if (widthInDp < requiredWidthInDp) {
            int layoutWidth = layoutParams.getWidth();
            if (layoutWidth == -2) {
                fixSuggestionBuilder.add((Object)new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_MIN_WIDTH, requiredWidthInDp + "dp"));
            } else if (layoutWidth > 0) {
                fixSuggestionBuilder.add((Object)new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_LAYOUT_WIDTH, requiredWidthInDp + "dp"));
            }
        }
        if (heightInDp < requiredHeightInDp) {
            int layoutHeight = layoutParams.getHeight();
            if (layoutHeight == -2) {
                fixSuggestionBuilder.add((Object)new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_MIN_HEIGHT, requiredHeightInDp + "dp"));
            } else if (layoutHeight > 0) {
                fixSuggestionBuilder.add((Object)new SetViewAttributeFixSuggestion(VIEW_ATTRIBUTE_LAYOUT_HEIGHT, requiredHeightInDp + "dp"));
            }
        }
        if ((fixSuggestions = fixSuggestionBuilder.build()).isEmpty()) {
            return null;
        }
        if (fixSuggestions.size() == 1) {
            return (FixSuggestion)fixSuggestions.get(0);
        }
        return new CompoundFixSuggestions((ImmutableList<FixSuggestion>)fixSuggestions);
    }

    private static boolean isParentViewBigEnoughForExpanding(AccessibilityHierarchy hierarchy, ViewHierarchyElement view2, ResultMetadata resultMetadata) {
        ViewHierarchyElement parentView = view2.getParentView();
        if (parentView == null) {
            return false;
        }
        int requiredWidthInDp = ExpandViewSizeFixSuggestionProducer.getRequiredWidth(resultMetadata);
        int requiredHeightInDp = ExpandViewSizeFixSuggestionProducer.getRequiredHeight(resultMetadata);
        DisplayInfo defaultDisplay = hierarchy.getDeviceState().getDefaultDisplayInfo();
        float density = defaultDisplay.getMetricsWithoutDecoration().getDensity();
        Rect parentViewBoundsInScreen = parentView.getBoundsInScreen();
        return Math.round((float)parentViewBoundsInScreen.getWidth() / density) >= requiredWidthInDp && Math.round((float)parentViewBoundsInScreen.getHeight() / density) >= requiredHeightInDp;
    }

    private static int getWidth(ResultMetadata resultMetadata) {
        return resultMetadata.getInt("KEY_WIDTH");
    }

    private static int getHeight(ResultMetadata resultMetadata) {
        return resultMetadata.getInt("KEY_HEIGHT");
    }

    private static int getRequiredWidth(ResultMetadata resultMetadata) {
        if (resultMetadata.containsKey("KEY_CUSTOMIZED_REQUIRED_WIDTH")) {
            return resultMetadata.getInt("KEY_CUSTOMIZED_REQUIRED_WIDTH");
        }
        return resultMetadata.getInt("KEY_REQUIRED_WIDTH");
    }

    private static int getRequiredHeight(ResultMetadata resultMetadata) {
        if (resultMetadata.containsKey("KEY_CUSTOMIZED_REQUIRED_HEIGHT")) {
            return resultMetadata.getInt("KEY_CUSTOMIZED_REQUIRED_HEIGHT");
        }
        return resultMetadata.getInt("KEY_REQUIRED_HEIGHT");
    }
}

