/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.os.Parcel;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Spans;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

class ParcelUtils {
    private static final int ABSENT = 0;
    private static final int PRESENT = 1;
    private static final int SPAN_TYPE_UNKNOWN = 0;
    private static final int SPAN_TYPE_CLICKABLE = 1;
    private static final int SPAN_TYPE_URL = 2;
    private static final int SPAN_TYPE_STYLE = 3;
    private static final int SPAN_TYPE_UNDERLINE = 4;

    private ParcelUtils() {
    }

    public static void writeNullableInteger(Parcel out, @Nullable Integer val) {
        if (val == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeInt(val);
        }
    }

    public static @Nullable Integer readNullableInteger(Parcel in) {
        int marker = in.readInt();
        if (marker == 0) {
            return null;
        }
        if (marker == 1) {
            return in.readInt();
        }
        throw new IllegalStateException("Parcel contained unexpected marker value.");
    }

    public static void writeNullableLong(Parcel out, @Nullable Long val) {
        if (val == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeLong(val);
        }
    }

    public static @Nullable Long readNullableLong(Parcel in) {
        int marker = in.readInt();
        if (marker == 0) {
            return null;
        }
        if (marker == 1) {
            return in.readLong();
        }
        throw new IllegalStateException("Parcel contained unexpected marker value.");
    }

    public static void writeNullableFloat(Parcel out, @Nullable Float val) {
        if (val == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeFloat(val.floatValue());
        }
    }

    public static @Nullable Float readNullableFloat(Parcel in) {
        int marker = in.readInt();
        if (marker == 0) {
            return null;
        }
        if (marker == 1) {
            return Float.valueOf(in.readFloat());
        }
        throw new IllegalStateException("Parcel contained unexpected marker value.");
    }

    public static void writeNullableString(Parcel out, @Nullable String val) {
        if (val == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(val);
        }
    }

    public static @Nullable String readNullableString(Parcel in) {
        int marker = in.readInt();
        if (marker == 0) {
            return null;
        }
        if (marker == 1) {
            return in.readString();
        }
        throw new IllegalStateException("Parcel contained unexpected marker value.");
    }

    public static void writeNullableBoolean(Parcel out, @Nullable Boolean val) {
        byte byteValue = val == null ? (byte)-1 : (val != false ? (byte)1 : 0);
        out.writeByte(byteValue);
    }

    public static @Nullable Boolean readNullableBoolean(Parcel in) {
        byte byteValue = in.readByte();
        if (byteValue == -1) {
            return null;
        }
        if (byteValue == 0) {
            return false;
        }
        if (byteValue == 1) {
            return true;
        }
        throw new IllegalStateException("Parcel contained unexpected Boolean byte.");
    }

    static void writeNullableSpannableString(Parcel out, @Nullable SpannableString val) {
        if (val == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ParcelUtils.writeSpannableString(out, val);
        }
    }

    static @Nullable SpannableString readNullableSpannableString(Parcel in) {
        int marker = in.readInt();
        if (marker == 0) {
            return null;
        }
        if (marker == 1) {
            return ParcelUtils.readSpannableString(in);
        }
        throw new IllegalStateException("Parcel contained unexpected marker value.");
    }

    private static void writeSpannableString(Parcel out, SpannableString spannableString) {
        List<Span> spans = spannableString.getSpans();
        out.writeString(spannableString.toString());
        out.writeInt(spans.size());
        for (Span span : spans) {
            out.writeString(span.getSpanClassName());
            out.writeInt(span.getStart());
            out.writeInt(span.getEnd());
            out.writeInt(span.getFlags());
            if (span instanceof Spans.URLSpan) {
                out.writeInt(2);
                out.writeString(((Spans.URLSpan)span).getUrl());
                continue;
            }
            if (span instanceof Spans.ClickableSpan) {
                out.writeInt(1);
                continue;
            }
            if (span instanceof Spans.StyleSpan) {
                out.writeInt(3);
                out.writeInt(((Spans.StyleSpan)span).getStyle());
                continue;
            }
            if (span instanceof Spans.UnderlineSpan) {
                out.writeInt(4);
                continue;
            }
            out.writeInt(0);
        }
    }

    private static SpannableString readSpannableString(Parcel in) {
        String rawString = (String)Preconditions.checkNotNull((Object)in.readString());
        int spanSize = in.readInt();
        ArrayList<Span> spans = new ArrayList<Span>(spanSize);
        block7: for (int i = 0; i < spanSize; ++i) {
            String spanClassName = (String)Preconditions.checkNotNull((Object)in.readString());
            int start = in.readInt();
            int end = in.readInt();
            int flags = in.readInt();
            int spanType = in.readInt();
            switch (spanType) {
                case 0: {
                    spans.add(new Span(spanClassName, start, end, flags));
                    continue block7;
                }
                case 1: {
                    spans.add(new Spans.ClickableSpan(spanClassName, start, end, flags));
                    continue block7;
                }
                case 2: {
                    spans.add(new Spans.URLSpan(spanClassName, start, end, flags, in.readString()));
                    continue block7;
                }
                case 3: {
                    spans.add(new Spans.StyleSpan(spanClassName, start, end, flags, in.readInt()));
                    continue block7;
                }
                case 4: {
                    spans.add(new Spans.UnderlineSpan(spanClassName, start, end, flags));
                    continue block7;
                }
            }
        }
        return new SpannableString(rawString, spans);
    }

    public static void writeRectToParcel(Rect rect, Parcel out) {
        out.writeInt(rect.getLeft());
        out.writeInt(rect.getTop());
        out.writeInt(rect.getRight());
        out.writeInt(rect.getBottom());
    }

    public static Rect readRectFromParcel(Parcel in) {
        return new Rect(in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    public static void writeRectList(Parcel out, List<Rect> rects) {
        out.writeInt(rects.size());
        for (Rect rect : rects) {
            ParcelUtils.writeRectToParcel(rect, out);
        }
    }

    public static ImmutableList<Rect> readRectList(Parcel in) {
        int size = in.readInt();
        if (size > 0) {
            ImmutableList.Builder rects = new ImmutableList.Builder();
            for (int i = 0; i < size; ++i) {
                rects.add((Object)ParcelUtils.readRectFromParcel(in));
            }
            return rects.build();
        }
        return ImmutableList.of();
    }
}

