/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.os.Parcel;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ParcelUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyAction;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewHierarchyActionAndroid
extends ViewHierarchyAction {
    private ViewHierarchyActionAndroid(int actionId, @Nullable CharSequence actionLabel) {
        super(actionId, actionLabel);
    }

    void writeToParcel(Parcel out) {
        out.writeInt(this.getActionId());
        CharSequence label = this.getActionLabel();
        ParcelUtils.writeNullableString(out, label == null ? null : label.toString());
    }

    static Builder newBuilder(AccessibilityNodeInfo.AccessibilityAction action2) {
        return new Builder(action2);
    }

    static Builder newBuilder(AccessibilityHierarchyProtos.ViewHierarchyActionProto actionProto) {
        return new Builder(actionProto);
    }

    static Builder newBuilder(Parcel in) {
        return new Builder(in);
    }

    static class Builder {
        private final int actionId;
        private final @Nullable CharSequence actionLabel;

        Builder(AccessibilityNodeInfo.AccessibilityAction action2) {
            this.actionId = action2.getId();
            this.actionLabel = action2.getLabel();
        }

        Builder(AccessibilityHierarchyProtos.ViewHierarchyActionProto actionProto) {
            this.actionId = actionProto.getActionId();
            this.actionLabel = actionProto.hasActionLabel() ? actionProto.getActionLabel() : null;
        }

        Builder(Parcel in) {
            this.actionId = in.readInt();
            this.actionLabel = ParcelUtils.readNullableString(in);
        }

        public ViewHierarchyActionAndroid build() {
            return new ViewHierarchyActionAndroid(this.actionId, this.actionLabel);
        }
    }
}

