/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WindowHierarchyElement {
    public static final int WINDOW_TYPE_APPLICATION = 1;
    public static final int WINDOW_TYPE_INPUT_METHOD = 2;
    public static final int WINDOW_TYPE_SYSTEM = 3;
    public static final int WINDOW_TYPE_ACCESSIBILITY = 4;
    private final List<ViewHierarchyElement> viewHierarchyElements;
    protected final int id;
    protected final @Nullable Integer parentId;
    protected final List<Integer> childIds = new ArrayList<Integer>();
    private @MonotonicNonNull AccessibilityHierarchy accessibilityHierarchy;
    protected final @Nullable Integer windowId;
    protected final @Nullable Integer layer;
    protected final @Nullable Integer type;
    protected final @Nullable Boolean focused;
    protected final @Nullable Boolean accessibilityFocused;
    protected final @Nullable Boolean active;
    protected final @Nullable Rect boundsInScreen;

    protected WindowHierarchyElement(int id2, @Nullable Integer parentId, List<Integer> childIds, @Nullable Integer windowId, @Nullable Integer layer, @Nullable Integer type, @Nullable Boolean focused, @Nullable Boolean accessibilityFocused, @Nullable Boolean active, @Nullable Rect boundsInScreen) {
        this.viewHierarchyElements = new ArrayList<ViewHierarchyElement>();
        this.id = id2;
        this.parentId = parentId;
        this.childIds.addAll(childIds);
        this.windowId = windowId;
        this.layer = layer;
        this.type = type;
        this.focused = focused;
        this.accessibilityFocused = accessibilityFocused;
        this.active = active;
        this.boundsInScreen = boundsInScreen;
    }

    protected WindowHierarchyElement(AccessibilityHierarchyProtos.WindowHierarchyElementProto proto) {
        this.id = proto.getId();
        this.parentId = proto.getParentId() != -1 ? Integer.valueOf(proto.getParentId()) : null;
        this.childIds.addAll(proto.getChildIdsList());
        this.windowId = proto.hasWindowId() ? Integer.valueOf(proto.getWindowId()) : null;
        this.layer = proto.hasLayer() ? Integer.valueOf(proto.getLayer()) : null;
        this.type = proto.hasType() ? Integer.valueOf(proto.getType()) : null;
        this.focused = proto.hasFocused() ? Boolean.valueOf(proto.getFocused()) : null;
        this.accessibilityFocused = proto.hasAccessibilityFocused() ? Boolean.valueOf(proto.getAccessibilityFocused()) : null;
        this.active = proto.hasActive() ? Boolean.valueOf(proto.getActive()) : null;
        this.boundsInScreen = proto.hasBoundsInScreen() ? new Rect(proto.getBoundsInScreen()) : null;
        int totalNodes = proto.getViewsCount();
        this.viewHierarchyElements = new ArrayList<ViewHierarchyElement>(totalNodes);
        for (AccessibilityHierarchyProtos.ViewHierarchyElementProto view2 : proto.getViewsList()) {
            this.viewHierarchyElements.add(new ViewHierarchyElement(view2));
        }
    }

    public int getId() {
        return this.id;
    }

    public @Nullable ViewHierarchyElement getRootView() {
        if (this.viewHierarchyElements.isEmpty()) {
            return null;
        }
        return this.viewHierarchyElements.get(0);
    }

    public List<? extends ViewHierarchyElement> getAllViews() {
        return Collections.unmodifiableList(this.viewHierarchyElements);
    }

    public @Nullable WindowHierarchyElement getParentWindow() {
        Integer parentIdTmp = this.parentId;
        return parentIdTmp != null ? this.getAccessibilityHierarchy().getWindowById(parentIdTmp) : null;
    }

    public int getChildWindowCount() {
        return this.childIds.size();
    }

    public WindowHierarchyElement getChildWindow(int atIndex) {
        if (atIndex < 0 || atIndex >= this.childIds.size()) {
            throw new NoSuchElementException();
        }
        return this.getAccessibilityHierarchy().getWindowById(this.childIds.get(atIndex));
    }

    public ViewHierarchyElement getViewById(int id2) {
        if (id2 < 0 || id2 >= this.viewHierarchyElements.size()) {
            throw new NoSuchElementException();
        }
        return this.viewHierarchyElements.get(id2);
    }

    public AccessibilityHierarchy getAccessibilityHierarchy() {
        return (AccessibilityHierarchy)Preconditions.checkNotNull((Object)this.accessibilityHierarchy);
    }

    public @Nullable Integer getWindowId() {
        return this.windowId;
    }

    public @Nullable Integer getLayer() {
        return this.layer;
    }

    public @Nullable Integer getType() {
        return this.type;
    }

    public @Nullable Boolean isFocused() {
        return this.focused;
    }

    public @Nullable Boolean isAccessibilityFocused() {
        return this.accessibilityFocused;
    }

    public @Nullable Boolean isActive() {
        return this.active;
    }

    public Rect getBoundsInScreen() {
        return this.boundsInScreen != null ? this.boundsInScreen : Rect.EMPTY;
    }

    void setAccessibilityHierarchy(AccessibilityHierarchy accessibilityHierarchy) {
        this.accessibilityHierarchy = accessibilityHierarchy;
    }

    AccessibilityHierarchyProtos.WindowHierarchyElementProto toProto() {
        AccessibilityHierarchyProtos.WindowHierarchyElementProto.Builder builder2 = AccessibilityHierarchyProtos.WindowHierarchyElementProto.newBuilder();
        builder2.setId(this.id);
        if (this.parentId != null) {
            builder2.setParentId(this.parentId);
        }
        if (!this.childIds.isEmpty()) {
            builder2.addAllChildIds(this.childIds);
        }
        if (this.windowId != null) {
            builder2.setWindowId(this.windowId);
        }
        if (this.layer != null) {
            builder2.setLayer(this.layer);
        }
        if (this.type != null) {
            builder2.setType(this.type);
        }
        if (this.focused != null) {
            builder2.setFocused(this.focused);
        }
        if (this.accessibilityFocused != null) {
            builder2.setFocused(this.accessibilityFocused);
        }
        if (this.active != null) {
            builder2.setActive(this.active);
        }
        if (this.boundsInScreen != null) {
            builder2.setBoundsInScreen(this.boundsInScreen.toProto());
        }
        for (ViewHierarchyElement viewHierarchyElement : this.getAllViews()) {
            builder2.addViews(viewHierarchyElement.toProto());
        }
        return (AccessibilityHierarchyProtos.WindowHierarchyElementProto)builder2.build();
    }

    void addChild(WindowHierarchyElement child) {
        this.childIds.add(child.id);
    }

    static Builder newBuilder(AccessibilityHierarchyProtos.WindowHierarchyElementProto proto) {
        return new Builder(proto);
    }

    public static class Builder {
        private final AccessibilityHierarchyProtos.WindowHierarchyElementProto proto;

        Builder(AccessibilityHierarchyProtos.WindowHierarchyElementProto proto) {
            this.proto = proto;
        }

        public WindowHierarchyElement build() {
            WindowHierarchyElement result = new WindowHierarchyElement(this.proto);
            Builder.setWindow(result);
            return result;
        }

        private static void setWindow(WindowHierarchyElement window) {
            if (window.viewHierarchyElements != null) {
                for (ViewHierarchyElement view2 : window.viewHierarchyElements) {
                    view2.setWindow(window);
                }
            }
        }
    }
}

