/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.graphics.Rect;
import android.os.Parcel;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityNodeInfoExtraDataExtractor;
import com.google.android.apps.common.testing.accessibility.framework.uielement.CustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ParcelUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WindowHierarchyElementAndroid
extends WindowHierarchyElement {
    private static final String TAG = "WindowHierarchyElementA";
    private final List<ViewHierarchyElementAndroid> viewHierarchyElements;
    private @MonotonicNonNull AccessibilityHierarchyAndroid accessibilityHierarchy;

    private WindowHierarchyElementAndroid(int id2, @Nullable Integer parentId, List<Integer> childIds, @Nullable Integer windowId, @Nullable Integer layer, @Nullable Integer type, @Nullable Boolean focused, @Nullable Boolean accessibilityFocused, @Nullable Boolean active, @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreen, List<ViewHierarchyElementAndroid> viewHierarchyElements) {
        super(id2, parentId, childIds, windowId, layer, type, focused, accessibilityFocused, active, boundsInScreen);
        this.viewHierarchyElements = viewHierarchyElements;
    }

    @Override
    public @Nullable ViewHierarchyElementAndroid getRootView() {
        if (this.viewHierarchyElements.isEmpty()) {
            return null;
        }
        return this.viewHierarchyElements.get(0);
    }

    public List<ViewHierarchyElementAndroid> getAllViews() {
        return Collections.unmodifiableList(this.viewHierarchyElements);
    }

    @Override
    public @Nullable WindowHierarchyElementAndroid getParentWindow() {
        Integer parentIdTmp = this.parentId;
        return parentIdTmp != null ? this.getAccessibilityHierarchy().getWindowById(parentIdTmp) : null;
    }

    @Override
    public WindowHierarchyElementAndroid getChildWindow(int atIndex) {
        if (atIndex < 0 || atIndex >= this.childIds.size()) {
            throw new NoSuchElementException();
        }
        return this.getAccessibilityHierarchy().getWindowById((Integer)this.childIds.get(atIndex));
    }

    @Override
    public ViewHierarchyElementAndroid getViewById(int id2) {
        if (id2 < 0 || id2 >= this.viewHierarchyElements.size()) {
            throw new NoSuchElementException();
        }
        return this.viewHierarchyElements.get(id2);
    }

    @Override
    public AccessibilityHierarchyAndroid getAccessibilityHierarchy() {
        return (AccessibilityHierarchyAndroid)Preconditions.checkNotNull((Object)this.accessibilityHierarchy);
    }

    public void getBoundsInScreen(Rect outBounds) {
        if (this.boundsInScreen != null) {
            outBounds.set(new Rect(this.boundsInScreen.getLeft(), this.boundsInScreen.getTop(), this.boundsInScreen.getRight(), this.boundsInScreen.getBottom()));
        } else {
            outBounds.setEmpty();
        }
    }

    void writeToParcel(Parcel out) {
        ParcelUtils.writeNullableInteger(out, this.windowId);
        ParcelUtils.writeNullableInteger(out, this.layer);
        ParcelUtils.writeNullableInteger(out, this.type);
        ParcelUtils.writeNullableBoolean(out, this.focused);
        ParcelUtils.writeNullableBoolean(out, this.accessibilityFocused);
        ParcelUtils.writeNullableBoolean(out, this.active);
        com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreenTmp = this.boundsInScreen;
        if (boundsInScreenTmp != null) {
            out.writeInt(1);
            out.writeInt(boundsInScreenTmp.getLeft());
            out.writeInt(boundsInScreenTmp.getTop());
            out.writeInt(boundsInScreenTmp.getRight());
            out.writeInt(boundsInScreenTmp.getBottom());
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.viewHierarchyElements.size());
        if (!this.viewHierarchyElements.isEmpty()) {
            WindowHierarchyElementAndroid.writeViewHierarchyToParcel((ViewHierarchyElementAndroid)Preconditions.checkNotNull((Object)this.getRootView()), out);
        }
    }

    private static void writeViewHierarchyToParcel(ViewHierarchyElementAndroid element, Parcel out) {
        element.writeToParcel(out);
        int children = element.getChildViewCount();
        out.writeInt(children);
        for (int i = 0; i < children; ++i) {
            WindowHierarchyElementAndroid.writeViewHierarchyToParcel(element.getChildView(i), out);
        }
    }

    void setAccessibilityHierarchy(AccessibilityHierarchyAndroid accessibilityHierarchy) {
        this.accessibilityHierarchy = accessibilityHierarchy;
    }

    void addChild(WindowHierarchyElementAndroid child) {
        this.childIds.add(child.id);
    }

    static BuilderAndroid newBuilder(int id2, View view2, CustomViewBuilderAndroid customViewBuilder, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
        BuilderAndroid builder2 = new BuilderAndroid(id2);
        builder2.fromRootView = (View)Preconditions.checkNotNull((Object)view2);
        builder2.customViewBuilder = customViewBuilder;
        builder2.aniExtraDataExtractor = extraDataExtractor;
        return builder2;
    }

    static BuilderAndroid newBuilder(int id2, AccessibilityWindowInfo window, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
        BuilderAndroid builder2 = new BuilderAndroid(id2);
        builder2.fromWindowInfo = (AccessibilityWindowInfo)Preconditions.checkNotNull((Object)window);
        builder2.aniExtraDataExtractor = extraDataExtractor;
        return builder2;
    }

    static BuilderAndroid newBuilder(int id2, AccessibilityNodeInfo nodeInfo, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
        BuilderAndroid builder2 = new BuilderAndroid(id2);
        builder2.fromNodeInfo = (AccessibilityNodeInfo)Preconditions.checkNotNull((Object)nodeInfo);
        builder2.aniExtraDataExtractor = extraDataExtractor;
        return builder2;
    }

    static BuilderAndroid newBuilder(int id2, Parcel in) {
        BuilderAndroid builder2 = new BuilderAndroid(id2);
        builder2.in = (Parcel)Preconditions.checkNotNull((Object)in);
        return builder2;
    }

    static class BuilderAndroid {
        private final int id;
        private @Nullable View fromRootView;
        private @Nullable CustomViewBuilderAndroid customViewBuilder;
        private @Nullable AccessibilityWindowInfo fromWindowInfo;
        private @Nullable AccessibilityNodeInfo fromNodeInfo;
        private @Nullable AccessibilityNodeInfoExtraDataExtractor aniExtraDataExtractor;
        private @Nullable Parcel in;
        private @Nullable WindowHierarchyElementAndroid parent;
        private @MonotonicNonNull Map<Long, AccessibilityNodeInfo> nodeInfoOriginMap;
        private @MonotonicNonNull Map<Long, View> viewOriginMap;
        private @MonotonicNonNull Map<AccessibilityNodeInfo, View> nodeToViewMap;
        private @Nullable Integer parentId;
        private final List<Integer> childIds = new ArrayList<Integer>();
        private @Nullable Integer windowId;
        private @Nullable Integer layer;
        private @Nullable Integer type;
        private @Nullable Boolean focused;
        private @Nullable Boolean accessibilityFocused;
        private @Nullable Boolean active;
        private @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreen;
        private List<ViewHierarchyElementAndroid> viewHierarchyElements;

        BuilderAndroid(int id2) {
            this.id = id2;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setParent(@Nullable WindowHierarchyElementAndroid parent) {
            this.parent = parent;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setNodeInfoOriginMap(Map<Long, AccessibilityNodeInfo> originMap) {
            this.nodeInfoOriginMap = originMap;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setViewOriginMap(Map<Long, View> originMap) {
            this.viewOriginMap = originMap;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setNodeToViewMap(Map<AccessibilityNodeInfo, View> nodeToViewMap) {
            this.nodeToViewMap = nodeToViewMap;
            return this;
        }

        public WindowHierarchyElementAndroid build() {
            WindowHierarchyElementAndroid result;
            HashMap<ViewHierarchyElementAndroid, View> elementToViewMap = null;
            HashMap<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap = null;
            if (this.fromRootView != null) {
                elementToViewMap = new HashMap<ViewHierarchyElementAndroid, View>();
                result = this.constructFromView(this.id, this.parent, this.fromRootView, elementToViewMap, (CustomViewBuilderAndroid)Preconditions.checkNotNull((Object)this.customViewBuilder), (AccessibilityNodeInfoExtraDataExtractor)Preconditions.checkNotNull((Object)this.aniExtraDataExtractor));
            } else if (this.fromWindowInfo != null) {
                elementToNodeInfoMap = new HashMap<ViewHierarchyElementAndroid, AccessibilityNodeInfo>();
                result = this.constructFromWindow(this.id, this.parent, this.fromWindowInfo, elementToNodeInfoMap, (AccessibilityNodeInfoExtraDataExtractor)Preconditions.checkNotNull((Object)this.aniExtraDataExtractor));
            } else if (this.fromNodeInfo != null) {
                elementToNodeInfoMap = new HashMap();
                if (this.nodeToViewMap != null) {
                    elementToViewMap = new HashMap();
                }
                result = this.constructFromNode(this.id, this.parent, this.fromNodeInfo, elementToNodeInfoMap, elementToViewMap, this.nodeToViewMap, (AccessibilityNodeInfoExtraDataExtractor)Preconditions.checkNotNull((Object)this.aniExtraDataExtractor));
            } else if (this.in != null) {
                result = this.constructFromParcel(this.id, this.parent, this.in);
            } else {
                throw new IllegalStateException("Nothing from which to build");
            }
            BuilderAndroid.setWindow(result);
            this.populateOriginMaps(elementToViewMap, elementToNodeInfoMap);
            return result;
        }

        private static ViewHierarchyElementAndroid.Builder createViewHierarchyElementAndroidBuilder(int id2, @Nullable ViewHierarchyElementAndroid parent, View fromView, CustomViewBuilderAndroid customViewBuilder, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            return ViewHierarchyElementAndroid.newBuilder(id2, parent, fromView, customViewBuilder, extraDataExtractor);
        }

        @CanIgnoreReturnValue
        private static ViewHierarchyElementAndroid buildViewHierarchyFromView(View forView, List<ViewHierarchyElementAndroid> elementList, @Nullable ViewHierarchyElementAndroid parent, Map<ViewHierarchyElementAndroid, View> elementToViewMap, CustomViewBuilderAndroid customViewBuilder, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            ViewHierarchyElementAndroid element = BuilderAndroid.createViewHierarchyElementAndroidBuilder(elementList.size(), parent, forView, customViewBuilder, extraDataExtractor).build();
            elementList.add(element);
            elementToViewMap.put(element, forView);
            if (forView instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)forView;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    View child = viewGroup.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    element.addChild(BuilderAndroid.buildViewHierarchyFromView(child, elementList, element, elementToViewMap, customViewBuilder, extraDataExtractor));
                }
            }
            return element;
        }

        @CanIgnoreReturnValue
        private static ViewHierarchyElementAndroid buildViewHierarchyFromParcel(Parcel fromParcel, List<ViewHierarchyElementAndroid> elementList, @Nullable ViewHierarchyElementAndroid parent) {
            ViewHierarchyElementAndroid element = ViewHierarchyElementAndroid.newBuilder(elementList.size(), parent, fromParcel).build();
            elementList.add(element);
            int childElementCount = fromParcel.readInt();
            for (int i = 0; i < childElementCount; ++i) {
                element.addChild(BuilderAndroid.buildViewHierarchyFromParcel(fromParcel, elementList, element));
            }
            return element;
        }

        @CanIgnoreReturnValue
        private static ViewHierarchyElementAndroid buildViewHierarchyFromNode(AccessibilityNodeInfo forInfo, List<ViewHierarchyElementAndroid> elementList, @Nullable ViewHierarchyElementAndroid parent, Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap, @Nullable Map<ViewHierarchyElementAndroid, View> elementToViewMap, @Nullable Map<AccessibilityNodeInfo, View> nodeToViewMap, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            View view2 = nodeToViewMap != null ? nodeToViewMap.get(forInfo) : null;
            ViewHierarchyElementAndroid element = ViewHierarchyElementAndroid.newBuilder(elementList.size(), parent, forInfo, view2, extraDataExtractor).build();
            elementList.add(element);
            elementToNodeInfoMap.put(element, AccessibilityNodeInfo.obtain(forInfo));
            if (elementToViewMap != null && view2 != null) {
                elementToViewMap.put(element, view2);
            }
            for (int i = 0; i < forInfo.getChildCount(); ++i) {
                AccessibilityNodeInfo child = forInfo.getChild(i);
                if (child == null) continue;
                element.addChild(BuilderAndroid.buildViewHierarchyFromNode(child, elementList, element, elementToNodeInfoMap, elementToViewMap, nodeToViewMap, extraDataExtractor));
            }
            return element;
        }

        private WindowHierarchyElementAndroid constructFromWindow(int id2, @Nullable WindowHierarchyElementAndroid parent, AccessibilityWindowInfo fromWindow, Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.windowId = fromWindow.getId();
            this.layer = fromWindow.getLayer();
            this.type = fromWindow.getType();
            this.focused = fromWindow.isFocused();
            this.accessibilityFocused = fromWindow.isAccessibilityFocused();
            this.active = fromWindow.isActive();
            Rect tempRect = new Rect();
            fromWindow.getBoundsInScreen(tempRect);
            this.boundsInScreen = new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
            AccessibilityNodeInfo rootInfo = fromWindow.getRoot();
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>();
            if (rootInfo != null) {
                BuilderAndroid.buildViewHierarchyFromNode(rootInfo, this.viewHierarchyElements, null, elementToNodeInfoMap, null, null, extraDataExtractor);
            } else {
                LogUtils.w(WindowHierarchyElementAndroid.TAG, "Constructed WindowHierarchyElement with no valid root.", new Object[0]);
            }
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid constructFromNode(int id2, @Nullable WindowHierarchyElementAndroid parent, AccessibilityNodeInfo fromRootNode, Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap, @Nullable Map<ViewHierarchyElementAndroid, View> elementToViewMap, @Nullable Map<AccessibilityNodeInfo, View> nodeToViewMap, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.windowId = fromRootNode.getWindowId();
            Rect tempRect = new Rect();
            fromRootNode.getBoundsInScreen(tempRect);
            this.boundsInScreen = new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
            this.active = true;
            this.type = 1;
            this.layer = null;
            this.focused = null;
            this.accessibilityFocused = null;
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>();
            BuilderAndroid.buildViewHierarchyFromNode(fromRootNode, this.viewHierarchyElements, null, elementToNodeInfoMap, elementToViewMap, nodeToViewMap, extraDataExtractor);
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid constructFromView(int id2, @Nullable WindowHierarchyElementAndroid parent, View fromRootView, Map<ViewHierarchyElementAndroid, View> elementToViewMap, CustomViewBuilderAndroid customViewBuilder, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            Rect tempRect = new Rect();
            fromRootView.getWindowVisibleDisplayFrame(tempRect);
            this.boundsInScreen = new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
            this.active = true;
            this.type = 1;
            this.windowId = null;
            this.layer = null;
            this.focused = null;
            this.accessibilityFocused = null;
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>();
            BuilderAndroid.buildViewHierarchyFromView(fromRootView, this.viewHierarchyElements, null, elementToViewMap, customViewBuilder, extraDataExtractor);
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid constructFromParcel(int id2, @Nullable WindowHierarchyElementAndroid parent, Parcel in) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.windowId = ParcelUtils.readNullableInteger(in);
            this.layer = ParcelUtils.readNullableInteger(in);
            this.type = ParcelUtils.readNullableInteger(in);
            this.focused = ParcelUtils.readNullableBoolean(in);
            this.accessibilityFocused = ParcelUtils.readNullableBoolean(in);
            this.active = ParcelUtils.readNullableBoolean(in);
            this.boundsInScreen = in.readInt() == 1 ? new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(in.readInt(), in.readInt(), in.readInt(), in.readInt()) : null;
            int totalExpectedNodes = in.readInt();
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>(totalExpectedNodes);
            if (totalExpectedNodes > 0) {
                BuilderAndroid.buildViewHierarchyFromParcel(in, this.viewHierarchyElements, null);
                Preconditions.checkState((totalExpectedNodes == this.viewHierarchyElements.size() ? 1 : 0) != 0, (Object)"View hierarchy failed consistency check.");
            }
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private void populateOriginMaps(@Nullable Map<ViewHierarchyElementAndroid, View> elementToViewMap, @Nullable Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap) {
            if (this.viewOriginMap != null) {
                for (Map.Entry entry : ((Map)Preconditions.checkNotNull(elementToViewMap)).entrySet()) {
                    this.viewOriginMap.put(((ViewHierarchyElementAndroid)entry.getKey()).getCondensedUniqueId(), (View)entry.getValue());
                }
            }
            if (this.nodeInfoOriginMap != null) {
                for (Map.Entry entry : ((Map)Preconditions.checkNotNull(elementToNodeInfoMap)).entrySet()) {
                    this.nodeInfoOriginMap.put(((ViewHierarchyElementAndroid)entry.getKey()).getCondensedUniqueId(), (AccessibilityNodeInfo)entry.getValue());
                }
            }
        }

        private static void setWindow(WindowHierarchyElementAndroid window) {
            if (window.viewHierarchyElements != null) {
                for (ViewHierarchyElementAndroid view2 : window.viewHierarchyElements) {
                    view2.setWindow(window);
                }
            }
        }
    }
}

