/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.utils.contrast;

import android.graphics.Bitmap;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.base.Preconditions;

public class BitmapImage
implements Image {
    private final Bitmap bitmap;
    private final int left;
    private final int top;
    private final int width;
    private final int height;

    public BitmapImage(Bitmap bitmap) {
        this(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight());
    }

    private BitmapImage(Bitmap bitmap, int left, int top, int width2, int height2) {
        this.bitmap = bitmap;
        this.left = left;
        this.top = top;
        this.width = width2;
        this.height = height2;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public BitmapImage crop(int left, int top, int width2, int height2) {
        Preconditions.checkArgument((left >= 0 ? 1 : 0) != 0, (Object)"left must be >= 0");
        Preconditions.checkArgument((top >= 0 ? 1 : 0) != 0, (Object)"top must be >= 0");
        Preconditions.checkArgument((width2 > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height2 > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        Preconditions.checkArgument((left + width2 <= this.width ? 1 : 0) != 0);
        Preconditions.checkArgument((top + height2 <= this.height ? 1 : 0) != 0);
        return new BitmapImage(this.bitmap, this.left + left, this.top + top, width2, height2);
    }

    @Override
    public int[] getPixels() {
        int[] pixels = new int[this.width * this.height];
        this.bitmap.getPixels(pixels, 0, this.width, this.left, this.top, this.width, this.height);
        return pixels;
    }

    public Bitmap getBitmap() {
        return Bitmap.createBitmap(this.bitmap, this.left, this.top, this.width, this.height);
    }

    public String toString() {
        return String.format("{BitmapImage left=%d top=%d width=%d height=%d}", this.left, this.top, this.width, this.height);
    }
}

