/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.utils.contrast;

import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Color;
import com.google.common.collect.Range;

public class ContrastUtils {
    public static final int WCAG_LARGE_TEXT_MIN_SIZE = 18;
    public static final int WCAG_LARGE_BOLD_TEXT_MIN_SIZE = 14;
    public static final int COLOR_SECURE_WINDOW_CENSOR = -16777216;
    public static final double CONTRAST_RATIO_WCAG_NORMAL_TEXT = 4.5;
    public static final double CONTRAST_RATIO_WCAG_LARGE_TEXT = 3.0;
    private static final int COLOR_MASK = 255;

    private ContrastUtils() {
    }

    public static double calculateLuminance(int color2) {
        double r = ContrastUtils.linearColor(Color.red(color2));
        double g = ContrastUtils.linearColor(Color.green(color2));
        double b = ContrastUtils.linearColor(Color.blue(color2));
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private static double linearColor(int component2) {
        double sRGB = (double)component2 / 255.0;
        if (sRGB <= 0.03928) {
            return sRGB / 12.92;
        }
        return Math.pow((sRGB + 0.055) / 1.055, 2.4);
    }

    public static double colorDifference(int color1, int color2) {
        double c2;
        double[] lab1 = ContrastUtils.rgb2lab(color1);
        double[] lab2 = ContrastUtils.rgb2lab(color2);
        double deltaL = lab1[0] - lab2[0];
        double deltaA = lab1[1] - lab2[1];
        double deltaB = lab1[2] - lab2[2];
        double c1 = Math.hypot(lab1[1], lab1[2]);
        double deltaC = c1 - (c2 = Math.hypot(lab2[1], lab2[2]));
        double deltaH = deltaA * deltaA + deltaB * deltaB - deltaC * deltaC;
        deltaH = deltaH < 0.0 ? 0.0 : Math.sqrt(deltaH);
        double sc = 1.0 + 0.045 * c1;
        double sh = 1.0 + 0.015 * c1;
        double deltaLKlsl = deltaL / 1.0;
        double deltaCkcsc = deltaC / sc;
        double deltaHkhsh = deltaH / sh;
        return Math.sqrt(deltaLKlsl * deltaLKlsl + deltaCkcsc * deltaCkcsc + deltaHkhsh * deltaHkhsh);
    }

    public static double[] rgb2lab(int color2) {
        double r = ContrastUtils.linearColor(Color.red(color2));
        double g = ContrastUtils.linearColor(Color.green(color2));
        double b = ContrastUtils.linearColor(Color.blue(color2));
        double x = (r * 0.4124 + g * 0.3576 + b * 0.1805) / 0.95047;
        double y = (r * 0.2126 + g * 0.7152 + b * 0.0722) / 1.0;
        double z = (r * 0.0193 + g * 0.1192 + b * 0.9505) / 1.08883;
        x = x > 0.008856 ? Math.cbrt(x) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.cbrt(y) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.cbrt(z) : 7.787 * z + 0.13793103448275862;
        return new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
    }

    public static double calculateContrastRatio(int color1, int color2) {
        return ContrastUtils.calculateContrastRatio(ContrastUtils.calculateLuminance(color1), ContrastUtils.calculateLuminance(color2));
    }

    public static double calculateContrastRatio(double lum1, double lum2) {
        if (lum1 < 0.0 || lum2 < 0.0) {
            throw new IllegalArgumentException("Luminance values may not be negative.");
        }
        return (Math.max(lum1, lum2) + 0.05) / (Math.min(lum1, lum2) + 0.05);
    }

    private static double calculateContrastOnBackdrop(int foregroundColor, int backgroundColor, int backdrop) {
        int backgroundOnBackdrop = ContrastUtils.compositeColors(backgroundColor, backdrop);
        int compositeforegroundColorOnBackgroundOnBackdrop = ContrastUtils.compositeColors(foregroundColor, backgroundOnBackdrop);
        return ContrastUtils.calculateContrastRatio(compositeforegroundColorOnBackgroundOnBackdrop, backgroundOnBackdrop);
    }

    public static Range<Double> calculateContrastRatioRange(int foregroundColor, int backgroundColor) {
        double contrastOnBlackBackdrop = ContrastUtils.calculateContrastOnBackdrop(foregroundColor, backgroundColor, -16777216);
        double contrastOnWhiteBackdrop = ContrastUtils.calculateContrastOnBackdrop(foregroundColor, backgroundColor, -1);
        double backgroundOnBlackLuminance = ContrastUtils.calculateLuminance(ContrastUtils.compositeColors(backgroundColor, -16777216));
        double backgroundOnWhiteLuminance = ContrastUtils.calculateLuminance(ContrastUtils.compositeColors(backgroundColor, -1));
        double foregroundColorLuminance = ContrastUtils.calculateLuminance(foregroundColor);
        double minimumContrastRatio = 1.0;
        if (foregroundColorLuminance < backgroundOnBlackLuminance) {
            minimumContrastRatio = contrastOnBlackBackdrop;
        } else if (backgroundOnWhiteLuminance < foregroundColorLuminance) {
            minimumContrastRatio = contrastOnWhiteBackdrop;
        }
        return Range.closed((Comparable)Double.valueOf(minimumContrastRatio), (Comparable)Double.valueOf(Math.max(contrastOnBlackBackdrop, contrastOnWhiteBackdrop)));
    }

    public static String colorToHexString(int color2) {
        if (Color.alpha(color2) == 255) {
            return String.format("#%06X", 0xFFFFFF & color2);
        }
        return String.format("#%08X", color2);
    }

    public static int compositeColors(int color2, int colorToOverlayOn) {
        int alpha = Color.alpha(color2);
        int r = ContrastUtils.compositeComponents(Color.red(color2), Color.red(colorToOverlayOn), alpha);
        int g = ContrastUtils.compositeComponents(Color.green(color2), Color.green(colorToOverlayOn), alpha);
        int b = ContrastUtils.compositeComponents(Color.blue(color2), Color.blue(colorToOverlayOn), alpha);
        return Color.argb(255, r, g, b);
    }

    private static int compositeComponents(int component2, int componentToOverlayOn, int alpha) {
        return (component2 * alpha + componentToOverlayOn * (255 - alpha)) / 255;
    }
}

