/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.google.android.gles_jni.EGLContextImpl;
import com.google.android.gles_jni.EGLDisplayImpl;
import com.google.android.gles_jni.EGLSurfaceImpl;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGLImpl
implements EGL10 {
    private EGLContextImpl mContext = new EGLContextImpl(-1L);
    private EGLDisplayImpl mDisplay = new EGLDisplayImpl(-1L);
    private EGLSurfaceImpl mSurface = new EGLSurfaceImpl(-1L);

    @Override
    public boolean eglInitialize(EGLDisplay eGLDisplay, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglInitialize(Ljavax/microedition/khronos/egl/EGLDisplay;[I)Z", true, this) != 0;
    }

    @Override
    public boolean eglQueryContext(EGLDisplay eGLDisplay, EGLContext eGLContext, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglQueryContext(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLContext;I[I)Z", true, this) != 0;
    }

    @Override
    public boolean eglQuerySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglQuerySurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;I[I)Z", true, this) != 0;
    }

    @Override
    public boolean eglReleaseThread() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglReleaseThread()Z", true, this) != 0;
    }

    @Override
    public boolean eglChooseConfig(EGLDisplay eGLDisplay, int[] nArray, EGLConfig[] eGLConfigArray, int n, int[] nArray2) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglChooseConfig(Ljavax/microedition/khronos/egl/EGLDisplay;[I[Ljavax/microedition/khronos/egl/EGLConfig;I[I)Z", true, this) != 0;
    }

    @Override
    public boolean eglGetConfigAttrib(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglGetConfigAttrib(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;I[I)Z", true, this) != 0;
    }

    @Override
    public boolean eglGetConfigs(EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglGetConfigs(Ljavax/microedition/khronos/egl/EGLDisplay;[Ljavax/microedition/khronos/egl/EGLConfig;I[I)Z", true, this) != 0;
    }

    @Override
    public int eglGetError() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglGetError()I", true, this);
    }

    @Override
    public boolean eglDestroyContext(EGLDisplay eGLDisplay, EGLContext eGLContext) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglDestroyContext(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLContext;)Z", true, this) != 0;
    }

    @Override
    public boolean eglDestroySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglDestroySurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;)Z", true, this) != 0;
    }

    @Override
    public boolean eglMakeCurrent(EGLDisplay eGLDisplay, EGLSurface eGLSurface, EGLSurface eGLSurface2, EGLContext eGLContext) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglMakeCurrent(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;Ljavax/microedition/khronos/egl/EGLSurface;Ljavax/microedition/khronos/egl/EGLContext;)Z", true, this) != 0;
    }

    @Override
    public String eglQueryString(EGLDisplay eGLDisplay, int n) {
        return (String)OverrideMethod.invokeA("com.google.android.gles_jni.EGLImpl#eglQueryString(Ljavax/microedition/khronos/egl/EGLDisplay;I)Ljava/lang/String;", true, this);
    }

    @Override
    public boolean eglSwapBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglSwapBuffers(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;)Z", true, this) != 0;
    }

    @Override
    public boolean eglTerminate(EGLDisplay eGLDisplay) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglTerminate(Ljavax/microedition/khronos/egl/EGLDisplay;)Z", true, this) != 0;
    }

    @Override
    public boolean eglCopyBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface, Object object) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglCopyBuffers(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;Ljava/lang/Object;)Z", true, this) != 0;
    }

    @Override
    public boolean eglWaitGL() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglWaitGL()Z", true, this) != 0;
    }

    @Override
    public boolean eglWaitNative(int n, Object object) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglWaitNative(ILjava/lang/Object;)Z", true, this) != 0;
    }

    public static int getInitCount(EGLDisplay eGLDisplay) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#getInitCount(Ljavax/microedition/khronos/egl/EGLDisplay;)I", true, null);
    }

    @UnsupportedAppUsage
    public EGLImpl() {
    }

    @Override
    public EGLContext eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list) {
        long eglContextId = this._eglCreateContext(display, config, share_context, attrib_list);
        if (eglContextId == 0L) {
            return EGL10.EGL_NO_CONTEXT;
        }
        return new EGLContextImpl(eglContextId);
    }

    @Override
    public EGLSurface eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list) {
        long eglSurfaceId = this._eglCreatePbufferSurface(display, config, attrib_list);
        if (eglSurfaceId == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    @Override
    public EGLSurface eglCreatePixmapSurface(EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list) {
        EGLSurfaceImpl sur = new EGLSurfaceImpl();
        this._eglCreatePixmapSurface(sur, display, config, native_pixmap, attrib_list);
        if (sur.mEGLSurface == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        return sur;
    }

    @Override
    public EGLSurface eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list) {
        long eglSurfaceId;
        Surface sur = null;
        if (native_window instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)native_window;
            sur = surfaceView.getHolder().getSurface();
        } else if (native_window instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)native_window;
            sur = holder.getSurface();
        } else if (native_window instanceof Surface) {
            sur = (Surface)native_window;
        }
        if (sur != null) {
            eglSurfaceId = this._eglCreateWindowSurface(display, config, sur, attrib_list);
        } else if (native_window instanceof SurfaceTexture) {
            eglSurfaceId = this._eglCreateWindowSurfaceTexture(display, config, native_window, attrib_list);
        } else {
            throw new UnsupportedOperationException("eglCreateWindowSurface() can only be called with an instance of Surface, SurfaceView, SurfaceHolder or SurfaceTexture at the moment.");
        }
        if (eglSurfaceId == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    @Override
    public synchronized EGLDisplay eglGetDisplay(Object native_display) {
        long value2 = this._eglGetDisplay(native_display);
        if (value2 == 0L) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value2) {
            this.mDisplay = new EGLDisplayImpl(value2);
        }
        return this.mDisplay;
    }

    @Override
    public synchronized EGLContext eglGetCurrentContext() {
        long value2 = this._eglGetCurrentContext();
        if (value2 == 0L) {
            return EGL10.EGL_NO_CONTEXT;
        }
        if (this.mContext.mEGLContext != value2) {
            this.mContext = new EGLContextImpl(value2);
        }
        return this.mContext;
    }

    @Override
    public synchronized EGLDisplay eglGetCurrentDisplay() {
        long value2 = this._eglGetCurrentDisplay();
        if (value2 == 0L) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value2) {
            this.mDisplay = new EGLDisplayImpl(value2);
        }
        return this.mDisplay;
    }

    @Override
    public synchronized EGLSurface eglGetCurrentSurface(int readdraw) {
        long value2 = this._eglGetCurrentSurface(readdraw);
        if (value2 == 0L) {
            return EGL10.EGL_NO_SURFACE;
        }
        if (this.mSurface.mEGLSurface != value2) {
            this.mSurface = new EGLSurfaceImpl(value2);
        }
        return this.mSurface;
    }

    private long _eglCreateContext(EGLDisplay eGLDisplay, EGLConfig eGLConfig, EGLContext eGLContext, int[] nArray) {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglCreateContext(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljavax/microedition/khronos/egl/EGLContext;[I)J", true, this);
    }

    private long _eglCreatePbufferSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int[] nArray) {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglCreatePbufferSurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;[I)J", true, this);
    }

    private void _eglCreatePixmapSurface(EGLSurface eGLSurface, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        OverrideMethod.invokeV("com.google.android.gles_jni.EGLImpl#_eglCreatePixmapSurface(Ljavax/microedition/khronos/egl/EGLSurface;Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljava/lang/Object;[I)V", true, this);
    }

    private long _eglCreateWindowSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglCreateWindowSurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljava/lang/Object;[I)J", true, this);
    }

    private long _eglCreateWindowSurfaceTexture(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglCreateWindowSurfaceTexture(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljava/lang/Object;[I)J", true, this);
    }

    private long _eglGetDisplay(Object object) {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglGetDisplay(Ljava/lang/Object;)J", true, this);
    }

    private long _eglGetCurrentContext() {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglGetCurrentContext()J", true, this);
    }

    private long _eglGetCurrentDisplay() {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglGetCurrentDisplay()J", true, this);
    }

    private long _eglGetCurrentSurface(int n) {
        return OverrideMethod.invokeL("com.google.android.gles_jni.EGLImpl#_eglGetCurrentSurface(I)J", true, this);
    }

    private static void _nativeClassInit() {
        OverrideMethod.invokeV("com.google.android.gles_jni.EGLImpl#_nativeClassInit()V", true, null);
    }

    static {
        EGLImpl._nativeClassInit();
    }
}

