/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.accessibility.utils.log;

import android.util.Log;
import com.google.common.base.Strings;
import java.util.IllegalFormatException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogUtils {
    private static @Nullable ParameterCustomizer parameterCustomizer = null;
    private static final String TAG = "LogUtils";
    private static int minLogLevel = 6;
    private static String logTagPrefix = "";

    private LogUtils() {
    }

    public static void setTagPrefix(String prefix) {
        logTagPrefix = prefix;
    }

    public static void logWithLimit(String tag2, int priority, int index, int limit, String format, Object ... args) {
        if (index > limit) {
            return;
        }
        String formatWithIndex = index == limit ? String.format("%s (%d); further messages suppressed", format, index) : String.format("%s (%d)", format, index);
        LogUtils.log(tag2, priority, formatWithIndex, args);
    }

    public static void v(String tag2, @Nullable String format, Object ... args) {
        LogUtils.log(tag2, 2, format, args);
    }

    public static void v(String tag2, Throwable throwable, String format, Object ... args) {
        LogUtils.log(tag2, 2, throwable, format, args);
    }

    public static void d(String tag2, String format, Object ... args) {
        LogUtils.log(tag2, 3, format, args);
    }

    public static void d(String tag2, Throwable throwable, String format, Object ... args) {
        LogUtils.log(tag2, 3, throwable, format, args);
    }

    public static void i(String tag2, String format, Object ... args) {
        LogUtils.log(tag2, 4, format, args);
    }

    public static void i(String tag2, Throwable throwable, String format, Object ... args) {
        LogUtils.log(tag2, 4, throwable, format, args);
    }

    public static void w(String tag2, String format, Object ... args) {
        LogUtils.log(tag2, 5, format, args);
    }

    public static void w(String tag2, Throwable throwable, String format, Object ... args) {
        LogUtils.log(tag2, 5, throwable, format, args);
    }

    public static void e(String tag2, @Nullable String format, Object ... args) {
        LogUtils.log(tag2, 6, format, args);
    }

    public static void e(String tag2, Throwable throwable, String format, Object ... args) {
        LogUtils.log(tag2, 6, throwable, format, args);
    }

    public static void wtf(String tag2, String format, Object ... args) {
        LogUtils.log(tag2, 7, format, args);
    }

    public static void wtf(String tag2, Throwable throwable, String format, Object ... args) {
        LogUtils.log(tag2, 7, throwable, format, args);
    }

    public static void log(String tag2, int priority, @Nullable Throwable throwable, @Nullable String format, Object ... args) {
        if (priority < minLogLevel) {
            return;
        }
        String prefixedTag = logTagPrefix + tag2;
        if (parameterCustomizer != null) {
            for (int a = 0; a < args.length; ++a) {
                args[a] = parameterCustomizer.customize(args[a]);
            }
        }
        try {
            String message = String.format(Strings.nullToEmpty((String)format), args);
            if (throwable == null) {
                Log.println(priority, prefixedTag, message);
            } else {
                Log.println(priority, prefixedTag, String.format("%s\n%s", message, Log.getStackTraceString(throwable)));
            }
        }
        catch (IllegalFormatException e) {
            Log.e(TAG, "Bad formatting string: \"" + format + "\"", e);
        }
    }

    public static void log(String tag2, int priority, @Nullable String format, Object ... args) {
        LogUtils.log(tag2, priority, null, format, args);
    }

    public static void setParameterCustomizer(@Nullable ParameterCustomizer parameterCustomizerArg) {
        parameterCustomizer = parameterCustomizerArg;
    }

    public static void setLogLevel(int logLevel) {
        minLogLevel = logLevel;
    }

    public static int getLogLevel() {
        return minLogLevel;
    }

    public static boolean shouldLog(int logLevel) {
        return minLogLevel <= logLevel;
    }

    public static interface ParameterCustomizer {
        public @Nullable Object customize(@Nullable Object var1);
    }
}

