/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import org.eclipse.elk.alg.layered.p5edges.OrthogonalRoutingGenerator;

public final class DotDebugUtil {
    private static final String FILE_EXTENSION = ".dot";

    private DotDebugUtil() {
    }

    public static void writeDebugGraph(LGraph lgraph, int slotIndex, String name) {
        try {
            Writer writer = DebugUtil.createWriter(lgraph, slotIndex, name, FILE_EXTENSION);
            writer.write("digraph {\n");
            writer.write("    rankdir=LR;\n");
            DotDebugUtil.writeLayer(writer, -1, lgraph.getLayerlessNodes());
            int layerNumber = -1;
            for (Layer layer : lgraph) {
                DotDebugUtil.writeLayer(writer, ++layerNumber, layer.getNodes());
            }
            writer.write("}\n");
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeDebugGraph(LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        try {
            Writer writer = DebugUtil.createWriter(layeredGraph, FILE_EXTENSION);
            writer.write("digraph {\n");
            Iterator<LinearSegmentsNodePlacer.LinearSegment> segmentIterator = segmentList.iterator();
            Iterator<List<LinearSegmentsNodePlacer.LinearSegment>> successorsIterator = outgoingList.iterator();
            while (segmentIterator.hasNext()) {
                LinearSegmentsNodePlacer.LinearSegment segment = segmentIterator.next();
                List<LinearSegmentsNodePlacer.LinearSegment> successors = successorsIterator.next();
                writer.write("  " + segment.hashCode() + "[label=\"" + segment + "\"]\n");
                for (LinearSegmentsNodePlacer.LinearSegment successor : successors) {
                    writer.write("  " + segment.hashCode() + "->" + successor.hashCode() + "\n");
                }
            }
            writer.write("}\n");
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void writeDebugGraph(LGraph layeredGraph, int layerIndex, List<OrthogonalRoutingGenerator.HyperNode> hypernodes, String debugPrefix, String label) {
        try {
            Writer writer = DebugUtil.createWriter(layeredGraph, layerIndex, debugPrefix, label, FILE_EXTENSION);
            writer.write("digraph {\n");
            for (OrthogonalRoutingGenerator.HyperNode hypernode : hypernodes) {
                writer.write("  " + hypernode.hashCode() + "[label=\"" + hypernode.toString() + "\"]\n");
            }
            for (OrthogonalRoutingGenerator.HyperNode hypernode : hypernodes) {
                for (OrthogonalRoutingGenerator.Dependency dependency : hypernode.getOutgoing()) {
                    writer.write("  " + hypernode.hashCode() + "->" + dependency.getTarget().hashCode() + "[label=\"" + dependency.getWeight() + "\"]\n");
                }
            }
            writer.write("}\n");
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void writeLayer(Writer writer, int layerNumber, List<LNode> nodes) throws IOException {
        if (nodes.isEmpty()) {
            return;
        }
        int nodeNumber = -1;
        for (LNode node : nodes) {
            ++nodeNumber;
            writer.write("        " + node.hashCode());
            StringBuffer options = new StringBuffer();
            options.append("label=\"");
            if (node.getType() == LNode.NodeType.NORMAL) {
                if (node.getName() != null) {
                    options.append(String.valueOf(node.getName().replace("\"", "\\\"")) + " ");
                }
            } else {
                Object origin;
                if (node.getName() != null) {
                    options.append(String.valueOf(node.getName().replace("\"", "\\\"")) + " ");
                } else {
                    options.append("n_" + node.id + " ");
                }
                if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT && (origin = node.getProperty(InternalProperties.ORIGIN)) instanceof LNode) {
                    options.append("(" + ((LNode)origin).toString() + ")");
                }
            }
            options.append("(" + layerNumber + "," + nodeNumber + ")\",");
            if (node.getType() == LNode.NodeType.NORMAL) {
                options.append("shape=box,");
            } else {
                options.append("style=\"rounded,filled\",");
                String color2 = node.getType().getColor();
                if (color2 != null) {
                    options.append("color=\"" + color2 + "\",");
                }
            }
            options.deleteCharAt(options.length() - 1);
            if (options.length() > 0) {
                writer.write("[" + options + "]");
            }
            writer.write(";\n");
        }
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    writer.write("    " + node.hashCode() + " -> " + edge.getTarget().getNode().hashCode());
                    writer.write(";\n");
                }
            }
        }
    }
}

