/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.oned;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import org.eclipse.elk.alg.layered.compaction.oned.CGraph;
import org.eclipse.elk.alg.layered.compaction.oned.CGroup;
import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.ISpacingsHandler;
import org.eclipse.elk.alg.layered.compaction.oned.algs.ICompactionAlgorithm;
import org.eclipse.elk.alg.layered.compaction.oned.algs.IConstraintCalculationAlgorithm;
import org.eclipse.elk.alg.layered.compaction.oned.algs.LongestPathCompaction;
import org.eclipse.elk.alg.layered.compaction.oned.algs.QuadraticConstraintCalculation;
import org.eclipse.elk.alg.layered.compaction.oned.algs.ScanlineConstraintCalculator;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.Pair;

public final class OneDimensionalCompactor {
    public static final ICompactionAlgorithm LONGEST_PATH_COMPACTION = new LongestPathCompaction();
    private ICompactionAlgorithm compactionAlgorithm = LONGEST_PATH_COMPACTION;
    public static final IConstraintCalculationAlgorithm SCANLINE_CONSTRAINTS = new ScanlineConstraintCalculator();
    public static final IConstraintCalculationAlgorithm QUADRATIC_CONSTRAINTS = new QuadraticConstraintCalculation();
    private IConstraintCalculationAlgorithm constraintAlgorithm = SCANLINE_CONSTRAINTS;
    public CGraph cGraph;
    public Direction direction = Direction.UNDEFINED;
    private Function<Pair<CNode, Direction>, Boolean> lockingStrategy;
    private boolean finished = false;
    public ISpacingsHandler<? super CNode> spacingsHandler = ISpacingsHandler.DEFAULT_SPACING_HANDLER;

    public OneDimensionalCompactor(CGraph cGraph) {
        this.cGraph = cGraph;
        this.setLockingStrategy((Function<Pair<CNode, Direction>, Boolean>)((Function)pair -> ((CNode)pair.getFirst()).cGroup.outDegree != 0));
        this.calculateGroupOffsets();
        for (CNode n : cGraph.cNodes) {
            if (n.cGroup != null) continue;
            CGroup group = new CGroup(n);
            cGraph.cGroups.add(group);
        }
    }

    public OneDimensionalCompactor setSpacingsHandler(ISpacingsHandler<? super CNode> handler) {
        this.spacingsHandler = handler;
        return this;
    }

    public OneDimensionalCompactor setCompactionAlgorithm(ICompactionAlgorithm compactor) {
        this.compactionAlgorithm = compactor;
        return this;
    }

    public OneDimensionalCompactor setConstraintAlgorithm(IConstraintCalculationAlgorithm theConstraintAlgorithm) {
        this.constraintAlgorithm = theConstraintAlgorithm;
        return this;
    }

    public OneDimensionalCompactor compact() {
        if (this.finished) {
            throw new IllegalStateException("The " + this.getClass().getSimpleName() + " instance has been finished already.");
        }
        if (this.direction == Direction.UNDEFINED) {
            this.changeDirection(Direction.LEFT);
        }
        for (CGroup g : this.cGraph.cGroups) {
            g.outDegree = 0;
        }
        for (CNode n : this.cGraph.cNodes) {
            n.startPos = Double.NEGATIVE_INFINITY;
            for (CNode incN : n.constraints) {
                ++incN.cGroup.outDegree;
            }
        }
        this.compactionAlgorithm.compact(this);
        for (CNode node : this.cGraph.cNodes) {
            node.reposition = true;
        }
        return this;
    }

    public OneDimensionalCompactor finish() {
        this.changeDirection(Direction.LEFT);
        this.finished = true;
        return this;
    }

    public OneDimensionalCompactor changeDirection(Direction dir) {
        if (this.finished) {
            throw new IllegalStateException("The " + this.getClass().getSimpleName() + " instance has been finished already.");
        }
        if (!this.cGraph.supports(dir)) {
            throw new RuntimeException("The direction " + (Object)((Object)dir) + " is not supported by the CGraph instance.");
        }
        if (dir == this.direction) {
            return this;
        }
        Direction oldDirection = this.direction;
        this.direction = dir;
        block0 : switch (oldDirection) {
            case UNDEFINED: {
                switch (dir) {
                    case LEFT: {
                        this.calculateConstraints();
                        break block0;
                    }
                    case RIGHT: {
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case UP: {
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                }
                break;
            }
            case LEFT: {
                switch (dir) {
                    case RIGHT: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                    case UP: {
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (dir) {
                    case LEFT: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                    case UP: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                }
                break;
            }
            case UP: {
                switch (dir) {
                    case LEFT: {
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case RIGHT: {
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                }
                break;
            }
            case DOWN: {
                switch (dir) {
                    case LEFT: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case RIGHT: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case UP: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                }
                break;
            }
        }
        return this;
    }

    public OneDimensionalCompactor setLockingStrategy(Function<Pair<CNode, Direction>, Boolean> strategy) {
        this.lockingStrategy = strategy;
        return this;
    }

    public OneDimensionalCompactor applyLockingStrategy() {
        this.applyLockingStrategy(this.direction);
        return this;
    }

    public OneDimensionalCompactor applyLockingStrategy(Direction dir) {
        for (CGroup cGroup : this.cGraph.cGroups) {
            cGroup.reposition = true;
        }
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.reposition = (Boolean)this.lockingStrategy.apply(Pair.of(cNode, dir));
            cNode.cGroup.reposition &= ((Boolean)this.lockingStrategy.apply(Pair.of(cNode, dir))).booleanValue();
        }
        return this;
    }

    public OneDimensionalCompactor forceConstraintsRecalculation() {
        this.calculateConstraints();
        return this;
    }

    public OneDimensionalCompactor calculateGroupOffsets() {
        for (CGroup group : this.cGraph.cGroups) {
            group.reference = null;
            for (CNode n : group.cNodes) {
                n.cGroupOffset.reset();
                if (group.reference != null && !(n.hitbox.x < group.reference.hitbox.x)) continue;
                group.reference = n;
            }
            for (CNode n : group.cNodes) {
                n.cGroupOffset.x = n.hitbox.x - group.reference.hitbox.x;
                n.cGroupOffset.y = n.hitbox.y - group.reference.hitbox.y;
            }
        }
        return this;
    }

    private void mirrorHitboxes() {
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.hitbox.x = -cNode.hitbox.x - cNode.hitbox.width;
            if (cNode.parentNode == null) continue;
            cNode.cGroupOffset.x = -cNode.cGroupOffset.x + cNode.parentNode.hitbox.width;
        }
        this.calculateGroupOffsets();
    }

    private void transposeHitboxes() {
        for (CNode cNode : this.cGraph.cNodes) {
            double tmp = cNode.hitbox.x;
            cNode.hitbox.x = cNode.hitbox.y;
            cNode.hitbox.y = tmp;
            tmp = cNode.hitbox.width;
            cNode.hitbox.width = cNode.hitbox.height;
            cNode.hitbox.height = tmp;
            tmp = cNode.cGroupOffset.x;
            cNode.cGroupOffset.x = cNode.cGroupOffset.y;
            cNode.cGroupOffset.y = tmp;
        }
        this.calculateGroupOffsets();
    }

    private void calculateConstraints() {
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.constraints.clear();
        }
        this.constraintAlgorithm.calculateConstraints(this);
        this.calculateConstraintsForCGroups();
    }

    private void calculateConstraintsForCGroups() {
        for (CGroup group : this.cGraph.cGroups) {
            group.outDegree = 0;
            group.incomingConstraints.clear();
        }
        for (CGroup group : this.cGraph.cGroups) {
            for (CNode cNode : group.cNodes) {
                for (CNode inc : cNode.constraints) {
                    if (inc.cGroup == group) continue;
                    group.incomingConstraints.add(inc);
                    ++inc.cGroup.outDegree;
                }
            }
        }
    }

    private void reverseConstraints() {
        HashMap incMap = Maps.newHashMap();
        for (CNode cNode : this.cGraph.cNodes) {
            incMap.put(cNode, Lists.newArrayList());
        }
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.startPos = Double.NEGATIVE_INFINITY;
            for (CNode inc : cNode.constraints) {
                ((List)incMap.get(inc)).add(cNode);
            }
        }
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.constraints.clear();
            cNode.constraints = (List)incMap.get(cNode);
        }
        this.calculateConstraintsForCGroups();
    }

    public OneDimensionalCompactor drawHitboxes(String name) {
        KVector topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        KVector bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (CNode cNode : this.cGraph.cNodes) {
            topLeft.x = Math.min(topLeft.x, cNode.hitbox.x);
            topLeft.y = Math.min(topLeft.y, cNode.hitbox.y);
            bottomRight.x = Math.max(bottomRight.x, cNode.hitbox.x + cNode.hitbox.width);
            bottomRight.y = Math.max(bottomRight.y, cNode.hitbox.y + cNode.hitbox.height);
        }
        KVector size = bottomRight.clone().sub(topLeft);
        try {
            PrintWriter out = new PrintWriter(new FileWriter(name));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"100%\"  viewBox=\"" + topLeft.x + " " + topLeft.y + " " + size.x + " " + size.y + "\">");
            out.println("<defs><marker id=\"markerArrow\" markerWidth=\"13\" markerHeight=\"13\" refX=\"2\" refY=\"6\" orient=\"auto\">  <path d=\"M2,2 L2,11 L10,6 L2,2\" style=\"fill: #000000;\" /></marker></defs>");
            for (CNode cNode : this.cGraph.cNodes) {
                out.println(cNode.getDebugSVG());
                for (CNode inc : cNode.constraints) {
                    out.println("<line x1=\"" + (cNode.hitbox.x + cNode.hitbox.width / 2.0) + "\" y1=\"" + (cNode.hitbox.y + cNode.hitbox.height / 2.0) + "\" x2=\"" + (inc.hitbox.x + inc.hitbox.width / 2.0) + "\" y2=\"" + (inc.hitbox.y + inc.hitbox.height / 2.0) + "\" stroke=\"grey\" opacity=\"0.2\"" + " style=\"marker-start: url(#markerArrow);\" />");
                }
            }
            out.println("</svg>");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }
}

