/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.components.AbstractGraphPlacer;
import org.eclipse.elk.alg.layered.components.ComponentGroup;
import org.eclipse.elk.alg.layered.components.ComponentsCompactor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortSide;

final class ComponentGroupGraphPlacer
extends AbstractGraphPlacer {
    private final List<ComponentGroup> componentGroups = Lists.newArrayList();

    ComponentGroupGraphPlacer() {
    }

    @Override
    public void combine(List<LGraph> components, LGraph target) {
        this.componentGroups.clear();
        assert (!components.contains(target));
        target.getLayerlessNodes().clear();
        if (components.isEmpty()) {
            target.getSize().x = 0.0;
            target.getSize().y = 0.0;
            return;
        }
        LGraph firstComponent = components.get(0);
        target.copyProperties(firstComponent);
        for (LGraph component2 : components) {
            this.addComponent(component2);
        }
        KVector offset2 = new KVector();
        double componentSpacing = firstComponent.getProperty(LayeredOptions.SPACING_COMPONENT_COMPONENT);
        for (ComponentGroup group : this.componentGroups) {
            KVector groupSize = this.placeComponents(group, componentSpacing);
            this.offsetGraphs(group.getComponents(), offset2.x, offset2.y);
            offset2.x += groupSize.x;
            offset2.y += groupSize.y;
        }
        target.getSize().x = offset2.x - componentSpacing;
        target.getSize().y = offset2.y - componentSpacing;
        if (firstComponent.getProperty(LayeredOptions.COMPACTION_CONNECTED_COMPONENTS).booleanValue() && firstComponent.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL) {
            for (LGraph h : components) {
                this.offsetGraph(h, h.getOffset().x, h.getOffset().y);
            }
            ComponentsCompactor compactor = new ComponentsCompactor();
            compactor.compact(components, target.getSize(), componentSpacing);
            for (LGraph h : components) {
                h.getOffset().reset().add(compactor.getOffset());
            }
            target.getSize().reset().add(compactor.getGraphSize());
        }
        for (ComponentGroup group : this.componentGroups) {
            this.moveGraphs(target, group.getComponents(), 0.0, 0.0);
        }
    }

    private void addComponent(LGraph component2) {
        for (ComponentGroup group : this.componentGroups) {
            if (!group.add(component2)) continue;
            return;
        }
        this.componentGroups.add(new ComponentGroup(component2));
    }

    private KVector placeComponents(ComponentGroup group, double spacing) {
        KVector sizeC = this.placeComponentsInRows(group.getComponents(PortSide.SIDES_NONE), spacing);
        KVector sizeN = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_NORTH), spacing);
        KVector sizeS = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_SOUTH), spacing);
        KVector sizeW = this.placeComponentsVertically(group.getComponents(PortSide.SIDES_WEST), spacing);
        KVector sizeE = this.placeComponentsVertically(group.getComponents(PortSide.SIDES_EAST), spacing);
        KVector sizeNW = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_NORTH_WEST), spacing);
        KVector sizeNE = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_NORTH_EAST), spacing);
        KVector sizeSW = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_SOUTH_WEST), spacing);
        KVector sizeSE = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_EAST_SOUTH), spacing);
        KVector sizeWE = this.placeComponentsVertically(group.getComponents(PortSide.SIDES_EAST_WEST), spacing);
        KVector sizeNS = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_NORTH_SOUTH), spacing);
        KVector sizeNWE = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_NORTH_EAST_WEST), spacing);
        KVector sizeSWE = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_EAST_SOUTH_WEST), spacing);
        KVector sizeWNS = this.placeComponentsVertically(group.getComponents(PortSide.SIDES_NORTH_SOUTH_WEST), spacing);
        KVector sizeENS = this.placeComponentsVertically(group.getComponents(PortSide.SIDES_NORTH_EAST_SOUTH), spacing);
        KVector sizeNESW = this.placeComponentsHorizontally(group.getComponents(PortSide.SIDES_NORTH_EAST_SOUTH_WEST), spacing);
        double colLeftWidth = ElkMath.maxd(sizeNW.x, sizeW.x, sizeSW.x, sizeWNS.x);
        double colMidWidth = ElkMath.maxd(sizeN.x, sizeC.x, sizeS.x, sizeNESW.x);
        double colNsWidth = sizeNS.x;
        double colRightWidth = ElkMath.maxd(sizeNE.x, sizeE.x, sizeSE.x, sizeENS.x);
        double rowTopHeight = ElkMath.maxd(sizeNW.y, sizeN.y, sizeNE.y, sizeNWE.y);
        double rowMidHeight = ElkMath.maxd(sizeW.y, sizeC.y, sizeE.y, sizeNESW.y);
        double rowWeHeight = sizeWE.y;
        double rowBottomHeight = ElkMath.maxd(sizeSW.y, sizeS.y, sizeSE.y, sizeSWE.y);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_NONE), colLeftWidth + colNsWidth, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_NORTH_EAST_SOUTH_WEST), colLeftWidth + colNsWidth, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_NORTH), colLeftWidth + colNsWidth, 0.0);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_SOUTH), colLeftWidth + colNsWidth, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_WEST), 0.0, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_EAST), colLeftWidth + colNsWidth + colMidWidth, rowTopHeight + rowWeHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_NORTH_EAST), colLeftWidth + colNsWidth + colMidWidth, 0.0);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_SOUTH_WEST), 0.0, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_EAST_SOUTH), colLeftWidth + colNsWidth + colMidWidth, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_EAST_WEST), 0.0, rowTopHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_NORTH_SOUTH), colLeftWidth, 0.0);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_EAST_SOUTH_WEST), 0.0, rowTopHeight + rowWeHeight + rowMidHeight);
        this.offsetGraphs(group.getComponents(PortSide.SIDES_NORTH_EAST_SOUTH), colLeftWidth + colNsWidth + colMidWidth, 0.0);
        KVector componentSize = new KVector();
        componentSize.x = ElkMath.maxd(colLeftWidth + colMidWidth + colNsWidth + colRightWidth, sizeWE.x, sizeNWE.x, sizeSWE.x);
        componentSize.y = ElkMath.maxd(rowTopHeight + rowMidHeight + rowWeHeight + rowBottomHeight, sizeNS.y, sizeWNS.y, sizeENS.y);
        return componentSize;
    }

    private KVector placeComponentsHorizontally(Collection<LGraph> components, double spacing) {
        KVector size = new KVector();
        for (LGraph component2 : components) {
            this.offsetGraph(component2, size.x, 0.0);
            size.x += component2.getSize().x + spacing;
            size.y = Math.max(size.y, component2.getSize().y);
        }
        if (size.y > 0.0) {
            size.y += spacing;
        }
        return size;
    }

    private KVector placeComponentsVertically(Collection<LGraph> components, double spacing) {
        KVector size = new KVector();
        for (LGraph component2 : components) {
            this.offsetGraph(component2, 0.0, size.y);
            size.y += component2.getSize().y + spacing;
            size.x = Math.max(size.x, component2.getSize().x);
        }
        if (size.x > 0.0) {
            size.x += spacing;
        }
        return size;
    }

    private KVector placeComponentsInRows(Collection<LGraph> components, double spacing) {
        if (components.isEmpty()) {
            return new KVector();
        }
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (LGraph component2 : components) {
            KVector componentSize = component2.getSize();
            maxRowWidth = Math.max(maxRowWidth, componentSize.x);
            totalArea += componentSize.x * componentSize.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea)) * components.iterator().next().getProperty(LayeredOptions.ASPECT_RATIO));
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.offsetGraph(graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        return new KVector(broadestRow + spacing, ypos + highestBox + spacing);
    }
}

