/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.compaction.components.IComponent;
import org.eclipse.elk.alg.layered.compaction.components.IConnectedComponents;
import org.eclipse.elk.alg.layered.compaction.components.IExternalExtension;
import org.eclipse.elk.alg.layered.compaction.components.OneDimensionalComponentsCompaction;
import org.eclipse.elk.alg.layered.compaction.recthull.Point;
import org.eclipse.elk.alg.layered.compaction.recthull.RectilinearConvexHull;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class ComponentsCompactor {
    private OneDimensionalComponentsCompaction<LNode, Set<LEdge>> compactor;
    private KVector yetAnotherOffset;
    private KVector compactedGraphSize;
    private KVector graphTopLeft;
    private KVector graphBottomRight;
    private static final double EPSILON = 1.0E-4;

    public void compact(List<LGraph> graphs, KVector originalGraphsSize, double spacing) {
        this.graphTopLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.graphBottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (LGraph graph : graphs) {
            for (LNode node : graph.getLayerlessNodes()) {
                this.graphTopLeft.x = Math.min(this.graphTopLeft.x, node.getPosition().x - node.getMargin().left);
                this.graphTopLeft.y = Math.min(this.graphTopLeft.y, node.getPosition().y - node.getMargin().top);
                this.graphBottomRight.x = Math.max(this.graphBottomRight.x, node.getPosition().x + node.getSize().x + node.getMargin().right);
                this.graphBottomRight.y = Math.max(this.graphBottomRight.y, node.getPosition().y + node.getSize().y + node.getMargin().bottom);
            }
        }
        InternalConnectedComponents ccs = new InternalConnectedComponents();
        for (LGraph lGraph : graphs) {
            IComponent<LNode, Set<LEdge>> c = this.transformLGraph(lGraph);
            ccs.getComponents().add(c);
            InternalComponent internalComponent = (InternalComponent)c;
            internalComponent.containsRegularNodes = internalComponent.containsRegularNodes | !c.getExternalExtensionSides().isEmpty();
        }
        this.compactor = OneDimensionalComponentsCompaction.init(ccs, spacing);
        this.compactor.compact(new BasicProgressMonitor());
        this.yetAnotherOffset = new KVector();
        this.compactedGraphSize = this.compactor.getGraphSize();
        for (IComponent iComponent : ccs.getComponents()) {
            KVector offset2 = this.compactor.getOffset(iComponent);
            LGraphUtil.offsetGraph(((InternalComponent)iComponent).graph, offset2.x, offset2.y);
            for (LNode n : ((InternalComponent)iComponent).getNodes()) {
                if (n.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                KVector newPos = this.getExternalPortPosition(n.getPosition(), n.getProperty(InternalProperties.EXT_PORT_SIDE));
                n.getPosition().reset().add(newPos);
            }
        }
        for (IComponent iComponent : ccs.getComponents()) {
            for (LEdge e : ((InternalComponent)iComponent).getExternalEdges()) {
                KVectorChain vc = new KVectorChain(e.getBendPoints());
                vc.add(0, e.getSource().getAbsoluteAnchor());
                vc.add(e.getTarget().getAbsoluteAnchor());
                KVector last = null;
                for (KVector v : vc) {
                    if (last == null) {
                        last = v;
                        continue;
                    }
                    if (DoubleMath.fuzzyEquals((double)last.x, (double)v.x, (double)1.0E-4)) {
                        this.yetAnotherOffset.x = Math.min(this.yetAnotherOffset.x, last.x);
                        this.compactedGraphSize.x = Math.max(this.compactedGraphSize.x, last.x);
                    } else if (DoubleMath.fuzzyEquals((double)last.y, (double)v.y, (double)1.0E-4)) {
                        this.yetAnotherOffset.y = Math.min(this.yetAnotherOffset.y, last.y);
                        this.compactedGraphSize.y = Math.max(this.compactedGraphSize.y, last.y);
                    }
                    last = v;
                }
            }
        }
        this.yetAnotherOffset.negate();
        this.compactedGraphSize.add(this.yetAnotherOffset);
    }

    public KVector getOffset() {
        return this.yetAnotherOffset;
    }

    public KVector getGraphSize() {
        return this.compactedGraphSize;
    }

    private IComponent<LNode, Set<LEdge>> transformLGraph(LGraph graph) {
        InternalComponent component2 = new InternalComponent(graph);
        if (!component2.containsRegularNodes) {
            this.createDummyNode(graph);
        }
        Hullpoints hullPoints = this.componentHullPoints(graph);
        HashMultimap externalExtensions = HashMultimap.create();
        OuterSegments outerSegments = new OuterSegments();
        for (LNode node : graph.getLayerlessNodes()) {
            for (LEdge edge : node.getOutgoingEdges()) {
                if (!this.isExternalEdge(edge)) continue;
                IExternalExtension<LEdge> iee = this.transformLEdge(edge, hullPoints, outerSegments);
                externalExtensions.put((Object)iee.getDirection(), (Object)iee.getRepresentative());
            }
        }
        ArrayList extensions = Lists.newArrayList();
        for (PortSide ps : component2.getExternalExtensionSides()) {
            double min = outerSegments.min[ps.ordinal()];
            double max = outerSegments.max[ps.ordinal()];
            double extent = outerSegments.extent[ps.ordinal()];
            ElkRectangle extension = null;
            ElkRectangle placeholder = null;
            switch (ps) {
                case WEST: {
                    extension = new ElkRectangle(this.graphTopLeft.x, min, ((Hullpoints)hullPoints).topLeft.x - this.graphTopLeft.x, max - min);
                    placeholder = new ElkRectangle(this.graphTopLeft.x, min, extent, max - min);
                    hullPoints.add(extension.getTopRight());
                    hullPoints.add(extension.getBottomRight());
                    break;
                }
                case EAST: {
                    extension = new ElkRectangle(((Hullpoints)hullPoints).bottomRight.x, min, this.graphBottomRight.x - ((Hullpoints)hullPoints).bottomRight.x, max - min);
                    placeholder = new ElkRectangle(this.graphBottomRight.x - extent, min, extent, max - min);
                    hullPoints.add(extension.getTopLeft());
                    hullPoints.add(extension.getBottomLeft());
                    break;
                }
                case NORTH: {
                    extension = new ElkRectangle(min, this.graphTopLeft.y, max - min, ((Hullpoints)hullPoints).topLeft.y - this.graphTopLeft.y);
                    placeholder = new ElkRectangle(min, this.graphTopLeft.y, max - min, extent);
                    hullPoints.add(extension.getBottomLeft());
                    hullPoints.add(extension.getBottomRight());
                    break;
                }
                case SOUTH: {
                    extension = new ElkRectangle(min, ((Hullpoints)hullPoints).bottomRight.y, max - min, this.graphBottomRight.y - ((Hullpoints)hullPoints).bottomRight.y);
                    placeholder = new ElkRectangle(min, this.graphBottomRight.y - extent, max - min, extent);
                    hullPoints.add(extension.getTopLeft());
                    hullPoints.add(extension.getTopRight());
                }
            }
            if (extension == null) continue;
            InternalUnionExternalExtension iuee = new InternalUnionExternalExtension();
            iuee.side = ps;
            iuee.extension = extension;
            iuee.placeholder = placeholder;
            iuee.edges = Sets.newHashSet((Iterable)externalExtensions.get((Object)this.portSideToDirection(ps)));
            extensions.add(iuee);
        }
        component2.externalExtensions.addAll(extensions);
        component2.rectilinearConvexHull = RectilinearConvexHull.of(hullPoints).splitIntoRectangles();
        return component2;
    }

    private LNode createDummyNode(LGraph graph) {
        assert (graph.getLayerlessNodes().size() == 1);
        LNode extPortDummy = graph.getLayerlessNodes().get(0);
        LNode dummy = new LNode(graph);
        graph.getLayerlessNodes().add(dummy);
        dummy.getSize().x = Math.max(1.0, extPortDummy.getSize().x);
        dummy.getSize().y = Math.max(1.0, extPortDummy.getSize().y);
        dummy.getPosition().x = extPortDummy.getPosition().x;
        dummy.getPosition().y = extPortDummy.getPosition().y;
        switch (extPortDummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
            case WEST: {
                dummy.getPosition().x += 2.0;
                break;
            }
            case NORTH: {
                dummy.getPosition().y += 2.0;
                break;
            }
            case EAST: {
                dummy.getPosition().x -= 2.0;
                break;
            }
            case SOUTH: {
                dummy.getPosition().y -= 2.0;
            }
        }
        LPort dummyPort = new LPort();
        dummyPort.setNode(dummy);
        LEdge dummyEdge = new LEdge();
        LPort extPortDummyPort = extPortDummy.getPorts().get(0);
        dummyEdge.setSource(extPortDummyPort);
        dummyEdge.setTarget(dummyPort);
        dummyPort.getPosition().reset().add(extPortDummyPort.getPosition());
        dummyPort.getAnchor().reset().add(extPortDummyPort.getAnchor());
        return dummy;
    }

    private Hullpoints componentHullPoints(LGraph graph) {
        Hullpoints pts = new Hullpoints();
        for (LNode n : graph.getLayerlessNodes()) {
            if (n.getType() == LNode.NodeType.EXTERNAL_PORT) continue;
            this.addLGraphElementBounds(pts, n, new KVector());
            for (LEdge edge : n.getOutgoingEdges()) {
                if (this.isExternalEdge(edge)) continue;
                Iterator iterator = edge.getBendPoints().iterator();
                while (iterator.hasNext()) {
                    KVector bp;
                    KVector absolute = bp = (KVector)iterator.next();
                    pts.add(new Point(absolute.x, absolute.y));
                }
            }
        }
        return pts;
    }

    private void addLGraphElementBounds(List<Point> pts, LShape element, KVector offset2) {
        LMargin margins = null;
        if (element instanceof LNode) {
            margins = ((LNode)element).getMargin();
        } else if (element instanceof LPort) {
            margins = ((LPort)element).getMargin();
        } else if (element instanceof LLabel) {
            margins = new LMargin();
        }
        pts.add(new Point(element.getPosition().x - margins.left + offset2.x, element.getPosition().y - margins.top + offset2.y));
        pts.add(new Point(element.getPosition().x - margins.left + offset2.x, element.getPosition().y + element.getSize().y + margins.bottom + offset2.y));
        pts.add(new Point(element.getPosition().x + element.getSize().x + margins.right + offset2.x, element.getPosition().y - margins.top + offset2.y));
        pts.add(new Point(element.getPosition().x + element.getSize().x + margins.right + offset2.x, element.getPosition().y + element.getSize().y + margins.bottom + offset2.y));
    }

    private boolean isExternalEdge(LEdge edge) {
        return edge.getSource().getNode().getType() == LNode.NodeType.EXTERNAL_PORT || edge.getTarget().getNode().getType() == LNode.NodeType.EXTERNAL_PORT;
    }

    private IExternalExtension<LEdge> transformLEdge(LEdge externalEdge, Hullpoints hullPoints, OuterSegments outerSegments) {
        InternalExternalExtension externalExtension = new InternalExternalExtension(externalEdge);
        Segments segments = this.edgeToSegments(externalEdge, externalExtension);
        double thickness = Math.max(externalEdge.getProperty(LayeredOptions.EDGE_THICKNESS), 1.0);
        for (Pair segment : segments.innerSegments) {
            ElkRectangle rect = this.segmentToRectangle((KVector)segment.getFirst(), (KVector)segment.getSecond(), thickness);
            hullPoints.add(rect);
        }
        PortSide side = externalExtension.externalPortSide;
        ElkRectangle outerSegmentRect = this.segmentToRectangle((KVector)segments.outerSegment.getFirst(), (KVector)segments.outerSegment.getSecond(), thickness);
        if (side == PortSide.WEST || side == PortSide.EAST) {
            ((OuterSegments)outerSegments).min[side.ordinal()] = Math.min(outerSegments.min[side.ordinal()], outerSegmentRect.y);
            ((OuterSegments)outerSegments).max[side.ordinal()] = Math.max(outerSegments.max[side.ordinal()], outerSegmentRect.y + outerSegmentRect.height);
        } else {
            ((OuterSegments)outerSegments).min[side.ordinal()] = Math.min(outerSegments.min[side.ordinal()], outerSegmentRect.x);
            ((OuterSegments)outerSegments).max[side.ordinal()] = Math.max(outerSegments.max[side.ordinal()], outerSegmentRect.x + outerSegmentRect.width);
        }
        double extent = Double.NEGATIVE_INFINITY;
        LMargin margins = externalExtension.externalPort.getNode().getMargin();
        switch (side) {
            case WEST: {
                extent = margins.right;
                break;
            }
            case EAST: {
                extent = margins.left;
                break;
            }
            case NORTH: {
                extent = margins.bottom;
                break;
            }
            case SOUTH: {
                extent = margins.top;
            }
        }
        ((OuterSegments)outerSegments).extent[side.ordinal()] = Math.max(outerSegments.extent[side.ordinal()], extent);
        return externalExtension;
    }

    private ElkRectangle segmentToRectangle(KVector p1, KVector p2, double extent) {
        return new ElkRectangle(Math.min(p1.x, p2.x) - extent / 2.0, Math.min(p1.y, p2.y) - extent / 2.0, Math.abs(p1.x - p2.x) + extent, Math.abs(p1.y - p2.y) + extent);
    }

    private Segments edgeToSegments(LEdge edge, InternalExternalExtension externalExtension) {
        LPort externalPort = externalExtension.externalPort;
        PortSide externalPortSide = externalExtension.externalPortSide;
        KVector p1 = edge.getSource().getAbsoluteAnchor();
        KVector p2 = edge.getTarget().getAbsoluteAnchor();
        if (externalPort == edge.getSource()) {
            p1 = this.getExternalPortPosition(p1, externalPortSide);
            p2 = this.getPortPositionOnMargin(edge.getTarget());
        } else {
            p1 = this.getPortPositionOnMargin(edge.getSource());
            p2 = this.getExternalPortPosition(p2, externalPortSide);
        }
        KVectorChain points = new KVectorChain(edge.getBendPoints());
        points.addFirst(p1);
        points.addLast(p2);
        boolean outerSegmentIsFirst = edge.getSource() == externalPort;
        Segments segments = new Segments();
        int i = 0;
        while (i < points.size() - 1) {
            Pair<KVector, KVector> segment = Pair.of((KVector)points.get(i), (KVector)points.get(i + 1));
            if (outerSegmentIsFirst && i == 0 || !outerSegmentIsFirst && i == points.size() - 2) {
                segments.outerSegment = segment;
            } else {
                segments.innerSegments.add(segment);
            }
            ++i;
        }
        return segments;
    }

    private KVector getExternalPortPosition(KVector pos, PortSide ps) {
        switch (ps) {
            case NORTH: {
                return new KVector(pos.x, Math.min(this.graphTopLeft.y, pos.y));
            }
            case EAST: {
                return new KVector(Math.max(this.graphBottomRight.x, pos.x), pos.y);
            }
            case SOUTH: {
                return new KVector(pos.x, Math.max(this.graphBottomRight.y, pos.y));
            }
            case WEST: {
                return new KVector(Math.min(pos.x, this.graphTopLeft.x), pos.y);
            }
        }
        return pos.clone();
    }

    private KVector getPortPositionOnMargin(LPort port) {
        KVector pos = port.getAbsoluteAnchor().clone();
        LMargin margins = port.getNode().getMargin();
        switch (port.getSide()) {
            case NORTH: {
                pos.y -= margins.top;
                break;
            }
            case EAST: {
                pos.x += margins.right;
                break;
            }
            case SOUTH: {
                pos.y += margins.bottom;
                break;
            }
            case WEST: {
                pos.x -= margins.left;
            }
        }
        return pos;
    }

    private Direction portSideToDirection(PortSide side) {
        switch (side) {
            case NORTH: {
                return Direction.UP;
            }
            case WEST: {
                return Direction.LEFT;
            }
            case EAST: {
                return Direction.RIGHT;
            }
            case SOUTH: {
                return Direction.DOWN;
            }
        }
        return Direction.UNDEFINED;
    }

    private static final class Hullpoints
    extends ArrayList<Point> {
        private static final long serialVersionUID = -8667344007490805272L;
        private KVector topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        private KVector bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);

        private Hullpoints() {
        }

        @Override
        public boolean add(Point e) {
            this.topLeft.x = Math.min(this.topLeft.x, e.x);
            this.topLeft.y = Math.min(this.topLeft.y, e.y);
            this.bottomRight.x = Math.max(this.bottomRight.x, e.x);
            this.bottomRight.y = Math.max(this.bottomRight.y, e.y);
            return super.add(e);
        }

        @Override
        public boolean add(KVector e) {
            return this.add(Point.from(e));
        }

        @Override
        public boolean add(ElkRectangle rect) {
            boolean returnVal = true;
            returnVal &= this.add(rect.getPosition());
            returnVal &= this.add(rect.getPosition().add(rect.width, 0.0));
            returnVal &= this.add(rect.getPosition().add(0.0, rect.height));
            return returnVal &= this.add(rect.getPosition().add(rect.width, rect.height));
        }
    }

    private class InternalComponent
    implements IComponent<LNode, Set<LEdge>> {
        private LGraph graph;
        private boolean containsRegularNodes;
        private List<ElkRectangle> rectilinearConvexHull;
        private List<IExternalExtension<Set<LEdge>>> externalExtensions = Lists.newArrayList();

        public InternalComponent(LGraph graph) {
            this.graph = graph;
            this.containsRegularNodes = false;
            for (LNode n : graph.getLayerlessNodes()) {
                this.containsRegularNodes |= n.getType() == LNode.NodeType.NORMAL;
            }
        }

        @Override
        public Set<PortSide> getExternalExtensionSides() {
            return this.graph.getProperty(InternalProperties.EXT_PORT_CONNECTIONS);
        }

        @Override
        public List<ElkRectangle> getHull() {
            return this.rectilinearConvexHull;
        }

        @Override
        public List<IExternalExtension<Set<LEdge>>> getExternalExtensions() {
            return this.externalExtensions;
        }

        private List<LNode> getNodes() {
            return this.graph.getLayerlessNodes();
        }

        private List<LEdge> getExternalEdges() {
            ArrayList edges = Lists.newArrayList();
            for (IExternalExtension<Set<LEdge>> ee : this.externalExtensions) {
                edges.addAll((Collection)ee.getRepresentative());
            }
            return edges;
        }
    }

    private class InternalConnectedComponents
    implements IConnectedComponents<LNode, Set<LEdge>> {
        private List<IComponent<LNode, Set<LEdge>>> components = Lists.newArrayList();
        private boolean containsExternalPorts = false;

        @Override
        public Iterator<IComponent<LNode, Set<LEdge>>> iterator() {
            return this.components.iterator();
        }

        @Override
        public List<IComponent<LNode, Set<LEdge>>> getComponents() {
            return this.components;
        }

        @Override
        public boolean isContainsExternalExtensions() {
            return this.containsExternalPorts;
        }
    }

    private final class InternalExternalExtension
    implements IExternalExtension<LEdge> {
        private LEdge edge;
        private LPort externalPort;
        private PortSide externalPortSide;
        private ElkRectangle externalExtension;
        private ElkRectangle parent;

        public InternalExternalExtension(LEdge edge) {
            this.edge = edge;
            if (edge.getSource().getNode().getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.externalPort = edge.getSource();
                this.externalPortSide = edge.getSource().getNode().getProperty(InternalProperties.EXT_PORT_SIDE);
            } else if (edge.getTarget().getNode().getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.externalPort = edge.getTarget();
                this.externalPortSide = edge.getTarget().getNode().getProperty(InternalProperties.EXT_PORT_SIDE);
            } else {
                throw new IllegalArgumentException("Edge " + edge + " is not an external edge.");
            }
        }

        @Override
        public Direction getDirection() {
            return ComponentsCompactor.this.portSideToDirection(this.externalPortSide);
        }

        @Override
        public LEdge getRepresentative() {
            return this.edge;
        }

        @Override
        public ElkRectangle getRepresentor() {
            return this.externalExtension;
        }

        @Override
        public ElkRectangle getParent() {
            return this.parent;
        }
    }

    private final class InternalUnionExternalExtension
    implements IExternalExtension<Set<LEdge>> {
        private Set<LEdge> edges = Sets.newHashSet();
        private PortSide side;
        private ElkRectangle extension;
        private ElkRectangle placeholder;

        private InternalUnionExternalExtension() {
        }

        @Override
        public Set<LEdge> getRepresentative() {
            return this.edges;
        }

        @Override
        public ElkRectangle getRepresentor() {
            return this.extension;
        }

        @Override
        public ElkRectangle getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Direction getDirection() {
            return ComponentsCompactor.this.portSideToDirection(this.side);
        }

        @Override
        public ElkRectangle getPlaceholder() {
            return this.placeholder;
        }
    }

    private static class OuterSegments {
        private double[] min = new double[PortSide.values().length];
        private double[] max = new double[PortSide.values().length];
        private double[] extent = new double[PortSide.values().length];

        public OuterSegments() {
            Arrays.fill(this.min, Double.POSITIVE_INFINITY);
            Arrays.fill(this.max, Double.NEGATIVE_INFINITY);
            Arrays.fill(this.extent, Double.NEGATIVE_INFINITY);
        }
    }

    private static final class Segments {
        private List<Pair<KVector, KVector>> innerSegments = Lists.newArrayList();
        private Pair<KVector, KVector> outerSegment;

        private Segments() {
        }
    }
}

