/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compound;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.elk.alg.layered.compound.CrossHierarchyEdge;
import org.eclipse.elk.alg.layered.compound.CrossHierarchyEdgeComparator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;

public class CompoundGraphPreprocessor
implements ILayoutProcessor<LGraph> {
    private Multimap<LEdge, CrossHierarchyEdge> crossHierarchyMap;
    private final Map<LPort, LNode> dummyNodeMap = Maps.newHashMap();

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Compound graph preprocessor", 1.0f);
        this.crossHierarchyMap = HashMultimap.create();
        this.transformHierarchyEdges(graph, null);
        this.moveLabelsAndRemoveOriginalEdges(graph);
        this.setSidesOfPortsToSidesOfDummyNodes();
        graph.setProperty(InternalProperties.CROSS_HIERARCHY_MAP, this.crossHierarchyMap);
        this.crossHierarchyMap = null;
        this.dummyNodeMap.clear();
        monitor.done();
    }

    private void setSidesOfPortsToSidesOfDummyNodes() {
        for (Map.Entry<LPort, LNode> e : this.dummyNodeMap.entrySet()) {
            LPort externalPort = e.getKey();
            LNode dummyNode = e.getValue();
            dummyNode.setProperty(InternalProperties.ORIGIN, externalPort);
            externalPort.setProperty(InternalProperties.PORT_DUMMY, dummyNode);
            externalPort.setProperty(InternalProperties.INSIDE_CONNECTIONS, (Object)true);
            externalPort.setSide(dummyNode.getProperty(InternalProperties.EXT_PORT_SIDE));
            dummyNode.getProperty(InternalProperties.EXT_PORT_SIDE);
            externalPort.getNode().setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
            externalPort.getNode().getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES).add(GraphProperties.NON_FREE_PORTS);
        }
    }

    private List<ExternalPort> transformHierarchyEdges(LGraph graph, LNode parentNode) {
        ArrayList containedExternalPorts = Lists.newArrayList();
        for (LNode node : graph.getLayerlessNodes()) {
            LGraph nestedGraph = node.getProperty(InternalProperties.NESTED_LGRAPH);
            if (nestedGraph == null) continue;
            List<ExternalPort> childPorts = this.transformHierarchyEdges(nestedGraph, node);
            containedExternalPorts.addAll(childPorts);
            this.processInsideSelfLoops(nestedGraph, node);
            if (!nestedGraph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) continue;
            PortConstraints portConstraints = node.getProperty(LayeredOptions.PORT_CONSTRAINTS);
            boolean insidePortLabels = node.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT) == PortLabelPlacement.INSIDE;
            for (LPort port : node.getPorts()) {
                LNode dummyNode = this.dummyNodeMap.get(port);
                if (dummyNode == null) {
                    dummyNode = LGraphUtil.createExternalPortDummy(port, portConstraints, port.getSide(), -port.getNetFlow(), null, null, port.getSize(), nestedGraph.getProperty(LayeredOptions.DIRECTION), nestedGraph);
                    dummyNode.setProperty(InternalProperties.ORIGIN, port);
                    this.dummyNodeMap.put(port, dummyNode);
                    nestedGraph.getLayerlessNodes().add(dummyNode);
                }
                LPort dummyNodePort = dummyNode.getPorts().get(0);
                for (LLabel extPortLabel : port.getLabels()) {
                    LLabel dummyPortLabel = new LLabel();
                    dummyPortLabel.getSize().x = extPortLabel.getSize().x;
                    dummyPortLabel.getSize().y = extPortLabel.getSize().y;
                    dummyNodePort.getLabels().add(dummyPortLabel);
                    if (insidePortLabels) continue;
                    switch (port.getSide()) {
                        case EAST: 
                        case WEST: {
                            dummyPortLabel.getSize().x = 0.0;
                            dummyPortLabel.getSize().y = extPortLabel.getSize().y;
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            dummyPortLabel.getSize().x = extPortLabel.getSize().x;
                            dummyPortLabel.getSize().y = 0.0;
                        }
                    }
                }
            }
        }
        ArrayList exportedExternalPorts = Lists.newArrayList();
        this.processInnerHierarchicalEdgeSegments(graph, parentNode, containedExternalPorts, exportedExternalPorts);
        if (parentNode != null) {
            this.processOuterHierarchicalEdgeSegments(graph, parentNode, exportedExternalPorts);
        }
        return exportedExternalPorts;
    }

    private void moveLabelsAndRemoveOriginalEdges(LGraph graph) {
        for (LEdge origEdge : this.crossHierarchyMap.keySet()) {
            if (origEdge.getLabels().size() > 0) {
                ArrayList<CrossHierarchyEdge> edgeSegments = new ArrayList<CrossHierarchyEdge>(this.crossHierarchyMap.get((Object)origEdge));
                Collections.sort(edgeSegments, new CrossHierarchyEdgeComparator(graph));
                ListIterator<LLabel> labelIterator = origEdge.getLabels().listIterator();
                while (labelIterator.hasNext()) {
                    LLabel currLabel = (LLabel)labelIterator.next();
                    int targetDummyEdgeIndex = -1;
                    switch (currLabel.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT)) {
                        case HEAD: {
                            targetDummyEdgeIndex = edgeSegments.size() - 1;
                            break;
                        }
                        case CENTER: {
                            targetDummyEdgeIndex = this.getShallowestEdgeSegment(edgeSegments);
                            break;
                        }
                        case TAIL: {
                            targetDummyEdgeIndex = 0;
                        }
                    }
                    if (targetDummyEdgeIndex == -1) continue;
                    CrossHierarchyEdge targetSegment = (CrossHierarchyEdge)edgeSegments.get(targetDummyEdgeIndex);
                    targetSegment.getEdge().getLabels().add(currLabel);
                    targetSegment.getEdge().getSource().getNode().getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES).add(GraphProperties.END_LABELS);
                    targetSegment.getEdge().getSource().getNode().getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES).add(GraphProperties.CENTER_LABELS);
                    labelIterator.remove();
                    currLabel.setProperty(InternalProperties.ORIGINAL_LABEL_EDGE, origEdge);
                }
            }
            origEdge.setSource(null);
            origEdge.setTarget(null);
        }
    }

    private int getShallowestEdgeSegment(List<CrossHierarchyEdge> edgeSegments) {
        int result = -1;
        int index = 0;
        for (CrossHierarchyEdge crossHierarchyEdge : edgeSegments) {
            if (crossHierarchyEdge.getType().equals((Object)PortType.INPUT)) {
                result = index == 0 ? 0 : index - 1;
                break;
            }
            if (index == edgeSegments.size() - 1) {
                result = index;
            }
            ++index;
        }
        return result;
    }

    private void processInnerHierarchicalEdgeSegments(LGraph graph, LNode parentNode, List<ExternalPort> containedExternalPorts, List<ExternalPort> exportedExternalPorts) {
        ArrayList createdExternalPorts = Lists.newArrayList();
        for (ExternalPort externalPort : containedExternalPorts) {
            ExternalPort newExternalPort;
            ExternalPort currentExternalPort = null;
            if (externalPort.type == PortType.OUTPUT) {
                for (LEdge outEdge : externalPort.origEdges) {
                    LNode targetNode = outEdge.getTarget().getNode();
                    if (targetNode.getGraph() == graph) {
                        this.connectChild(graph, externalPort, outEdge, externalPort.dummyPort, outEdge.getTarget());
                        continue;
                    }
                    if (parentNode == null || LGraphUtil.isDescendant(targetNode, parentNode)) {
                        this.connectSiblings(graph, externalPort, containedExternalPorts, outEdge);
                        continue;
                    }
                    newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, outEdge, externalPort.dummyPort, PortType.OUTPUT, currentExternalPort);
                    if (newExternalPort != currentExternalPort) {
                        createdExternalPorts.add(newExternalPort);
                    }
                    if (!newExternalPort.exported) continue;
                    currentExternalPort = newExternalPort;
                }
                continue;
            }
            for (LEdge inEdge : externalPort.origEdges) {
                LNode sourceNode = inEdge.getSource().getNode();
                if (sourceNode.getGraph() == graph) {
                    this.connectChild(graph, externalPort, inEdge, inEdge.getSource(), externalPort.dummyPort);
                    continue;
                }
                if (parentNode == null || LGraphUtil.isDescendant(sourceNode, parentNode)) continue;
                newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, inEdge, externalPort.dummyPort, PortType.INPUT, currentExternalPort);
                if (newExternalPort != currentExternalPort) {
                    createdExternalPorts.add(newExternalPort);
                }
                if (!newExternalPort.exported) continue;
                currentExternalPort = newExternalPort;
            }
        }
        for (ExternalPort externalPort : createdExternalPorts) {
            if (!graph.getLayerlessNodes().contains(externalPort.dummyNode)) {
                graph.getLayerlessNodes().add(externalPort.dummyNode);
            }
            if (!externalPort.exported) continue;
            exportedExternalPorts.add(externalPort);
        }
    }

    private void connectChild(LGraph graph, ExternalPort externalPort, LEdge origEdge, LPort sourcePort, LPort targetPort) {
        LEdge dummyEdge = this.createDummyEdge(graph, origEdge);
        dummyEdge.setSource(sourcePort);
        dummyEdge.setTarget(targetPort);
        this.crossHierarchyMap.put((Object)origEdge, (Object)new CrossHierarchyEdge(dummyEdge, graph, externalPort.type));
    }

    private void connectSiblings(LGraph graph, ExternalPort externalOutputPort, List<ExternalPort> containedExternalPorts, LEdge origEdge) {
        ExternalPort targetExternalPort = null;
        for (ExternalPort externalPort2 : containedExternalPorts) {
            if (externalPort2 == externalOutputPort || !externalPort2.origEdges.contains(origEdge)) continue;
            targetExternalPort = externalPort2;
            break;
        }
        assert (targetExternalPort.type == PortType.INPUT);
        LEdge dummyEdge = this.createDummyEdge(graph, origEdge);
        dummyEdge.setSource(externalOutputPort.dummyPort);
        dummyEdge.setTarget(targetExternalPort.dummyPort);
        this.crossHierarchyMap.put((Object)origEdge, (Object)new CrossHierarchyEdge(dummyEdge, graph, externalOutputPort.type));
    }

    private void processOuterHierarchicalEdgeSegments(LGraph graph, LNode parentNode, List<ExternalPort> exportedExternalPorts) {
        ArrayList createdExternalPorts = Lists.newArrayList();
        for (LNode childNode : graph.getLayerlessNodes()) {
            for (LPort childPort : childNode.getPorts()) {
                ExternalPort currentExternalOutputPort = null;
                LEdge[] lEdgeArray = childPort.getOutgoingEdges().toArray(new LEdge[0]);
                int n = lEdgeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LEdge outEdge = lEdgeArray[n2];
                    if (!LGraphUtil.isDescendant(outEdge.getTarget().getNode(), parentNode)) {
                        ExternalPort newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, outEdge, outEdge.getSource(), PortType.OUTPUT, currentExternalOutputPort);
                        if (newExternalPort != currentExternalOutputPort) {
                            createdExternalPorts.add(newExternalPort);
                        }
                        if (newExternalPort.exported) {
                            currentExternalOutputPort = newExternalPort;
                        }
                    }
                    ++n2;
                }
                ExternalPort currentExternalInputPort = null;
                LEdge[] lEdgeArray2 = childPort.getIncomingEdges().toArray(new LEdge[0]);
                int n3 = lEdgeArray2.length;
                n = 0;
                while (n < n3) {
                    LEdge inEdge = lEdgeArray2[n];
                    if (!LGraphUtil.isDescendant(inEdge.getSource().getNode(), parentNode)) {
                        ExternalPort newExternalPort = this.introduceHierarchicalEdgeSegment(graph, parentNode, inEdge, inEdge.getTarget(), PortType.INPUT, currentExternalInputPort);
                        if (newExternalPort != currentExternalInputPort) {
                            createdExternalPorts.add(newExternalPort);
                        }
                        if (newExternalPort.exported) {
                            currentExternalInputPort = newExternalPort;
                        }
                    }
                    ++n;
                }
            }
        }
        for (ExternalPort externalPort : createdExternalPorts) {
            if (!graph.getLayerlessNodes().contains(externalPort.dummyNode)) {
                graph.getLayerlessNodes().add(externalPort.dummyNode);
            }
            if (!externalPort.exported) continue;
            exportedExternalPorts.add(externalPort);
        }
    }

    private void processInsideSelfLoops(LGraph nestedGraph, LNode node) {
        if (!node.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE).booleanValue()) {
            return;
        }
        for (LPort lport : node.getPorts()) {
            LEdge[] outEdges;
            LEdge[] lEdgeArray = outEdges = lport.getOutgoingEdges().toArray(new LEdge[lport.getOutgoingEdges().size()]);
            int n = outEdges.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isInsideSelfLoop;
                LEdge outEdge = lEdgeArray[n2];
                boolean isSelfLoop = outEdge.getTarget().getNode() == node;
                boolean bl = isInsideSelfLoop = isSelfLoop && outEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                if (isInsideSelfLoop) {
                    LPort targetPort;
                    LNode targetExtPortDummy;
                    LPort sourcePort = outEdge.getSource();
                    LNode sourceExtPortDummy = this.dummyNodeMap.get(sourcePort);
                    if (sourceExtPortDummy == null) {
                        sourceExtPortDummy = LGraphUtil.createExternalPortDummy(sourcePort, PortConstraints.FREE, sourcePort.getSide(), -1, null, null, sourcePort.getSize(), nestedGraph.getProperty(LayeredOptions.DIRECTION), nestedGraph);
                        sourceExtPortDummy.setProperty(InternalProperties.ORIGIN, sourcePort);
                        this.dummyNodeMap.put(sourcePort, sourceExtPortDummy);
                        nestedGraph.getLayerlessNodes().add(sourceExtPortDummy);
                    }
                    if ((targetExtPortDummy = this.dummyNodeMap.get(targetPort = outEdge.getTarget())) == null) {
                        targetExtPortDummy = LGraphUtil.createExternalPortDummy(targetPort, PortConstraints.FREE, targetPort.getSide(), 1, null, null, targetPort.getSize(), nestedGraph.getProperty(LayeredOptions.DIRECTION), nestedGraph);
                        targetExtPortDummy.setProperty(InternalProperties.ORIGIN, targetPort);
                        this.dummyNodeMap.put(targetPort, targetExtPortDummy);
                        nestedGraph.getLayerlessNodes().add(targetExtPortDummy);
                    }
                    LEdge dummyEdge = this.createDummyEdge(nestedGraph, outEdge);
                    dummyEdge.setSource(sourceExtPortDummy.getPorts().get(0));
                    dummyEdge.setTarget(targetExtPortDummy.getPorts().get(0));
                    this.crossHierarchyMap.put((Object)outEdge, (Object)new CrossHierarchyEdge(dummyEdge, nestedGraph, PortType.OUTPUT));
                    nestedGraph.getProperty(InternalProperties.GRAPH_PROPERTIES).add(GraphProperties.EXTERNAL_PORTS);
                }
                ++n2;
            }
        }
    }

    private ExternalPort introduceHierarchicalEdgeSegment(LGraph graph, LNode parentNode, LEdge origEdge, LPort oppositePort, PortType portType, ExternalPort defaultExternalPort) {
        boolean mergeExternalPorts = graph.getProperty(LayeredOptions.MERGE_HIERARCHY_EDGES);
        LPort parentEndPort = null;
        if (portType == PortType.INPUT && origEdge.getSource().getNode() == parentNode) {
            parentEndPort = origEdge.getSource();
        } else if (portType == PortType.OUTPUT && origEdge.getTarget().getNode() == parentNode) {
            parentEndPort = origEdge.getTarget();
        }
        ExternalPort externalPort = defaultExternalPort;
        if (externalPort == null || !mergeExternalPorts || parentEndPort != null) {
            PortSide externalPortSide = PortSide.UNDEFINED;
            if (parentEndPort != null) {
                externalPortSide = parentEndPort.getSide();
            } else if (parentNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
                externalPortSide = portType == PortType.INPUT ? PortSide.WEST : PortSide.EAST;
            }
            LNode dummyNode = this.createExternalPortDummy(graph, parentNode, portType, externalPortSide, origEdge);
            LEdge dummyEdge = this.createDummyEdge(parentNode.getGraph(), origEdge);
            if (portType == PortType.INPUT) {
                dummyEdge.setSource(dummyNode.getPorts().get(0));
                dummyEdge.setTarget(oppositePort);
            } else {
                dummyEdge.setSource(oppositePort);
                dummyEdge.setTarget(dummyNode.getPorts().get(0));
            }
            externalPort = new ExternalPort(origEdge, dummyEdge, dummyNode, (LPort)dummyNode.getProperty(InternalProperties.ORIGIN), portType, parentEndPort == null);
        } else {
            externalPort.origEdges.add(origEdge);
            double thickness = Math.max(externalPort.newEdge.getProperty(LayeredOptions.EDGE_THICKNESS), origEdge.getProperty(LayeredOptions.EDGE_THICKNESS));
            externalPort.newEdge.setProperty(LayeredOptions.EDGE_THICKNESS, (Object)thickness);
        }
        this.crossHierarchyMap.put((Object)origEdge, (Object)new CrossHierarchyEdge(externalPort.newEdge, graph, portType));
        return externalPort;
    }

    private LEdge createDummyEdge(LGraph graph, LEdge origEdge) {
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(origEdge);
        dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        return dummyEdge;
    }

    private LNode createExternalPortDummy(LGraph graph, LNode parentNode, PortType portType, PortSide portSide, LEdge edge) {
        LNode dummyNode = null;
        LPort outsidePort = portType == PortType.INPUT ? edge.getSource() : edge.getTarget();
        Direction layoutDirection = LGraphUtil.getDirection(graph);
        if (outsidePort.getNode() == parentNode) {
            dummyNode = this.dummyNodeMap.get(outsidePort);
            if (dummyNode == null) {
                dummyNode = LGraphUtil.createExternalPortDummy(outsidePort, parentNode.getProperty(LayeredOptions.PORT_CONSTRAINTS), portSide, portType == PortType.INPUT ? -1 : 1, null, outsidePort.getPosition(), outsidePort.getSize(), layoutDirection, graph);
                dummyNode.setProperty(InternalProperties.ORIGIN, outsidePort);
                this.dummyNodeMap.put(outsidePort, dummyNode);
            }
        } else {
            double thickness = edge.getProperty(LayeredOptions.EDGE_THICKNESS);
            dummyNode = LGraphUtil.createExternalPortDummy(CompoundGraphPreprocessor.createExternalPortProperties(graph), parentNode.getProperty(LayeredOptions.PORT_CONSTRAINTS), portSide, portType == PortType.INPUT ? -1 : 1, null, new KVector(), new KVector(thickness, thickness), layoutDirection, graph);
            LPort dummyPort = this.createPortForDummy(dummyNode, parentNode, portType);
            dummyNode.setProperty(InternalProperties.ORIGIN, dummyPort);
            this.dummyNodeMap.put(dummyPort, dummyNode);
        }
        graph.getProperty(InternalProperties.GRAPH_PROPERTIES).add(GraphProperties.EXTERNAL_PORTS);
        if (graph.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
            graph.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
        } else {
            graph.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        }
        return dummyNode;
    }

    private static IPropertyHolder createExternalPortProperties(LGraph graph) {
        MapPropertyHolder propertyHolder = new MapPropertyHolder();
        double offset2 = graph.getProperty(LayeredOptions.SPACING_EDGE_EDGE) / 2.0;
        propertyHolder.setProperty(LayeredOptions.PORT_BORDER_OFFSET, offset2);
        return propertyHolder;
    }

    private LPort createPortForDummy(LNode dummyNode, LNode parentNode, PortType type) {
        LGraph graph = parentNode.getGraph();
        Direction layoutDirection = LGraphUtil.getDirection(graph);
        LPort port = new LPort();
        port.setNode(parentNode);
        switch (type) {
            case INPUT: {
                port.setSide(PortSide.fromDirection(layoutDirection).opposed());
                break;
            }
            case OUTPUT: {
                port.setSide(PortSide.fromDirection(layoutDirection));
            }
        }
        port.setProperty(LayeredOptions.PORT_BORDER_OFFSET, dummyNode.getProperty(LayeredOptions.PORT_BORDER_OFFSET));
        dummyNode.setProperty(InternalProperties.ORIGIN, port);
        this.dummyNodeMap.put(port, dummyNode);
        return port;
    }

    private static class ExternalPort {
        private List<LEdge> origEdges = Lists.newArrayList();
        private LEdge newEdge;
        private LNode dummyNode;
        private LPort dummyPort;
        private PortType type = PortType.UNDEFINED;
        private boolean exported;

        ExternalPort(LEdge origEdge, LEdge newEdge, LNode dummyNode, LPort dummyPort, PortType portType, boolean exported) {
            this.origEdges.add(origEdge);
            this.newEdge = newEdge;
            this.dummyNode = dummyNode;
            this.dummyPort = dummyPort;
            this.type = portType;
            this.exported = exported;
        }
    }
}

