/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph.transform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodeFlexibility;
import org.eclipse.elk.alg.layered.options.NodePlacementStrategy;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;

class ElkGraphLayoutTransferrer {
    private static final KVector ZERO_OFFSET = new KVector();

    ElkGraphLayoutTransferrer() {
    }

    public void applyLayout(LGraph lgraph) {
        Object graphOrigin = lgraph.getProperty(InternalProperties.ORIGIN);
        if (!(graphOrigin instanceof ElkNode)) {
            return;
        }
        ElkNode parentElkNode = (ElkNode)graphOrigin;
        LNode parentLNode = lgraph.getProperty(InternalProperties.PARENT_LNODE);
        KVector offset2 = new KVector(lgraph.getOffset());
        LPadding lPadding = lgraph.getPadding();
        offset2.x += lPadding.left;
        offset2.y += lPadding.top;
        EnumSet<SizeOptions> sizeOptions = parentElkNode.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        if (sizeOptions.contains((Object)SizeOptions.COMPUTE_PADDING)) {
            ElkPadding padding = parentElkNode.getProperty(LayeredOptions.PADDING);
            padding.setBottom(lPadding.bottom);
            padding.setTop(lPadding.top);
            padding.setLeft(lPadding.left);
            padding.setRight(lPadding.right);
        }
        ArrayList edgeList = Lists.newArrayList();
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            if (ElkGraphLayoutTransferrer.representsNode(lnode)) {
                this.applyNodeLayout(lnode, offset2);
            } else if (ElkGraphLayoutTransferrer.representsExternalPort(lnode) && parentLNode == null) {
                ElkPort elkport = (ElkPort)lnode.getProperty(InternalProperties.ORIGIN);
                KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, lnode, elkport.getWidth(), elkport.getHeight());
                elkport.setLocation(portPosition.x, portPosition.y);
            }
            for (LPort port : lnode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> !LGraphUtil.isDescendant(edge.getTarget().getNode(), lnode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        if (parentLNode != null) {
            for (LPort port : parentLNode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> LGraphUtil.isDescendant(edge.getTarget().getNode(), parentLNode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        EdgeRouting routing = parentElkNode.getProperty(LayeredOptions.EDGE_ROUTING);
        for (LEdge ledge : edgeList) {
            this.applyEdgeLayout(ledge, routing, offset2, lPadding);
        }
        this.applyParentNodeLayout(lgraph);
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            LGraph nestedGraph = lnode.getProperty(InternalProperties.NESTED_LGRAPH);
            if (nestedGraph == null) continue;
            this.applyLayout(nestedGraph);
        }
    }

    private void applyNodeLayout(LNode lnode, KVector offset2) {
        ElkNode elknode = (ElkNode)lnode.getProperty(InternalProperties.ORIGIN);
        elknode.setX(lnode.getPosition().x + offset2.x);
        elknode.setY(lnode.getPosition().y + offset2.y);
        if (!elknode.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS).isEmpty() || lnode.getProperty(InternalProperties.NESTED_LGRAPH) != null || lnode.getGraph().getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY) == NodePlacementStrategy.NETWORK_SIMPLEX && NodeFlexibility.getNodeFlexibility(lnode).isFlexibleSizeWhereSpacePermits()) {
            elknode.setWidth(lnode.getSize().x);
            elknode.setHeight(lnode.getSize().y);
        }
        for (LPort lport : lnode.getPorts()) {
            Object origin = lport.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof ElkPort)) continue;
            ElkPort elkport = (ElkPort)origin;
            elkport.setLocation(lport.getPosition().x, lport.getPosition().y);
            elkport.setProperty(LayeredOptions.PORT_SIDE, lport.getSide());
        }
        boolean nodeHasLabelPlacement = !lnode.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT).isEmpty();
        for (LLabel llabel : lnode.getLabels()) {
            if (!nodeHasLabelPlacement && llabel.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT).isEmpty()) continue;
            ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
            elklabel.setDimensions(llabel.getSize().x, llabel.getSize().y);
            elklabel.setLocation(llabel.getPosition().x, llabel.getPosition().y);
        }
        if (lnode.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT) != PortLabelPlacement.FIXED) {
            for (LPort lport : lnode.getPorts()) {
                for (LLabel llabel : lport.getLabels()) {
                    ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
                    elklabel.setWidth(llabel.getSize().x);
                    elklabel.setHeight(llabel.getSize().y);
                    elklabel.setLocation(llabel.getPosition().x, llabel.getPosition().y);
                }
            }
        }
    }

    private void applyEdgeLayout(LEdge ledge, EdgeRouting routing, KVector offset2, LPadding additionalPadding) {
        KVector sourcePoint;
        ElkEdge elkedge = (ElkEdge)ledge.getProperty(InternalProperties.ORIGIN);
        if (elkedge == null) {
            return;
        }
        if (ledge.isSelfLoop() && routing != EdgeRouting.ORTHOGONAL && routing != EdgeRouting.SPLINES) {
            return;
        }
        KVectorChain bendPoints = ledge.getBendPoints();
        KVector edgeOffset = new KVector(offset2);
        edgeOffset.add(this.calculateHierarchicalOffset(ledge));
        if (LGraphUtil.isDescendant(ledge.getTarget().getNode(), ledge.getSource().getNode())) {
            LPort sourcePort = ledge.getSource();
            sourcePoint = KVector.sum(sourcePort.getPosition(), sourcePort.getAnchor());
            sourcePoint.sub(offset2);
        } else {
            sourcePoint = ledge.getSource().getAbsoluteAnchor();
        }
        bendPoints.addFirst(sourcePoint);
        KVector targetPoint = ledge.getTarget().getAbsoluteAnchor();
        if (ledge.getProperty(InternalProperties.TARGET_OFFSET) != null) {
            targetPoint.add(ledge.getProperty(InternalProperties.TARGET_OFFSET));
        }
        bendPoints.addLast(targetPoint);
        bendPoints.offset(edgeOffset);
        ElkEdgeSection elkedgeSection = ElkGraphUtil.firstEdgeSection(elkedge, true, true);
        ElkUtil.applyVectorChain(bendPoints, elkedgeSection);
        for (LLabel llabel : ledge.getLabels()) {
            ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
            elklabel.setWidth(llabel.getSize().x);
            elklabel.setHeight(llabel.getSize().y);
            elklabel.setLocation(llabel.getPosition().x + edgeOffset.x, llabel.getPosition().y + edgeOffset.y);
        }
        KVectorChain junctionPoints = ledge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (junctionPoints != null) {
            junctionPoints.offset(edgeOffset);
            elkedge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
        } else {
            elkedge.setProperty(LayeredOptions.JUNCTION_POINTS, null);
        }
        if (routing == EdgeRouting.SPLINES) {
            elkedge.setProperty(LayeredOptions.EDGE_ROUTING, EdgeRouting.SPLINES);
        } else {
            elkedge.setProperty(LayeredOptions.EDGE_ROUTING, null);
        }
    }

    private KVector calculateHierarchicalOffset(LEdge ledge) {
        LGraph targetCoordinateSystem = ledge.getProperty(InternalProperties.COORDINATE_SYSTEM_ORIGIN);
        if (targetCoordinateSystem != null) {
            KVector result = new KVector();
            LGraph currentGraph = ledge.getSource().getNode().getGraph();
            while (currentGraph != targetCoordinateSystem) {
                LNode representingNode = currentGraph.getProperty(InternalProperties.PARENT_LNODE);
                currentGraph = representingNode.getGraph();
                result.add(representingNode.getPosition()).add(currentGraph.getOffset()).add(currentGraph.getPadding().left, currentGraph.getPadding().top);
            }
            return result;
        }
        return ZERO_OFFSET;
    }

    private void applyParentNodeLayout(LGraph lgraph) {
        ElkNode elknode = (ElkNode)lgraph.getProperty(InternalProperties.ORIGIN);
        boolean sizeConstraintsIncludedPortLabels = elknode.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS).contains((Object)SizeConstraint.PORT_LABELS);
        if (lgraph.getProperty(InternalProperties.PARENT_LNODE) == null) {
            Set<GraphProperties> graphProps = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
            KVector actualGraphSize = lgraph.getActualSize();
            if (graphProps.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
                elknode.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
                ElkUtil.resizeNode(elknode, actualGraphSize.x, actualGraphSize.y, false, true);
            } else {
                ElkUtil.resizeNode(elknode, actualGraphSize.x, actualGraphSize.y, true, true);
            }
        }
        if (sizeConstraintsIncludedPortLabels) {
            elknode.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, EnumSet.of(SizeConstraint.PORT_LABELS));
        } else {
            elknode.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, SizeConstraint.fixed());
        }
    }

    private static boolean representsNode(LNode lnode) {
        return lnode.getProperty(InternalProperties.ORIGIN) instanceof ElkNode;
    }

    private static boolean representsExternalPort(LNode lnode) {
        return lnode.getProperty(InternalProperties.ORIGIN) instanceof ElkPort;
    }
}

