/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.nodespacing.cellsystem.LabelCell;

public final class EndLabelPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("End label post-processing", 1.0f);
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(node -> node.getType() == LNode.NodeType.NORMAL && node.hasProperty(InternalProperties.END_LABELS)).forEach(node -> this.processNode((LNode)node));
        monitor.done();
    }

    private void processNode(LNode node) {
        assert (node.hasProperty(InternalProperties.END_LABELS));
        List<LabelCell> endLabelCells = node.getProperty(InternalProperties.END_LABELS);
        assert (!endLabelCells.isEmpty());
        KVector nodePos = node.getPosition();
        for (LabelCell labelCell : endLabelCells) {
            ElkRectangle labelCellRect = labelCell.getCellRectangle();
            labelCellRect.move(nodePos);
            labelCell.applyLabelLayout();
        }
        node.setProperty(InternalProperties.END_LABELS, (Object)null);
    }
}

