/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.splines.NubSpline;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineSegment;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class FinalSplineBendpointsCalculator
implements ILayoutProcessor<LGraph> {
    private double hEdgeSpacing;
    private boolean sloppyRoutingRequested;
    private GraphCompactionStrategy compactionStrategy;

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        this.hEdgeSpacing = graph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        this.sloppyRoutingRequested = graph.getProperty(LayeredOptions.EDGE_ROUTING_SLOPPY_SPLINE_ROUTING);
        this.compactionStrategy = graph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY);
        List startEdges = graph.getLayers().stream().flatMap(l -> l.getNodes().stream()).flatMap(n -> StreamSupport.stream(n.getOutgoingEdges().spliterator(), false)).filter(e -> !e.isSelfLoop()).filter(e -> e.hasProperty(InternalProperties.SPLINE_ROUTE_START)).collect(Collectors.toList());
        for (LEdge e2 : startEdges) {
            List<SplineSegment> spline = e2.getProperty(InternalProperties.SPLINE_ROUTE_START);
            for (SplineSegment segment : spline) {
                if (segment.isStraight) {
                    this.calculateNUBSBendPointStraight(segment);
                    continue;
                }
                this.calculateNUBSBendPoints(segment);
            }
            e2.setProperty(InternalProperties.SPLINE_ROUTE_START, (Object)null);
        }
        for (LEdge e2 : startEdges) {
            List<LEdge> edgeChain = e2.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
            this.calculateBezierBendPoints(edgeChain);
            e2.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, (Object)null);
        }
    }

    private void calculateNUBSBendPointStraight(SplineSegment segment) {
        Set<LEdge> edges = segment.edges;
        if (edges.size() > 1) {
            throw new IllegalArgumentException("In straight spline segments there may be only one edge.");
        }
        double xStartPos = segment.boundingBox.x;
        double xEndPos = segment.boundingBox.x + segment.boundingBox.width;
        edges.iterator().next().getBendPoints().add(new KVector(xStartPos + (xEndPos - xStartPos) / 2.0, segment.centerControlPointY));
    }

    private void calculateNUBSBendPoints(SplineSegment segment) {
        double startXPos = segment.boundingBox.x;
        double endXPos = segment.boundingBox.x + segment.boundingBox.width;
        boolean sloppyRouting = this.sloppyRoutingRequested && this.segmentAllowsSloppyRouting(segment);
        double centerXPos = sloppyRouting ? (startXPos + endXPos) / 2.0 : startXPos + (double)(segment.rank + 1) * this.hEdgeSpacing;
        for (LEdge edge : segment.edges) {
            SplineSegment.EdgeInformation ei = segment.edgeInformation.get(edge);
            double ySourceAnchor = ei.startY;
            double yTargetAnchor = ei.endY;
            KVector sourceVerticalCP = new KVector(centerXPos, ySourceAnchor);
            KVector targetVerticalCP = new KVector(centerXPos, yTargetAnchor);
            KVector sourceStraightCP = new KVector(startXPos - 10.0, ySourceAnchor);
            KVector targetStraightCP = new KVector(endXPos, yTargetAnchor);
            boolean invertedSource = false;
            boolean invertedTarget = false;
            if (ei.invertedLeft) {
                invertedSource = true;
                sourceStraightCP.x = endXPos;
            }
            if (ei.invertedRight) {
                invertedTarget = true;
                targetStraightCP.x = startXPos - 10.0;
            }
            boolean normalSource = ei.normalSourceNode;
            boolean normalTarget = ei.normalTargetNode;
            if (!sloppyRouting || !normalSource && !normalTarget || invertedTarget || invertedSource) {
                if (segment.edges.size() == 1) {
                    edge.getBendPoints().addAll(sourceStraightCP, sourceVerticalCP, targetVerticalCP, targetStraightCP);
                    continue;
                }
                KVector center = new KVector(centerXPos, segment.centerControlPointY);
                edge.getBendPoints().addAll(sourceStraightCP, sourceVerticalCP, center, targetVerticalCP, targetStraightCP);
                continue;
            }
            if (normalSource && normalTarget) {
                int indegree = 0;
                int outdegree = 0;
                for (LPort port : edge.getTarget().getNode().getPorts()) {
                    indegree += port.getIncomingEdges().size();
                }
                for (LPort port : edge.getSource().getNode().getPorts()) {
                    outdegree += port.getOutgoingEdges().size();
                }
                int degreeDiff = (int)Math.signum(outdegree - indegree);
                double centerYPos = (yTargetAnchor + ySourceAnchor) / 2.0 + (yTargetAnchor - ySourceAnchor) * (0.4 * (double)degreeDiff);
                edge.getBendPoints().addAll(new KVector(centerXPos, centerYPos));
                continue;
            }
            if (normalSource) {
                edge.getBendPoints().addAll(targetVerticalCP, targetStraightCP);
                continue;
            }
            if (!normalTarget) continue;
            edge.getBendPoints().addAll(sourceStraightCP, sourceVerticalCP);
        }
    }

    private void calculateBezierBendPoints(List<LEdge> edgeChain) {
        KVector offsetOfStraightening;
        if (edgeChain.isEmpty()) {
            return;
        }
        boolean sloppyRouting = this.sloppyRoutingRequested;
        KVectorChain allCP = new KVectorChain();
        KVector northSouthBendPoint = null;
        LEdge edge = edgeChain.get(0);
        LPort sourcePort = edge.getSource();
        LNode.NodeType sourceNodeType = sourcePort.getNode().getType();
        if (!SplineEdgeRouter.isQualifiedAsStartingNode(sourcePort.getNode())) {
            throw new IllegalArgumentException("The target node of the edge must be a normal node or a northSouthPort.");
        }
        if (sourceNodeType == LNode.NodeType.NORTH_SOUTH_PORT) {
            LPort originPort = (LPort)sourcePort.getProperty(InternalProperties.ORIGIN);
            northSouthBendPoint = new KVector(originPort.getAbsoluteAnchor().x, sourcePort.getAbsoluteAnchor().y);
            sourcePort = originPort;
        }
        allCP.addLast(sourcePort.getAbsoluteAnchor());
        if (!sloppyRouting) {
            double gap = Math.max(5.0, SplinesMath.getMarginOnPortSide(sourcePort.getNode(), sourcePort.getSide()));
            offsetOfStraightening = new KVector(SplinesMath.portSideToDirection(sourcePort.getSide()));
            offsetOfStraightening.scale(gap);
            allCP.add(offsetOfStraightening.add(sourcePort.getAbsoluteAnchor()));
        }
        if (northSouthBendPoint != null) {
            allCP.addLast(northSouthBendPoint);
            northSouthBendPoint = null;
        }
        KVector lastCP = null;
        boolean addMidPoint = false;
        for (LEdge currentEdge : edgeChain) {
            KVectorChain currentBendPoints = currentEdge.getBendPoints();
            if (currentBendPoints.isEmpty()) continue;
            if (addMidPoint) {
                allCP.add(lastCP.add((KVector)currentBendPoints.getFirst()).scale(0.5));
                addMidPoint = false;
            } else {
                addMidPoint = true;
            }
            lastCP = ((KVector)currentBendPoints.getLast()).clone();
            allCP.addAll(currentBendPoints);
            currentBendPoints.clear();
        }
        LPort targetPort = edge.getTarget();
        if (targetPort.getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
            LPort originPort = (LPort)targetPort.getProperty(InternalProperties.ORIGIN);
            allCP.add(new KVector(originPort.getAbsoluteAnchor().x, targetPort.getAbsoluteAnchor().y));
            targetPort = originPort;
        }
        if (!sloppyRouting) {
            double gap = Math.max(5.0, SplinesMath.getMarginOnPortSide(targetPort.getNode(), targetPort.getSide()));
            offsetOfStraightening = new KVector(SplinesMath.portSideToDirection(targetPort.getSide()));
            offsetOfStraightening.scale(gap);
            allCP.add(offsetOfStraightening.add(targetPort.getAbsoluteAnchor()));
        }
        allCP.addLast(targetPort.getAbsoluteAnchor());
        NubSpline nubSpline = new NubSpline(true, 3, allCP);
        edge.getBendPoints().addAll(nubSpline.getBezierCP());
    }

    private boolean segmentAllowsSloppyRouting(SplineSegment segment) {
        double t;
        LNode n;
        double nodeSegmentDistance;
        if (this.compactionStrategy == GraphCompactionStrategy.NONE) {
            return true;
        }
        double startXPos = segment.boundingBox.x;
        double endXPos = segment.boundingBox.x + segment.boundingBox.width;
        if (segment.initialSegment && (nodeSegmentDistance = startXPos - (n.getPosition().x + n.getSize().x)) > (t = this.segmentNodeDistanceThreshold(n = segment.sourceNode))) {
            return false;
        }
        return !segment.lastSegment || !((nodeSegmentDistance = n.getPosition().x - endXPos) > (t = this.segmentNodeDistanceThreshold(n = segment.targetNode)));
    }

    private double segmentNodeDistanceThreshold(LNode n) {
        return n.getLayer().getSize().x - n.getSize().x / 2.0;
    }
}

