/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Alignment;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class HierarchicalPortDummySizeProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hierarchical port dummy size processing", 1.0f);
        ArrayList northernDummies = Lists.newArrayList();
        ArrayList southernDummies = Lists.newArrayList();
        double edgeSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        double delta = edgeSpacing * 2.0;
        for (Layer layer : layeredGraph) {
            northernDummies.clear();
            southernDummies.clear();
            for (LNode node : layer) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide side = node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (side == PortSide.NORTH) {
                    northernDummies.add(node);
                    continue;
                }
                if (side != PortSide.SOUTH) continue;
                southernDummies.add(node);
            }
            this.setWidths(northernDummies, true, delta);
            this.setWidths(southernDummies, false, delta);
        }
        monitor.done();
    }

    private void setWidths(List<LNode> nodes, boolean topDown, double delta) {
        double currentWidth = 0.0;
        double step = delta;
        if (!topDown) {
            currentWidth = delta * (double)(nodes.size() - 1);
            step *= -1.0;
        }
        for (LNode node : nodes) {
            node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.CENTER);
            node.getSize().x = currentWidth;
            for (LPort port : node.getPorts(PortSide.EAST)) {
                port.getPosition().x = currentWidth;
            }
            currentWidth += step;
        }
    }
}

