/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class HyperedgeDummyMerger
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hyperedge merging", 1.0f);
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            List<LNode> nodes = layer.getNodes();
            if (nodes.isEmpty()) continue;
            LNode currNode = null;
            LNode.NodeType currNodeType = null;
            LNode lastNode = null;
            LNode.NodeType lastNodeType = null;
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                currNode = nodes.get(nodeIndex);
                currNodeType = currNode.getType();
                if (currNodeType == LNode.NodeType.LONG_EDGE && lastNodeType == LNode.NodeType.LONG_EDGE) {
                    boolean eligibleForTargetMerging;
                    LPort currNodeSource = currNode.getProperty(InternalProperties.LONG_EDGE_SOURCE);
                    LPort lastNodeSource = lastNode.getProperty(InternalProperties.LONG_EDGE_SOURCE);
                    LPort currNodeTarget = currNode.getProperty(InternalProperties.LONG_EDGE_TARGET);
                    LPort lastNodeTarget = lastNode.getProperty(InternalProperties.LONG_EDGE_TARGET);
                    boolean sameSource = currNodeSource != null && currNodeSource == lastNodeSource;
                    boolean sameTarget = currNodeTarget != null && currNodeTarget == lastNodeTarget;
                    boolean eligibleForSourceMerging = !(currNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && currNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) == false || lastNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && lastNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) == false);
                    boolean bl = eligibleForTargetMerging = !(currNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && currNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) != false || lastNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && lastNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) != false);
                    if (sameSource && eligibleForSourceMerging || sameTarget && eligibleForTargetMerging) {
                        this.mergeNodes(currNode, lastNode, sameSource, sameTarget);
                        nodes.remove(nodeIndex);
                        --nodeIndex;
                        currNode = lastNode;
                        currNodeType = lastNodeType;
                    }
                }
                lastNode = currNode;
                lastNodeType = currNodeType;
                ++nodeIndex;
            }
        }
        monitor.done();
    }

    private void mergeNodes(LNode mergeSource, LNode mergeTarget, boolean keepSourcePort, boolean keepTargetPort) {
        LPort mergeTargetInputPort = mergeTarget.getPorts(PortSide.WEST).iterator().next();
        LPort mergeTargetOutputPort = mergeTarget.getPorts(PortSide.EAST).iterator().next();
        for (LPort port : mergeSource.getPorts()) {
            while (!port.getIncomingEdges().isEmpty()) {
                port.getIncomingEdges().get(0).setTarget(mergeTargetInputPort);
            }
            while (!port.getOutgoingEdges().isEmpty()) {
                port.getOutgoingEdges().get(0).setSource(mergeTargetOutputPort);
            }
        }
        if (!keepSourcePort) {
            mergeTarget.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)null);
        }
        if (!keepTargetPort) {
            mergeTarget.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)null);
        }
    }
}

