/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.CenterEdgeLabelPlacementStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Alignment;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelDummySwitcher
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label dummy switching", 1.0f);
        CenterEdgeLabelPlacementStrategy strategy = layeredGraph.getProperty(LayeredOptions.EDGE_LABELS_CENTER_LABEL_PLACEMENT_STRATEGY);
        List<LNode> labelDummies = this.gatherLabelDummies(layeredGraph);
        double[] layerWidths = strategy.usesLabelSizeInformation() ? this.calculateLayerWidthsAndAssignIDsToLayers(layeredGraph) : null;
        for (LNode labelDummy : labelDummies) {
            CenterEdgeLabelPlacementStrategy actualStrategy = this.getPlacementStrategyOverride(labelDummy);
            if (actualStrategy == null) {
                actualStrategy = strategy;
            }
            List<LNode> leftLongEdgeDummies = this.gatherLeftLongEdgeDummies(labelDummy);
            List<LNode> rightLongEdgeDummies = this.gatherRightLongEdgeDummies(labelDummy);
            LNode swapCandidate = null;
            switch (actualStrategy) {
                case CENTER_LAYER: {
                    swapCandidate = this.findCenterLayerSwapCandidate(labelDummy, layerWidths, leftLongEdgeDummies, rightLongEdgeDummies);
                    break;
                }
                case MEDIAN_LAYER: {
                    swapCandidate = this.findMedianLayerSwapCandidate(labelDummy, leftLongEdgeDummies, rightLongEdgeDummies);
                    break;
                }
                case WIDEST_LAYER: {
                    swapCandidate = this.findWidestLayerSwapCandidate(labelDummy, layerWidths, leftLongEdgeDummies, rightLongEdgeDummies);
                    break;
                }
                case HEAD_LAYER: {
                    this.setEndLayerNodeAlignment(labelDummy, actualStrategy);
                    swapCandidate = this.findEndLayerSwapCandidate(labelDummy, true, leftLongEdgeDummies, rightLongEdgeDummies);
                    break;
                }
                case TAIL_LAYER: {
                    this.setEndLayerNodeAlignment(labelDummy, actualStrategy);
                    swapCandidate = this.findEndLayerSwapCandidate(labelDummy, false, leftLongEdgeDummies, rightLongEdgeDummies);
                }
            }
            if (swapCandidate != null) {
                this.swapNodes(labelDummy, swapCandidate);
            }
            this.updateLongEdgeSourceLabelDummyInfo(labelDummy);
        }
        monitor.done();
    }

    private CenterEdgeLabelPlacementStrategy getPlacementStrategyOverride(LNode labelDummy) {
        for (LLabel label : labelDummy.getProperty(InternalProperties.REPRESENTED_LABELS)) {
            if (!label.hasProperty(LayeredOptions.EDGE_LABELS_CENTER_LABEL_PLACEMENT_STRATEGY)) continue;
            return label.getProperty(LayeredOptions.EDGE_LABELS_CENTER_LABEL_PLACEMENT_STRATEGY);
        }
        return null;
    }

    private double[] calculateLayerWidthsAndAssignIDsToLayers(LGraph layeredGraph) {
        List<Layer> layers = layeredGraph.getLayers();
        double[] layerWidths = new double[layers.size()];
        int layerIndex = 0;
        for (Layer layer : layers) {
            layerWidths[layerIndex] = LGraphUtil.findMaxNonDummyNodeWidth(layer, false);
            layer.id = layerIndex++;
        }
        return layerWidths;
    }

    private LNode findCenterLayerSwapCandidate(LNode labelDummy, double[] layerWidths, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies) {
        double[] layerWidthSums = this.computeLayerWidthSums(labelDummy, layerWidths, leftLongEdgeDummies, rightLongEdgeDummies);
        double threshold = layerWidthSums[layerWidthSums.length - 1] / 2.0;
        int i = 0;
        while (i < layerWidthSums.length) {
            if (layerWidthSums[i] >= threshold) {
                return this.findIthLongEdgeDummy(i, leftLongEdgeDummies, rightLongEdgeDummies);
            }
            ++i;
        }
        assert (false);
        return null;
    }

    private double[] computeLayerWidthSums(LNode labelDummy, double[] layerWidths, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies) {
        double edgeNodeSpacing = labelDummy.getGraph().getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS) * 2.0;
        double nodeNodeSpacing = labelDummy.getGraph().getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double minSpaceBetweenLayers = Math.max(edgeNodeSpacing, nodeNodeSpacing);
        double[] layerWidthSums = new double[leftLongEdgeDummies.size() + rightLongEdgeDummies.size() + 1];
        double currentWidthSum = -minSpaceBetweenLayers;
        int currentIndex = 0;
        for (LNode leftDummy : leftLongEdgeDummies) {
            layerWidthSums[currentIndex++] = currentWidthSum += layerWidths[leftDummy.getLayer().id] + minSpaceBetweenLayers;
        }
        layerWidthSums[currentIndex++] = currentWidthSum += layerWidths[labelDummy.getLayer().id] + minSpaceBetweenLayers;
        for (LNode rightDummy : rightLongEdgeDummies) {
            layerWidthSums[currentIndex++] = currentWidthSum += layerWidths[rightDummy.getLayer().id] + minSpaceBetweenLayers;
        }
        return layerWidthSums;
    }

    private LNode findMedianLayerSwapCandidate(LNode labelDummy, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies) {
        int layers = leftLongEdgeDummies.size() + rightLongEdgeDummies.size() + 1;
        int lowerMedian = (layers - 1) / 2;
        return this.findIthLongEdgeDummy(lowerMedian, leftLongEdgeDummies, rightLongEdgeDummies);
    }

    private LNode findWidestLayerSwapCandidate(LNode labelDummy, double[] layerWidths, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies) {
        double labelDummyLayerWidth;
        double widestLayerWidth;
        Optional widestLayerDummy = Stream.concat(leftLongEdgeDummies.stream(), rightLongEdgeDummies.stream()).max((node1, node2) -> Double.compare(layerWidths[node1.getLayer().id], layerWidths[node2.getLayer().id]));
        if (widestLayerDummy.isPresent() && (widestLayerWidth = layerWidths[((LNode)widestLayerDummy.get()).getLayer().id]) > (labelDummyLayerWidth = layerWidths[labelDummy.getLayer().id])) {
            return (LNode)widestLayerDummy.get();
        }
        return null;
    }

    private LNode findEndLayerSwapCandidate(LNode labelDummy, boolean headLayer, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies) {
        boolean reversed = this.isPartOfReversedEdge(labelDummy);
        if (headLayer && !reversed || !headLayer && reversed) {
            if (rightLongEdgeDummies.isEmpty()) {
                return null;
            }
            return rightLongEdgeDummies.get(rightLongEdgeDummies.size() - 1);
        }
        if (leftLongEdgeDummies.isEmpty()) {
            return null;
        }
        return leftLongEdgeDummies.get(0);
    }

    private void setEndLayerNodeAlignment(LNode labelDummy, CenterEdgeLabelPlacementStrategy actualStrategy) {
        assert (actualStrategy == CenterEdgeLabelPlacementStrategy.HEAD_LAYER || actualStrategy == CenterEdgeLabelPlacementStrategy.TAIL_LAYER);
        boolean isHeadLabel = actualStrategy == CenterEdgeLabelPlacementStrategy.HEAD_LAYER;
        boolean isPartOfReversedEdge = this.isPartOfReversedEdge(labelDummy);
        if (isHeadLabel && !isPartOfReversedEdge || !isHeadLabel && isPartOfReversedEdge) {
            labelDummy.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.RIGHT);
        } else {
            labelDummy.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.LEFT);
        }
    }

    private boolean isPartOfReversedEdge(LNode labelDummy) {
        assert (labelDummy.getType() == LNode.NodeType.LABEL);
        assert (labelDummy.getIncomingEdges().iterator().hasNext());
        assert (labelDummy.getOutgoingEdges().iterator().hasNext());
        LEdge incoming = labelDummy.getIncomingEdges().iterator().next();
        LEdge outgoing = labelDummy.getOutgoingEdges().iterator().next();
        return incoming.getProperty(InternalProperties.REVERSED) != false || outgoing.getProperty(InternalProperties.REVERSED) != false;
    }

    private List<LNode> gatherLabelDummies(LGraph layeredGraph) {
        return layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(node -> node.getType() == LNode.NodeType.LABEL).collect(Collectors.toList());
    }

    private List<LNode> gatherLeftLongEdgeDummies(LNode labelDummy) {
        ArrayList leftLongEdgeDummies = Lists.newArrayList();
        LNode source = labelDummy;
        do {
            if ((source = source.getIncomingEdges().iterator().next().getSource().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
            leftLongEdgeDummies.add(source);
        } while (source.getType() == LNode.NodeType.LONG_EDGE);
        return Lists.reverse((List)leftLongEdgeDummies);
    }

    private List<LNode> gatherRightLongEdgeDummies(LNode labelDummy) {
        ArrayList rightLongEdgeDummies = Lists.newArrayList();
        LNode target = labelDummy;
        do {
            if ((target = target.getOutgoingEdges().iterator().next().getTarget().getNode()).getType() != LNode.NodeType.LONG_EDGE) continue;
            rightLongEdgeDummies.add(target);
        } while (target.getType() == LNode.NodeType.LONG_EDGE);
        return rightLongEdgeDummies;
    }

    private LNode findIthLongEdgeDummy(int i, List<LNode> leftLongEdgeDummies, List<LNode> rightLongEdgeDummies) {
        if (i < leftLongEdgeDummies.size()) {
            return leftLongEdgeDummies.get(i);
        }
        if (i > leftLongEdgeDummies.size()) {
            return rightLongEdgeDummies.get(i - leftLongEdgeDummies.size() - 1);
        }
        return null;
    }

    private void swapNodes(LNode dummy1, LNode dummy2) {
        LEdge edge;
        Layer layer1 = dummy1.getLayer();
        Layer layer2 = dummy2.getLayer();
        int dummy1LayerPosition = layer1.getNodes().indexOf(dummy1);
        int dummy2LayerPosition = layer2.getNodes().indexOf(dummy2);
        LPort inputPort1 = dummy1.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort1 = dummy1.getPorts(PortType.OUTPUT).iterator().next();
        LPort inputPort2 = dummy2.getPorts(PortType.INPUT).iterator().next();
        LPort outputPort2 = dummy2.getPorts(PortType.OUTPUT).iterator().next();
        LEdge[] incomingEdges1 = inputPort1.getIncomingEdges().toArray(new LEdge[1]);
        LEdge[] outgoingEdges1 = outputPort1.getOutgoingEdges().toArray(new LEdge[1]);
        LEdge[] incomingEdges2 = inputPort2.getIncomingEdges().toArray(new LEdge[1]);
        LEdge[] outgoingEdges2 = outputPort2.getOutgoingEdges().toArray(new LEdge[1]);
        dummy1.setLayer(dummy2LayerPosition, layer2);
        LEdge[] lEdgeArray = incomingEdges2;
        int n = incomingEdges2.length;
        int n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort1);
            ++n2;
        }
        lEdgeArray = outgoingEdges2;
        n = outgoingEdges2.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort1);
            ++n2;
        }
        dummy2.setLayer(dummy1LayerPosition, layer1);
        lEdgeArray = incomingEdges1;
        n = incomingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setTarget(inputPort2);
            ++n2;
        }
        lEdgeArray = outgoingEdges1;
        n = outgoingEdges1.length;
        n2 = 0;
        while (n2 < n) {
            edge = lEdgeArray[n2];
            edge.setSource(outputPort2);
            ++n2;
        }
    }

    private void updateLongEdgeSourceLabelDummyInfo(LNode labelDummy) {
        this.doUpdateLongEdgeLabelDummyInfo(labelDummy, node -> node.getIncomingEdges().iterator().next().getSource().getNode(), true);
    }

    private void doUpdateLongEdgeLabelDummyInfo(LNode labelDummy, Function<LNode, LNode> nextElement, boolean value2) {
        LNode longEdgeDummy = nextElement.apply(labelDummy);
        while (longEdgeDummy.getType() == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY, (Object)value2);
            longEdgeDummy = nextElement.apply(longEdgeDummy);
        }
    }
}

