/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.elk.alg.common.compaction.oned.CGroup;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.alg.common.compaction.oned.ScanlineConstraintCalculator;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.compaction.HorizontalGraphCompactor;
import org.eclipse.elk.alg.layered.intermediate.compaction.VerticalSegment;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.options.EdgeRouting;

public class EdgeAwareScanlineConstraintCalculation
extends ScanlineConstraintCalculator {
    private static final double EPSILON = 0.5;
    private static final double SMALL_EPSILON = 0.01;
    private double verticalEdgeEdgeSpacing;
    private EdgeRouting edgeRouting;

    public EdgeAwareScanlineConstraintCalculation(LGraph graph) {
        this.verticalEdgeEdgeSpacing = graph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        this.edgeRouting = graph.getProperty(LayeredOptions.EDGE_ROUTING);
    }

    public void calculateConstraints(OneDimensionalCompactor theCompactor) {
        this.compactor = theCompactor;
        switch (this.edgeRouting) {
            case ORTHOGONAL: {
                this.calculateForOrthogonal();
                break;
            }
            case SPLINES: {
                this.calculateForSpline();
                break;
            }
            default: {
                throw new UnsupportedConfigurationException();
            }
        }
    }

    private void calculateForSpline() {
        ArrayList schedule = Lists.newArrayList();
        this.sweep(n -> n.origin instanceof VerticalSegment);
        double minSpacing = this.compactor.cGraph.cNodes.stream().mapToDouble(n -> {
            if (n.origin instanceof LNode && ((LNode)n.origin).getType() == LNode.NodeType.EXTERNAL_PORT) {
                return Double.POSITIVE_INFINITY;
            }
            VerticalSegment vs = HorizontalGraphCompactor.getVerticalSegmentOrNull(n);
            if (vs != null) {
                return Math.max(0.0, this.verticalEdgeEdgeSpacing / 2.0 - 0.5);
            }
            LNode lNode = HorizontalGraphCompactor.getLNodeOrNull(n);
            if (lNode != null) {
                double spacing = Spacings.getIndividualOrDefault(lNode, LayeredOptions.SPACING_NODE_NODE);
                return Math.max(0.0, spacing / 2.0 - 0.5);
            }
            return Double.POSITIVE_INFINITY;
        }).min().orElseGet(() -> 0.0);
        this.compactor.cGraph.cNodes.stream().filter(n -> n.origin instanceof LNode).forEach(n -> {
            this.alterHitbox((CNode)n, minSpacing, 1.0);
            schedule.add(() -> this.alterHitbox((CNode)n, minSpacing, -1.0));
        });
        this.sweep(n -> true);
        schedule.forEach(r -> r.run());
        schedule.clear();
    }

    private void calculateForOrthogonal() {
        ArrayList schedule = Lists.newArrayList();
        this.compactor.cGraph.cNodes.stream().filter(n -> n.origin instanceof VerticalSegment).forEach(n -> {
            double spacing = Math.max(0.0, this.verticalEdgeEdgeSpacing / 2.0 - 0.5);
            this.alterHitbox((CNode)n, spacing, 1.0);
            schedule.add(() -> this.alterHitbox((CNode)n, spacing, -1.0));
        });
        this.sweep(n -> n.origin instanceof VerticalSegment);
        schedule.forEach(r -> r.run());
        schedule.clear();
        this.compactor.cGraph.cNodes.stream().filter(n -> n.origin instanceof LNode).forEach(n -> {
            LNode lNode = HorizontalGraphCompactor.getLNodeOrNull(n);
            double spacing = Spacings.getIndividualOrDefault(lNode, LayeredOptions.SPACING_EDGE_EDGE);
            double finalSpacing = Math.max(0.0, spacing / 2.0 - 0.5);
            this.alterHitbox((CNode)n, finalSpacing, 1.0);
            schedule.add(() -> this.alterHitbox((CNode)n, finalSpacing, -1.0));
        });
        this.sweep(n -> n.origin instanceof LNode);
        schedule.forEach(r -> r.run());
        schedule.clear();
        double minSpacing = this.compactor.cGraph.cNodes.stream().mapToDouble(n -> {
            if (n.origin instanceof LNode && ((LNode)n.origin).getType() == LNode.NodeType.EXTERNAL_PORT) {
                return Double.POSITIVE_INFINITY;
            }
            VerticalSegment vs = HorizontalGraphCompactor.getVerticalSegmentOrNull(n);
            if (vs != null) {
                return Math.max(0.0, this.verticalEdgeEdgeSpacing / 2.0 - 0.5);
            }
            LNode lNode = HorizontalGraphCompactor.getLNodeOrNull(n);
            if (lNode != null) {
                double spacing = Spacings.getIndividualOrDefault(lNode, LayeredOptions.SPACING_NODE_NODE);
                return Math.max(0.0, spacing / 2.0 - 0.5);
            }
            return Double.POSITIVE_INFINITY;
        }).min().orElseGet(() -> 0.0);
        this.compactor.cGraph.cGroups.stream().forEach(g -> {
            this.alterGroupedHitboxOrthogonal((CGroup)g, minSpacing, 1.0);
            schedule.add(() -> this.alterGroupedHitboxOrthogonal((CGroup)g, minSpacing, -1.0));
        });
        this.sweep(n -> true);
        schedule.forEach(r -> r.run());
        schedule.clear();
    }

    private void alterGroupedHitboxOrthogonal(CGroup g, double spacing, double fac) {
        CNode master = g.master;
        if (master == null) {
            master = (CNode)g.cNodes.iterator().next();
        }
        this.alterHitbox(master, spacing, fac);
        if (g.cNodes.size() == 1) {
            return;
        }
        double delta = spacing * fac;
        for (CNode n : g.cNodes) {
            if (n == master) continue;
            VerticalSegment vs = HorizontalGraphCompactor.getVerticalSegmentOrNull(n);
            if (vs.ignoreSpacing.up) {
                n.hitbox.y += delta + 0.01;
                n.hitbox.height -= delta + 0.01;
                continue;
            }
            if (!vs.ignoreSpacing.down) continue;
            n.hitbox.height -= delta + 0.01;
        }
    }

    private void alterHitbox(CNode n, double spacing, double fac) {
        double delta = spacing * fac;
        if (n.origin instanceof VerticalSegment) {
            VerticalSegment vs = HorizontalGraphCompactor.getVerticalSegmentOrNull(n);
            if (!vs.ignoreSpacing.up) {
                n.hitbox.y -= delta + 0.01;
                n.hitbox.height += delta + 0.01;
            } else if (!vs.ignoreSpacing.down) {
                n.hitbox.height += delta + 0.01;
            }
        } else if (n.origin instanceof LNode) {
            n.hitbox.y -= delta;
            n.hitbox.height += 2.0 * delta;
        }
    }
}

