/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ARDCutIndexHeuristic;
import org.eclipse.elk.alg.layered.intermediate.wrapping.CuttingUtils;
import org.eclipse.elk.alg.layered.intermediate.wrapping.GraphStats;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ICutIndexCalculator;
import org.eclipse.elk.alg.layered.intermediate.wrapping.MSDCutIndexHeuristic;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SingleEdgeGraphWrapper
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        ICutIndexCalculator icic;
        progressMonitor.begin("Path-Like Graph Wrapping", 1.0f);
        if (graph.getLayers().isEmpty()) {
            progressMonitor.done();
            return;
        }
        GraphStats gs = new GraphStats(graph);
        double sumWidth = gs.getMaxWidth() * (double)gs.longestPath;
        double currentAR = sumWidth / gs.getMaxWidth();
        if (gs.dar > currentAR) {
            progressMonitor.done();
            return;
        }
        switch (graph.getProperty(LayeredOptions.WRAPPING_CUTTING_STRATEGY)) {
            case MANUAL: {
                icic = new ICutIndexCalculator.ManualCutIndexCalculator();
                break;
            }
            case ARD: {
                icic = new ARDCutIndexHeuristic();
                break;
            }
            default: {
                icic = new MSDCutIndexHeuristic();
            }
        }
        List<Integer> cuts = icic.getCutIndexes(graph, gs);
        if (!icic.guaranteeValid()) {
            switch (graph.getProperty(LayeredOptions.WRAPPING_SINGLE_EDGE_VALIDIFY_STRATEGY)) {
                case LOOK_BACK: {
                    cuts = this.validifyIndexesLookingBack(gs, cuts);
                    break;
                }
                case GREEDY: {
                    cuts = this.validifyIndexesGreedily(gs, cuts);
                }
            }
        }
        this.performCuts(graph, gs, cuts);
        progressMonitor.done();
    }

    private List<Integer> validifyIndexesGreedily(GraphStats gs, List<Integer> cuts) {
        ArrayList validCuts = Lists.newArrayList();
        int offset2 = 0;
        Iterator<Integer> cutIt = cuts.iterator();
        while (cutIt.hasNext()) {
            Integer cut = cutIt.next() + offset2;
            while (cut < gs.longestPath && !gs.isCutAllowed(cut)) {
                cut = cut + 1;
                ++offset2;
            }
            if (cut >= gs.longestPath) break;
            validCuts.add(cut);
        }
        return validCuts;
    }

    private List<Integer> validifyIndexesLookingBack(GraphStats gs, List<Integer> cuts) {
        if (cuts.isEmpty()) {
            return cuts;
        }
        ArrayList validCuts = Lists.newArrayList();
        int offset2 = 0;
        int lastValidIndex = -1;
        Iterator<Integer> cutIt = cuts.iterator();
        Integer nextCut = cutIt.next();
        boolean seek = false;
        int idx = 1;
        while (idx < gs.longestPath) {
            block13: {
                if (seek) {
                    int foundIndex = -1;
                    int distBack = Math.abs(nextCut - lastValidIndex);
                    int distForward = Math.abs(idx - nextCut);
                    if (lastValidIndex > 0 && distBack <= distForward) {
                        offset2 -= distBack;
                        foundIndex = lastValidIndex;
                        idx = lastValidIndex;
                    } else if (gs.isCutAllowed(idx)) {
                        offset2 += distForward;
                        foundIndex = idx;
                    }
                    if (foundIndex > 0) {
                        validCuts.add(foundIndex);
                        lastValidIndex = -1;
                        seek = false;
                        while (cutIt.hasNext()) {
                            nextCut = cutIt.next() + offset2;
                            if (nextCut <= idx) continue;
                            break block13;
                        }
                        break;
                    }
                } else {
                    if (gs.isCutAllowed(idx)) {
                        lastValidIndex = idx;
                    }
                    if (idx == nextCut) {
                        if (gs.isCutAllowed(idx)) {
                            validCuts.add(nextCut);
                            lastValidIndex = -1;
                            if (!cutIt.hasNext()) break;
                            nextCut = cutIt.next() + offset2;
                        } else {
                            seek = true;
                        }
                    }
                }
            }
            ++idx;
        }
        return validCuts;
    }

    private void performCuts(LGraph graph, GraphStats gs, List<Integer> cuts) {
        if (cuts.isEmpty()) {
            return;
        }
        int index = 0;
        int newIndex = 0;
        Iterator<Integer> cutIt = cuts.iterator();
        int nextCut = cutIt.next();
        while (index < gs.longestPath) {
            if (index == nextCut) {
                newIndex = 0;
                nextCut = cutIt.hasNext() ? cutIt.next() : gs.longestPath + 1;
            }
            if (index != newIndex) {
                Layer oldLayer = graph.getLayers().get(index);
                Layer newLayer = graph.getLayers().get(newIndex);
                ArrayList nodesToMove = Lists.newArrayList(oldLayer.getNodes());
                for (LNode n : nodesToMove) {
                    n.setLayer(newLayer.getNodes().size(), newLayer);
                    if (newIndex != 0) continue;
                    ArrayList incEdges = Lists.newArrayList(n.getIncomingEdges());
                    for (LEdge e : incEdges) {
                        e.reverse(graph, true);
                        graph.setProperty(InternalProperties.CYCLIC, (Object)true);
                        CuttingUtils.insertDummies(graph, e, 1);
                    }
                }
            }
            ++newIndex;
            ++index;
        }
        ListIterator<Layer> it = graph.getLayers().listIterator();
        while (it.hasNext()) {
            Layer l = it.next();
            if (!l.getNodes().isEmpty()) continue;
            it.remove();
        }
    }
}

