/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class StretchWidthLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private double widthCurrent = 0.0;
    private double widthUp = 0.0;
    private double maxWidth = 0.0;
    private LGraph currentGraph;
    private double upperLayerInfluence;
    private List<LNode> sortedLayerlessNodes;
    private Set<LNode> alreadyPlacedNodes = Sets.newHashSet();
    private Set<LNode> alreadyPlacedInOtherLayers = Sets.newHashSet();
    private List<LNode> tempLayerlessNodes;
    private List<Set<LNode>> successors;
    private int[] outDegree;
    private int[] remainingOutGoing;
    private int[] inDegree;
    private LNode selectedNode;
    private double minimumNodeSize;
    private double maximumNodeSize;
    private double[] normSize;
    private double dummySize;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_PROCESSOR);
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("StretchWidth layering", 1.0f);
        if (layeredGraph.getLayerlessNodes().isEmpty()) {
            progressMonitor.done();
            return;
        }
        this.currentGraph = layeredGraph;
        this.widthCurrent = 0.0;
        this.widthUp = 0.0;
        this.minimumNodeSize = Double.POSITIVE_INFINITY;
        this.maximumNodeSize = Double.NEGATIVE_INFINITY;
        this.dummySize = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        this.computeSortedNodes();
        this.computeSuccessors();
        this.computeDegrees();
        this.minMaxNodeSize();
        this.computeNormalizedSize();
        this.minimumNodeSize = Math.max(1.0, this.minimumNodeSize);
        this.maximumNodeSize = Math.max(1.0, this.maximumNodeSize);
        this.dummySize /= this.minimumNodeSize;
        this.maxWidth = this.maximumNodeSize / this.minimumNodeSize;
        this.upperLayerInfluence = this.getAverageOutDegree();
        Layer currentLayer = new Layer(this.currentGraph);
        this.currentGraph.getLayers().add(currentLayer);
        this.tempLayerlessNodes = Lists.newArrayList(this.sortedLayerlessNodes);
        this.remainingOutGoing = Arrays.copyOf(this.outDegree, this.outDegree.length);
        while (!this.tempLayerlessNodes.isEmpty()) {
            this.selectedNode = this.selectNode();
            if (this.selectedNode == null || this.conditionGoUp() && !this.alreadyPlacedNodes.isEmpty()) {
                this.updateOutGoing(currentLayer);
                currentLayer = new Layer(this.currentGraph);
                this.currentGraph.getLayers().add(currentLayer);
                this.alreadyPlacedInOtherLayers.addAll(this.alreadyPlacedNodes);
                this.alreadyPlacedNodes.clear();
                this.widthCurrent = this.widthUp;
                this.widthUp = 0.0;
                continue;
            }
            if (this.conditionGoUp()) {
                this.currentGraph.getLayers().clear();
                currentLayer = new Layer(this.currentGraph);
                this.currentGraph.getLayers().add(currentLayer);
                this.widthCurrent = 0.0;
                this.widthUp = 0.0;
                this.alreadyPlacedNodes.clear();
                this.alreadyPlacedInOtherLayers.clear();
                this.maxWidth += 1.0;
                this.tempLayerlessNodes = Lists.newArrayList(this.sortedLayerlessNodes);
                this.remainingOutGoing = Arrays.copyOf(this.outDegree, this.outDegree.length);
                continue;
            }
            this.selectedNode.setLayer(currentLayer);
            this.tempLayerlessNodes.remove(this.selectedNode);
            this.alreadyPlacedNodes.add(this.selectedNode);
            this.widthCurrent = this.widthCurrent - (double)this.outDegree[this.selectedNode.id] * this.dummySize + this.normSize[this.selectedNode.id];
            this.widthUp += (double)this.inDegree[this.selectedNode.id] * this.dummySize;
        }
        layeredGraph.getLayerlessNodes().clear();
        Collections.reverse(layeredGraph.getLayers());
        progressMonitor.done();
    }

    private boolean conditionGoUp() {
        boolean b;
        boolean a = this.widthCurrent - (double)this.outDegree[this.selectedNode.id] * this.dummySize + this.normSize[this.selectedNode.id] > this.maxWidth;
        boolean bl = b = this.widthUp + (double)this.inDegree[this.selectedNode.id] * this.dummySize > this.maxWidth * this.upperLayerInfluence * this.dummySize;
        return a || b;
    }

    private LNode selectNode() {
        for (LNode node : this.tempLayerlessNodes) {
            if (this.remainingOutGoing[node.id] > 0) continue;
            return node;
        }
        return null;
    }

    private void computeSortedNodes() {
        List<LNode> unsortedNodes = this.currentGraph.getLayerlessNodes();
        this.sortedLayerlessNodes = Lists.newArrayList(unsortedNodes);
        for (LNode node : unsortedNodes) {
            node.id = this.getRank(node);
        }
        Collections.sort(this.sortedLayerlessNodes, new Comparator<LNode>(){

            @Override
            public int compare(LNode o1, LNode o2) {
                if (o1.id < o2.id) {
                    return 1;
                }
                if (o1.id > o2.id) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private Integer getRank(LNode node) {
        int max = Iterables.size(node.getOutgoingEdges());
        for (LEdge preEdge : node.getIncomingEdges()) {
            LNode pre = preEdge.getSource().getNode();
            int temp = Iterables.size(pre.getOutgoingEdges());
            max = Math.max(max, temp);
        }
        return max;
    }

    private void computeSuccessors() {
        int i = 0;
        this.successors = Lists.newArrayList();
        HashSet currSucc = Sets.newHashSet();
        for (LNode node : this.sortedLayerlessNodes) {
            node.id = i;
            for (LEdge edge : node.getOutgoingEdges()) {
                currSucc.add(edge.getTarget().getNode());
            }
            currSucc.remove(node);
            this.successors.add(Sets.newHashSet((Iterable)currSucc));
            currSucc.clear();
            ++i;
        }
    }

    private void computeDegrees() {
        this.inDegree = new int[this.sortedLayerlessNodes.size()];
        this.outDegree = new int[this.sortedLayerlessNodes.size()];
        for (LNode node : this.sortedLayerlessNodes) {
            this.inDegree[node.id] = Iterables.size(node.getIncomingEdges());
            this.outDegree[node.id] = Iterables.size(node.getOutgoingEdges());
        }
    }

    private void minMaxNodeSize() {
        for (LNode node : this.sortedLayerlessNodes) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            double size = node.getSize().y;
            this.minimumNodeSize = Math.min(this.minimumNodeSize, size);
            this.maximumNodeSize = Math.max(this.maximumNodeSize, size);
        }
    }

    private double avereageNodeSize() {
        double sum = 0.0;
        for (LNode node : this.sortedLayerlessNodes) {
            sum += this.normSize[node.id];
        }
        return sum / (double)this.sortedLayerlessNodes.size();
    }

    private void computeNormalizedSize() {
        this.normSize = new double[this.sortedLayerlessNodes.size()];
        for (LNode node : this.sortedLayerlessNodes) {
            this.normSize[node.id] = node.getSize().y / this.minimumNodeSize;
        }
    }

    private float getAverageOutDegree() {
        float allOut = 0.0f;
        for (LNode node : this.currentGraph.getLayerlessNodes()) {
            allOut += (float)Iterables.size(node.getOutgoingEdges());
        }
        return allOut / (float)this.currentGraph.getLayerlessNodes().size();
    }

    private void updateOutGoing(Layer currentLayer) {
        for (LNode node : currentLayer.getNodes()) {
            for (LEdge edge : node.getIncomingEdges()) {
                int pos = edge.getSource().getNode().id;
                this.remainingOutGoing[pos] = this.remainingOutGoing[pos] - 1;
            }
        }
    }
}

