/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.splines.NubSpline;
import org.eclipse.elk.alg.layered.p5edges.splines.Rectangle;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class NubsSelfLoop
extends NubSpline {
    private static final double ACCURACY = 0.5;
    private static final int MAX_RECURSIONS = 50;
    private static final double FRACTION = 1.3;
    private static final double HALF = 0.5;
    private KVector firstLabelPosition = new KVector();

    public NubsSelfLoop(NubsSelfLoop nubs) {
        super(nubs);
        this.firstLabelPosition = nubs.firstLabelPosition;
    }

    private NubsSelfLoop(int dim2, KVector ... kVectors) {
        super(true, dim2, kVectors);
    }

    public NubsSelfLoop(int dimension, List<KVector> kVectors) {
        super(true, dimension, kVectors);
    }

    public NubsSelfLoop(boolean clamped, int dimension, List<KVector> kVectors) {
        super(clamped, dimension, kVectors);
    }

    public static NubsSelfLoop createSideSelfLoop(LPort source, LPort target, double length) {
        double direction = SplinesMath.portSideToDirection(source.getSide());
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        KVector firstCP = new KVector(sourcePos).add(new KVector(direction).scale(length));
        KVector thirdCP = new KVector(targetPos).add(new KVector(direction).scale(length));
        KVector mid = new KVector(firstCP).sub(thirdCP).scale(0.5);
        KVector secondCP = new KVector(thirdCP).add(mid).add(new KVector(direction).scale(mid.length()));
        NubsSelfLoop nubs = new NubsSelfLoop(3, sourcePos, firstCP, secondCP, thirdCP, targetPos);
        KVector labelPos = nubs.getPointOnCurve(0.5);
        nubs.setFirstLabelPosition(labelPos);
        nubs.setOuterBox(new Rectangle(labelPos, sourcePos, targetPos));
        return nubs;
    }

    public static NubsSelfLoop createCornerSelfLoop(LPort source, LPort target, double sourceHeight, double targetHeight, double textLength) {
        double sourceDir = SplinesMath.portSideToDirection(source.getSide());
        double targetDir = SplinesMath.portSideToDirection(target.getSide());
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        KVector firstCP = sourcePos.clone().add(new KVector(sourceDir).scale(1.3 * sourceHeight));
        KVector thirdCP = targetPos.clone().add(new KVector(targetDir).scale(1.3 * targetHeight));
        double dist = Math.abs(firstCP.x - thirdCP.x);
        if (dist < textLength) {
            if (source.getSide() == PortSide.WEST || source.getSide() == PortSide.EAST) {
                firstCP.x = firstCP.x < thirdCP.x ? thirdCP.x - textLength : thirdCP.x + textLength;
            } else {
                thirdCP.x = firstCP.x < thirdCP.x ? firstCP.x + textLength : firstCP.x - textLength;
            }
        }
        double cornerX = 0.0;
        double cornerY = 0.0;
        switch (source.getSide()) {
            case WEST: {
                cornerX = 2.0 * (sourcePos.x - sourceHeight) - 0.5 * (firstCP.x + thirdCP.x);
                break;
            }
            case EAST: {
                cornerX = 2.0 * (sourcePos.x + sourceHeight) - 0.5 * (firstCP.x + thirdCP.x);
                break;
            }
            case NORTH: {
                cornerY = 2.0 * (sourcePos.y - sourceHeight) - 0.5 * (firstCP.y + thirdCP.y);
                break;
            }
            case SOUTH: {
                cornerY = 2.0 * (sourcePos.y + sourceHeight) - 0.5 * (firstCP.y + thirdCP.y);
                break;
            }
        }
        switch (target.getSide()) {
            case WEST: {
                cornerX = 2.0 * (targetPos.x - targetHeight) - 0.5 * (thirdCP.x + firstCP.x);
                break;
            }
            case EAST: {
                cornerX = 2.0 * (targetPos.x + targetHeight) - 0.5 * (thirdCP.x + firstCP.x);
                break;
            }
            case NORTH: {
                cornerY = 2.0 * (targetPos.y - targetHeight) - 0.5 * (thirdCP.y + firstCP.y);
                break;
            }
            case SOUTH: {
                cornerY = 2.0 * (targetPos.y + targetHeight) - 0.5 * (thirdCP.y + firstCP.y);
                break;
            }
        }
        KVector secondCP = new KVector(cornerX, cornerY);
        NubsSelfLoop nubs = new NubsSelfLoop(3, sourcePos, firstCP, secondCP, thirdCP, targetPos);
        KVector horizontal = NubsSelfLoop.getFirstHorizontalPoint(nubs, 0.5, 50);
        KVector vertical = NubsSelfLoop.getFirstVerticalPoint(nubs, 0.5, 50);
        nubs.setFirstLabelPosition(horizontal);
        nubs.setOuterBox(new Rectangle(horizontal, vertical, sourcePos, targetPos));
        return nubs;
    }

    public static NubsSelfLoop createAcrossSelfLoop(LPort source, double sourceHeight, LPort target, double targetHeight, PortSide intermediateSide, double middleHeight, double textLength) {
        KVector thirdExtremum;
        double sourceDir = SplinesMath.portSideToDirection(source.getSide());
        double targetDir = SplinesMath.portSideToDirection(target.getSide());
        KVector sourcePos = source.getPosition().clone().add(source.getAnchor());
        KVector targetPos = target.getPosition().clone().add(target.getAnchor());
        KVector firstCP = new KVector(sourcePos).add(new KVector(sourceDir).scale(sourceHeight));
        KVector fourthCP = new KVector(targetPos).add(new KVector(targetDir).scale(targetHeight));
        double loopHeight = SplinesMath.distPortToNodeEdge(source, intermediateSide);
        loopHeight = intermediateSide == PortSide.SOUTH || intermediateSide == PortSide.EAST ? (loopHeight += middleHeight) : (loopHeight -= middleHeight);
        KVector secondCP = new KVector();
        KVector thirdCP = new KVector();
        switch (intermediateSide) {
            case NORTH: 
            case SOUTH: {
                secondCP.x = firstCP.x;
                secondCP.y = sourcePos.y + loopHeight;
                thirdCP.x = fourthCP.x;
                thirdCP.y = secondCP.y;
                break;
            }
            case EAST: 
            case WEST: {
                secondCP.x = sourcePos.x + loopHeight;
                secondCP.y = firstCP.y;
                thirdCP.x = secondCP.x;
                thirdCP.y = fourthCP.y;
                break;
            }
            default: {
                return null;
            }
        }
        KVector middleCP = secondCP.clone().add(thirdCP).scale(0.5);
        NubsSelfLoop nubs = new NubsSelfLoop(3, sourcePos, firstCP, secondCP, middleCP, thirdCP, fourthCP, targetPos);
        KVector horizontal = NubsSelfLoop.getFirstHorizontalPoint(nubs, 0.5, 50);
        KVector vertical = NubsSelfLoop.getFirstVerticalPoint(nubs, 0.5, 50);
        switch (intermediateSide) {
            case NORTH: 
            case SOUTH: {
                nubs.setFirstLabelPosition(horizontal);
                thirdExtremum = NubsSelfLoop.getLastVerticalPoint(nubs, 0.5, 50);
                break;
            }
            case EAST: 
            case WEST: {
                nubs.setFirstLabelPosition(vertical);
                thirdExtremum = NubsSelfLoop.getLastHorizontalPoint(nubs, 0.5, 50);
                break;
            }
            default: {
                return null;
            }
        }
        nubs.setOuterBox(new Rectangle(horizontal, vertical, thirdExtremum, sourcePos, targetPos));
        return nubs;
    }

    public void setFirstLabelPosition(KVector position) {
        this.firstLabelPosition = position;
    }

    public KVector getFirstLabelPosition() {
        return this.firstLabelPosition;
    }
}

