/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class Rectangle {
    private double top = Double.MAX_VALUE;
    private double bottom = -1.7976931348623157E308;
    private double left = Double.MAX_VALUE;
    private double right = -1.7976931348623157E308;
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("#0.0");

    public Rectangle(double left, double top, double right2, double bottom2) {
        if (top > bottom2) {
            throw new IllegalArgumentException("Top must be smaller or equal to bottom.");
        }
        if (left > right2) {
            throw new IllegalArgumentException("Left must be smaller or equal to right.");
        }
        this.top = top;
        this.right = right2;
        this.bottom = bottom2;
        this.left = left;
    }

    public Rectangle(Rectangle rectangle) {
        this.top = rectangle.top;
        this.right = rectangle.right;
        this.bottom = rectangle.bottom;
        this.left = rectangle.left;
    }

    public Rectangle(KVector position) {
        this.top = position.y;
        this.bottom = position.y;
        this.right = position.x;
        this.left = position.x;
    }

    public Rectangle(LShape shape2) {
        KVector position = shape2.getPosition();
        KVector extend = position.clone().add(shape2.getSize());
        this.top = Math.min(position.y, extend.y);
        this.bottom = Math.max(position.y, extend.y);
        this.left = Math.min(position.x, extend.x);
        this.right = Math.max(position.x, extend.x);
    }

    public Rectangle(Iterable<KVector> vectors) {
        if (Iterables.isEmpty(vectors)) {
            throw new IllegalArgumentException("The list of vectors may not be empty.");
        }
        for (KVector vector : vectors) {
            this.top = Math.min(this.top, vector.y);
            this.right = Math.max(this.right, vector.x);
            this.bottom = Math.max(this.bottom, vector.y);
            this.left = Math.min(this.left, vector.x);
        }
    }

    public Rectangle(KVector ... vectors) {
        if (vectors.length == 0) {
            throw new IllegalArgumentException("The list of vectors may not be empty.");
        }
        KVector[] kVectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            KVector vector = kVectorArray[n2];
            this.top = Math.min(this.top, vector.y);
            this.right = Math.max(this.right, vector.x);
            this.bottom = Math.max(this.bottom, vector.y);
            this.left = Math.min(this.left, vector.x);
            ++n2;
        }
    }

    public void union(KVector vector) {
        this.top = Math.min(this.top, vector.y);
        this.right = Math.max(this.right, vector.x);
        this.bottom = Math.max(this.bottom, vector.y);
        this.left = Math.min(this.left, vector.x);
    }

    public void union(LShape shape2) {
        this.union(shape2.getPosition());
        this.union(shape2.getPosition().clone().add(shape2.getSize().x, shape2.getSize().y));
    }

    public void union(Rectangle rectangle) {
        this.top = Math.min(this.top, rectangle.top);
        this.right = Math.max(this.right, rectangle.right);
        this.bottom = Math.max(this.bottom, rectangle.bottom);
        this.left = Math.min(this.left, rectangle.left);
    }

    public static Rectangle union(Rectangle rectangle1, Rectangle rectangle2) {
        Rectangle retVal = new Rectangle(rectangle1);
        retVal.union(rectangle2);
        return retVal;
    }

    public static Rectangle union(Collection<Rectangle> rectangles) {
        Iterator<Rectangle> iter = rectangles.iterator();
        if (iter.hasNext()) {
            Rectangle rectangle = iter.next();
            Rectangle retVal = new Rectangle(rectangle);
            while (iter.hasNext()) {
                rectangle.union(iter.next());
            }
            return retVal;
        }
        throw new IllegalArgumentException("The list of vectors may not be null.");
    }

    public void enlarge(double enlargement) {
        this.top -= enlargement;
        this.left -= enlargement;
        this.right += enlargement;
        this.bottom += enlargement;
    }

    public double getHeight() {
        return this.bottom - this.top;
    }

    public double getWidth() {
        return this.right - this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getRight() {
        return this.right;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getFromPortSide(PortSide side) {
        switch (side) {
            case NORTH: {
                return this.top;
            }
            case EAST: {
                return this.right;
            }
            case SOUTH: {
                return this.bottom;
            }
            case WEST: {
                return this.left;
            }
        }
        return 0.0;
    }

    public ElkMargin toNodeMargins(LShape shape2) {
        ElkMargin retVal = new ElkMargin();
        Rectangle shapeRectangle = new Rectangle(0.0, 0.0, shape2.getSize().x, shape2.getSize().y);
        retVal.top = Math.max(0.0, shapeRectangle.top - this.top);
        retVal.left = Math.max(0.0, shapeRectangle.left - this.left);
        retVal.bottom = Math.max(0.0, this.bottom - shapeRectangle.bottom);
        retVal.right = Math.max(0.0, this.right - shapeRectangle.right);
        return retVal;
    }

    public String toString() {
        return "[top= " + DEC_FORMAT.format(this.top) + ",left= " + DEC_FORMAT.format(this.left) + ",bottom= " + DEC_FORMAT.format(this.bottom) + ",right= " + DEC_FORMAT.format(this.right) + "]";
    }
}

