/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineEdgeRouter;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public final class SplineSegment
implements Comparable<SplineSegment> {
    public final Set<LPort> leftPorts = Sets.newHashSet();
    public final Set<LPort> rightPorts = Sets.newHashSet();
    public final List<SplineEdgeRouter.Dependency> outgoing = Lists.newArrayList();
    public final List<SplineEdgeRouter.Dependency> incoming = Lists.newArrayList();
    public int mark;
    public int inweight;
    public int outweight;
    public int rank;
    public final Set<LEdge> edges = Sets.newHashSet();
    public final boolean isStraight;
    public ElkRectangle boundingBox = new ElkRectangle();
    public double hyperEdgeTopYPos;
    public double hyperEdgeBottomYPos;
    public double centerControlPointY;
    public boolean initialSegment = false;
    public boolean lastSegment = false;
    public LNode sourceNode;
    public LNode targetNode;
    public Map<LEdge, EdgeInformation> edgeInformation = Maps.newHashMap();

    public SplineSegment(LPort singlePort, Set<Pair<SplineEdgeRouter.SideToProcess, LEdge>> edges, SplineEdgeRouter.SideToProcess sourceSide) {
        if (sourceSide == SplineEdgeRouter.SideToProcess.LEFT) {
            this.leftPorts.add(singlePort);
        } else {
            this.rightPorts.add(singlePort);
        }
        double yMinPosOfTarget = Double.POSITIVE_INFINITY;
        double yMaxPosOfTarget = Double.NEGATIVE_INFINITY;
        for (Pair<SplineEdgeRouter.SideToProcess, LEdge> pair : edges) {
            SplineEdgeRouter.SideToProcess side = pair.getFirst();
            LEdge edge = pair.getSecond();
            LPort targetPort = edge.getSource();
            if (targetPort.equals(singlePort)) {
                targetPort = edge.getTarget();
            }
            if (side == SplineEdgeRouter.SideToProcess.LEFT) {
                this.leftPorts.add(targetPort);
            } else {
                this.rightPorts.add(targetPort);
            }
            double yPosOfTarget = targetPort.getAbsoluteAnchor().y;
            yMinPosOfTarget = Math.min(yMinPosOfTarget, yPosOfTarget);
            yMaxPosOfTarget = Math.max(yMaxPosOfTarget, yPosOfTarget);
        }
        double yPosOfSingleSide = singlePort.getAbsoluteAnchor().y;
        this.setRelevantPositions(yPosOfSingleSide, yMinPosOfTarget, yMaxPosOfTarget);
        for (Pair<SplineEdgeRouter.SideToProcess, LEdge> pair : edges) {
            this.addEdge(pair.getSecond());
        }
        this.isStraight = false;
    }

    public SplineSegment(LEdge edge, SplineEdgeRouter.SideToProcess sourceSide, SplineEdgeRouter.SideToProcess targetSide) {
        if (sourceSide == SplineEdgeRouter.SideToProcess.LEFT) {
            this.leftPorts.add(edge.getSource());
        } else {
            this.rightPorts.add(edge.getSource());
        }
        if (targetSide == SplineEdgeRouter.SideToProcess.LEFT) {
            this.leftPorts.add(edge.getTarget());
        } else {
            this.rightPorts.add(edge.getTarget());
        }
        this.addEdge(edge);
        double sourceY = edge.getSource().getAbsoluteAnchor().y;
        double targetY = edge.getTarget().getAbsoluteAnchor().y;
        this.setRelevantPositions(sourceY, targetY, targetY);
        this.isStraight = SplineEdgeRouter.isStraight(sourceY, targetY);
    }

    private void addEdge(LEdge edge) {
        this.edges.add(edge);
        KVector sourceAnchor = edge.getSource().getAbsoluteAnchor();
        KVector targetAnchor = edge.getTarget().getAbsoluteAnchor();
        EdgeInformation ei = new EdgeInformation();
        this.edgeInformation.put(edge, ei);
        ei.startY = sourceAnchor.y;
        ei.endY = targetAnchor.y;
        ei.normalSourceNode = SplineEdgeRouter.isNormalNode(edge.getSource().getNode());
        ei.normalTargetNode = SplineEdgeRouter.isNormalNode(edge.getTarget().getNode());
        ei.invertedLeft = edge.getSource().getSide() == PortSide.WEST;
        ei.invertedRight = edge.getTarget().getSide() == PortSide.EAST;
    }

    public boolean isHyperEdge() {
        return this.edges.size() > 1;
    }

    @Override
    public int compareTo(SplineSegment other) {
        return this.mark - other.mark;
    }

    private void setRelevantPositions(double sourceY, double targetYMin, double targetYMax) {
        this.boundingBox.y = Math.min(sourceY, targetYMin);
        this.boundingBox.height = Math.max(sourceY, targetYMax) - this.boundingBox.y;
        if (sourceY < targetYMin) {
            this.centerControlPointY = 0.5 * (sourceY + targetYMin);
            this.hyperEdgeTopYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * sourceY;
            this.hyperEdgeBottomYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * targetYMin;
        } else {
            this.centerControlPointY = 0.5 * (sourceY + targetYMax);
            this.hyperEdgeTopYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * targetYMax;
            this.hyperEdgeBottomYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * sourceY;
        }
    }

    public class EdgeInformation {
        public double startY;
        public double endY;
        public boolean normalSourceNode;
        public boolean normalTargetNode;
        public boolean invertedLeft;
        public boolean invertedRight;
    }
}

