/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.eclipse.elk.core.comments.AbstractNormalizedMatcher;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IDataProvider;

public final class DistanceMatcher<C, T>
extends AbstractNormalizedMatcher<C, T> {
    private IBoundsProvider<C, T> boundsProvider = null;
    private static final int TOP = 2;
    private static final int LEFT = 1;
    private static final int RIGHT = 4;
    private static final int BOTTOM = 8;
    private static final int TOP_LEFT = 3;
    private static final int BOTTOM_LEFT = 9;
    private static final int TOP_RIGHT = 6;
    private static final int BOTTOM_RIGHT = 12;

    public DistanceMatcher<C, T> withMaximumAttachmentDistance(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Maximum attachment distance must be >= 0.");
        }
        super.withBounds(distance, 0.0);
        return this;
    }

    public DistanceMatcher<C, T> withBoundsProvider(IBoundsProvider<C, T> provider2) {
        Objects.requireNonNull(provider2, "Bounds provider must not be null.");
        this.boundsProvider = provider2;
        return this;
    }

    @Override
    public DistanceMatcher<C, T> withNormalizationFunction(AbstractNormalizedMatcher.NormalizationFunction normalizationFunction) {
        super.withNormalizationFunction(normalizationFunction);
        return this;
    }

    private void checkConfiguration() {
        if (this.boundsProvider == null) {
            throw new IllegalStateException("A bounds provider is required.");
        }
    }

    @Override
    public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
        super.preprocess(dataProvider, includeHierarchy);
        this.checkConfiguration();
    }

    @Override
    public double raw(C comment, T target) {
        Rectangle2D.Double nodeBounds;
        Rectangle2D.Double commentBounds = this.boundsProvider.boundsForComment(comment);
        double distance = DistanceMatcher.distance(commentBounds, nodeBounds = this.boundsProvider.boundsForTarget(target));
        return distance == -1.0 ? this.getWorstRawValue() : distance;
    }

    public static double distance(Rectangle2D.Double bounds1, Rectangle2D.Double bounds2) {
        if (bounds1.intersects(bounds2)) {
            return 0.0;
        }
        int topLeftOutcode = bounds2.outcode(bounds1.x, bounds1.y);
        int bottomRightOutcode = bounds2.outcode(bounds1.x + bounds1.width, bounds1.y + bounds1.height);
        if ((topLeftOutcode & 3) == 3 && (bottomRightOutcode & 3) == 3) {
            return DistanceMatcher.distance(bounds1.x + bounds1.width, bounds1.y + bounds1.height, bounds2.x, bounds2.y);
        }
        if ((topLeftOutcode & 9) == 9 && (bottomRightOutcode & 9) == 9) {
            return DistanceMatcher.distance(bounds1.x + bounds1.width, bounds1.y, bounds2.x, bounds2.y + bounds2.height);
        }
        if ((topLeftOutcode & 6) == 6 && (bottomRightOutcode & 6) == 6) {
            return DistanceMatcher.distance(bounds1.x, bounds1.y + bounds1.height, bounds2.x + bounds2.width, bounds2.y);
        }
        if ((topLeftOutcode & 0xC) == 12 && (bottomRightOutcode & 0xC) == 12) {
            return DistanceMatcher.distance(bounds1.x, bounds1.y, bounds2.x + bounds2.width, bounds2.y + bounds2.height);
        }
        if ((topLeftOutcode & 1) != 0 && (bottomRightOutcode & 1) != 0) {
            double distance = bounds2.x - bounds1.x + bounds1.width;
            return distance;
        }
        if ((topLeftOutcode & 4) != 0 && (bottomRightOutcode & 4) != 0) {
            double distance = bounds1.x - bounds2.x - bounds2.width;
            return distance;
        }
        if ((topLeftOutcode & 2) != 0 && (bottomRightOutcode & 2) != 0) {
            double distance = bounds2.y - bounds1.y + bounds1.height;
            return distance;
        }
        if ((topLeftOutcode & 8) != 0 && (bottomRightOutcode & 8) != 0) {
            double distance = bounds1.y - bounds2.y - bounds2.height;
            return distance;
        }
        if (bounds2.x <= bounds1.x + bounds1.width && bounds2.x + bounds2.width >= bounds1.x ? bounds2.y + bounds2.height == bounds1.y || bounds2.y == bounds1.y + bounds1.height : bounds2.y <= bounds1.y + bounds1.height && bounds2.y + bounds2.height >= bounds1.y && (bounds2.x + bounds2.width == bounds1.x || bounds2.x == bounds1.x + bounds1.width)) {
            return 0.0;
        }
        return -1.0;
    }

    private static double distance(double x1, double y1, double x2, double y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }
}

