/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.collect.Maps;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.eclipse.elk.core.comments.IDataProvider;

public interface IBoundsProvider<C, T> {
    public Rectangle2D.Double boundsForComment(C var1);

    public Rectangle2D.Double boundsForTarget(T var1);

    default public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
    }

    default public void cleanup() {
    }

    default public IBoundsProvider<C, T> cached() {
        return new IBoundsProvider<C, T>(){
            private final Map<C, Rectangle2D.Double> commentBoundsCache = Maps.newHashMap();
            private final Map<T, Rectangle2D.Double> targetBoundsCache = Maps.newHashMap();

            @Override
            public Rectangle2D.Double boundsForComment(C comment) {
                if (this.commentBoundsCache.containsKey(comment)) {
                    return this.commentBoundsCache.get(comment);
                }
                Rectangle2D.Double bounds2 = IBoundsProvider.this.boundsForComment(comment);
                this.commentBoundsCache.put(comment, bounds2);
                return bounds2;
            }

            @Override
            public Rectangle2D.Double boundsForTarget(T target) {
                if (this.targetBoundsCache.containsKey(target)) {
                    return this.targetBoundsCache.get(target);
                }
                Rectangle2D.Double bounds2 = IBoundsProvider.this.boundsForTarget(target);
                this.targetBoundsCache.put(target, bounds2);
                return bounds2;
            }

            @Override
            public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
                IBoundsProvider.this.preprocess(dataProvider, includeHierarchy);
            }

            @Override
            public void cleanup() {
                this.commentBoundsCache.clear();
                this.targetBoundsCache.clear();
                IBoundsProvider.this.cleanup();
            }
        };
    }
}

