/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.math;

import java.util.Random;
import org.eclipse.elk.core.util.IDataObject;

public final class KVector
implements IDataObject,
Cloneable {
    private static final double DEFAULT_FUZZYNESS = 0.05;
    private static final long serialVersionUID = -4780985519832787684L;
    public double x;
    public double y;

    public KVector() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public KVector(double thex, double they) {
        this.x = thex;
        this.y = they;
    }

    public KVector(KVector v) {
        this.x = v.x;
        this.y = v.y;
    }

    public KVector(double angle) {
        this.x = Math.cos(angle);
        this.y = Math.sin(angle);
    }

    public KVector clone() {
        return new KVector(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof KVector) {
            KVector other = (KVector)obj;
            return this.x == other.x && this.y == other.y;
        }
        return false;
    }

    public boolean equalsFuzzily(KVector other) {
        return this.equalsFuzzily(other, 0.05);
    }

    public boolean equalsFuzzily(KVector other, double fuzzyness) {
        return Math.abs(this.x - other.x) <= fuzzyness && Math.abs(this.y - other.y) <= fuzzyness;
    }

    public int hashCode() {
        return Double.valueOf(this.x).hashCode() + Integer.reverse(Double.valueOf(this.y).hashCode());
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double squareLength() {
        return this.x * this.x + this.y * this.y;
    }

    public KVector reset() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public KVector set(KVector other) {
        this.x = other.x;
        this.y = other.y;
        return this;
    }

    public KVector add(KVector v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public KVector add(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public static KVector sum(KVector ... vs) {
        KVector sum = new KVector();
        KVector[] kVectorArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            KVector v = kVectorArray[n2];
            sum.x += v.x;
            sum.y += v.y;
            ++n2;
        }
        return sum;
    }

    public KVector sub(KVector v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public KVector sub(double dx, double dy) {
        this.x -= dx;
        this.y -= dy;
        return this;
    }

    public KVector scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        return this;
    }

    public KVector scale(double scalex, double scaley) {
        this.x *= scalex;
        this.y *= scaley;
        return this;
    }

    public KVector normalize() {
        double length = this.length();
        if (length > 0.0) {
            this.x /= length;
            this.y /= length;
        }
        return this;
    }

    public KVector scaleToLength(double length) {
        this.normalize();
        this.scale(length);
        return this;
    }

    public KVector negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public double toDegrees() {
        return Math.toDegrees(this.toRadians());
    }

    public double toRadians() {
        double length = this.length();
        assert (length > 0.0);
        if (this.x >= 0.0 && this.y >= 0.0) {
            return Math.asin(this.y / length);
        }
        if (this.x < 0.0) {
            return Math.PI - Math.asin(this.y / length);
        }
        return Math.PI * 2 + Math.asin(this.y / length);
    }

    public void wiggle(Random random, double amount) {
        this.x += random.nextDouble() * amount - amount / 2.0;
        this.y += random.nextDouble() * amount - amount / 2.0;
    }

    public double distance(KVector v2) {
        double dx = this.x - v2.x;
        double dy = this.y - v2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double dotProduct(KVector v2) {
        return this.x * v2.x + this.y * v2.y;
    }

    public KVector bound(double lowx, double lowy, double highx, double highy) {
        if (highx < lowx || highy < lowy) {
            throw new IllegalArgumentException("The highx must be bigger then lowx and the highy must be bigger then lowy");
        }
        if (this.x < lowx) {
            this.x = lowx;
        } else if (this.x > highx) {
            this.x = highx;
        }
        if (this.y < lowy) {
            this.y = lowy;
        } else if (this.y > highy) {
            this.y = highy;
        }
        return this;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.x) || Double.isInfinite(this.y);
    }

    @Override
    public void parse(String string2) {
        int start = 0;
        while (start < string2.length() && KVector.isdelim(string2.charAt(start), "([{\"' \t\r\n")) {
            ++start;
        }
        int end = string2.length();
        while (end > 0 && KVector.isdelim(string2.charAt(end - 1), ")]}\"' \t\r\n")) {
            --end;
        }
        if (start >= end) {
            throw new IllegalArgumentException("The given string does not contain any numbers.");
        }
        String[] tokens = string2.substring(start, end).split(",|;|\r|\n");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Exactly two numbers are expected, " + tokens.length + " were found.");
        }
        try {
            this.x = Double.parseDouble(tokens[0].trim());
            this.y = Double.parseDouble(tokens[1].trim());
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("The given string contains parts that cannot be parsed as numbers." + exception);
        }
    }

    private static boolean isdelim(char c, String delims) {
        int i = 0;
        while (i < delims.length()) {
            if (c == delims.charAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

