/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import java.util.EnumSet;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.BoxLayoutProvider;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class BoxLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.box";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property<ElkPadding>(CoreOptions.PADDING, PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property<Double>(CoreOptions.SPACING_NODE_NODE, Double.valueOf(15.0));
    private static final int PRIORITY_DEFAULT = 0;
    public static final IProperty<Integer> PRIORITY = new Property<Integer>(CoreOptions.PRIORITY, Integer.valueOf(0));
    public static final IProperty<Boolean> EXPAND_NODES = CoreOptions.EXPAND_NODES;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    private static final double ASPECT_RATIO_DEFAULT = (double)1.3f;
    public static final IProperty<Double> ASPECT_RATIO = new Property<Double>(CoreOptions.ASPECT_RATIO, Double.valueOf(1.3f));
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    public static final IProperty<BoxLayoutProvider.PackingMode> BOX_PACKING_MODE = CoreOptions.BOX_PACKING_MODE;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("Box Layout").description("Algorithm for packing of unconnected boxes, i.e. graphs without edges.").providerFactory(new BoxFactory()).melkBundleName("ELK").definingBundleId("org.eclipse.elk.core").imagePath("images/box_layout.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", 15.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.priority", 0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.expandNodes", EXPAND_NODES.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", 1.3f);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.box.packingMode", (Object)BOX_PACKING_MODE.getDefault());
    }

    public static class BoxFactory
    implements IFactory<AbstractLayoutProvider> {
        @Override
        public AbstractLayoutProvider create() {
            BoxLayoutProvider provider2 = new BoxLayoutProvider();
            provider2.initialize("");
            return provider2;
        }

        @Override
        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

