/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.adapters;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.nodespacing.LabelSide;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.ECollections;

public final class ElkGraphAdapters {
    public static final PortComparator DEFAULT_PORTLIST_SORTER = new PortComparator();

    private ElkGraphAdapters() {
        throw new IllegalStateException("Private constructor instantiation! Bad!");
    }

    public static ElkGraphAdapter adapt(ElkNode graph) {
        return new ElkGraphAdapter(graph);
    }

    public static ElkNodeAdapter adaptSingleNode(ElkNode node) {
        return new ElkNodeAdapter(null, node);
    }

    private static abstract class AbstractElkGraphElementAdapter<T extends ElkShape>
    implements GraphAdapters.GraphElementAdapter<T> {
        private static final IProperty<Double> OFFSET_PROXY = new Property<Double>(CoreOptions.PORT_BORDER_OFFSET, Double.valueOf(0.0));
        protected T element;
        private int id;

        protected AbstractElkGraphElementAdapter(T element) {
            this.element = element;
        }

        @Override
        public <P> P getProperty(IProperty<P> prop) {
            if (prop.equals(CoreOptions.PORT_BORDER_OFFSET)) {
                return (P)this.element.getProperty(OFFSET_PROXY);
            }
            return this.element.getProperty(prop);
        }

        @Override
        public <P> boolean hasProperty(IProperty<P> prop) {
            return this.element.hasProperty(prop);
        }

        @Override
        public KVector getPosition() {
            return new KVector(this.element.getX(), this.element.getY());
        }

        @Override
        public KVector getSize() {
            return new KVector(this.element.getWidth(), this.element.getHeight());
        }

        @Override
        public void setSize(KVector size) {
            this.element.setWidth(size.x);
            this.element.setHeight(size.y);
        }

        @Override
        public void setPosition(KVector pos) {
            this.element.setX(pos.x);
            this.element.setY(pos.y);
        }

        public ElkPadding getPadding() {
            ElkPadding elkPadding = this.element.getProperty(CoreOptions.PADDING);
            if (elkPadding == null) {
                return new ElkPadding();
            }
            return new ElkPadding(elkPadding);
        }

        public void setPadding(ElkPadding padding) {
            this.element.setProperty(CoreOptions.PADDING, (ElkPadding)new ElkPadding(padding));
        }

        public ElkMargin getMargin() {
            ElkMargin margins = this.element.getProperty(CoreOptions.MARGINS);
            if (margins == null) {
                margins = new ElkMargin();
            }
            return margins;
        }

        public void setMargin(ElkMargin margin) {
            ElkMargin newMargin = new ElkMargin(margin);
            this.element.setProperty(CoreOptions.MARGINS, (ElkMargin)newMargin);
        }

        @Override
        public int getVolatileId() {
            return this.id;
        }

        @Override
        public void setVolatileId(int volatileId) {
            this.id = volatileId;
        }
    }

    private static final class ElkEdgeAdapter
    implements GraphAdapters.EdgeAdapter<ElkEdge> {
        private ElkEdge element;
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;

        private ElkEdgeAdapter(ElkEdge edge) {
            this.element = edge;
        }

        @Override
        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithExpectedSize((int)this.element.getLabels().size());
                for (ElkLabel l : this.element.getLabels()) {
                    this.labelAdapters.add(new ElkLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }
    }

    public static final class ElkGraphAdapter
    extends AbstractElkGraphElementAdapter<ElkNode>
    implements GraphAdapters.GraphAdapter<ElkNode> {
        private List<GraphAdapters.NodeAdapter<?>> childNodes = null;

        private ElkGraphAdapter(ElkNode node) {
            super(node);
        }

        @Override
        public Iterable<GraphAdapters.NodeAdapter<?>> getNodes() {
            if (this.childNodes == null) {
                this.childNodes = Lists.newArrayListWithExpectedSize((int)((ElkNode)this.element).getChildren().size());
                for (ElkNode n : ((ElkNode)this.element).getChildren()) {
                    this.childNodes.add(new ElkNodeAdapter(this, n));
                }
            }
            return this.childNodes;
        }
    }

    private static final class ElkLabelAdapter
    extends AbstractElkGraphElementAdapter<ElkLabel>
    implements GraphAdapters.LabelAdapter<ElkLabel> {
        private ElkLabelAdapter(ElkLabel label) {
            super(label);
        }

        @Override
        public LabelSide getSide() {
            return ((ElkLabel)this.element).getProperty(LabelSide.LABEL_SIDE);
        }
    }

    public static final class ElkNodeAdapter
    extends AbstractElkGraphElementAdapter<ElkNode>
    implements GraphAdapters.NodeAdapter<ElkNode> {
        private ElkGraphAdapter parentGraphAdapter = null;
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.PortAdapter<?>> portAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> incomingEdgeAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> outgoingEdgeAdapters = null;

        private ElkNodeAdapter(ElkGraphAdapter parent, ElkNode node) {
            super(node);
            this.parentGraphAdapter = parent;
        }

        @Override
        public GraphAdapters.GraphAdapter<?> getGraph() {
            return this.parentGraphAdapter;
        }

        @Override
        public List<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithExpectedSize((int)((ElkNode)this.element).getLabels().size());
                for (ElkLabel l : ((ElkNode)this.element).getLabels()) {
                    this.labelAdapters.add(new ElkLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        @Override
        public List<GraphAdapters.PortAdapter<?>> getPorts() {
            if (this.portAdapters == null) {
                this.portAdapters = Lists.newArrayListWithExpectedSize((int)((ElkNode)this.element).getPorts().size());
                for (ElkPort p : ((ElkNode)this.element).getPorts()) {
                    this.portAdapters.add(new ElkPortAdapter(p));
                }
            }
            return this.portAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            if (this.incomingEdgeAdapters == null) {
                this.incomingEdgeAdapters = Lists.newArrayList();
                for (ElkEdge e : ElkGraphUtil.allIncomingEdges((ElkNode)this.element)) {
                    this.incomingEdgeAdapters.add(new ElkEdgeAdapter(e));
                }
            }
            return this.incomingEdgeAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            if (this.outgoingEdgeAdapters == null) {
                this.outgoingEdgeAdapters = Lists.newArrayList();
                for (ElkEdge e : ElkGraphUtil.allOutgoingEdges((ElkNode)this.element)) {
                    this.outgoingEdgeAdapters.add(new ElkEdgeAdapter(e));
                }
            }
            return this.outgoingEdgeAdapters;
        }

        @Override
        public void sortPortList() {
            this.sortPortList(DEFAULT_PORTLIST_SORTER);
        }

        @Override
        public void sortPortList(Comparator<?> comparator2) {
            if (((ElkNode)this.element).getProperty(CoreOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                ECollections.sort(((ElkNode)this.element).getPorts(), comparator2);
            }
        }

        @Override
        public boolean isCompoundNode() {
            return !((ElkNode)this.element).getChildren().isEmpty() || ((ElkNode)this.element).getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false;
        }
    }

    private static final class ElkPortAdapter
    extends AbstractElkGraphElementAdapter<ElkPort>
    implements GraphAdapters.PortAdapter<ElkPort> {
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> incomingEdgeAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> outgoingEdgeAdapters = null;

        private ElkPortAdapter(ElkPort port) {
            super(port);
        }

        @Override
        public PortSide getSide() {
            return ((ElkPort)this.element).getProperty(CoreOptions.PORT_SIDE);
        }

        @Override
        public List<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithExpectedSize((int)((ElkPort)this.element).getLabels().size());
                for (ElkLabel l : ((ElkPort)this.element).getLabels()) {
                    this.labelAdapters.add(new ElkLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            if (this.incomingEdgeAdapters == null) {
                this.incomingEdgeAdapters = Lists.newArrayListWithCapacity((int)((ElkPort)this.element).getIncomingEdges().size());
                for (ElkEdge e : ((ElkPort)this.element).getIncomingEdges()) {
                    this.incomingEdgeAdapters.add(new ElkEdgeAdapter(e));
                }
            }
            return this.incomingEdgeAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            if (this.outgoingEdgeAdapters == null) {
                this.outgoingEdgeAdapters = Lists.newArrayListWithCapacity((int)((ElkPort)this.element).getOutgoingEdges().size());
                for (ElkEdge e : ((ElkPort)this.element).getOutgoingEdges()) {
                    this.outgoingEdgeAdapters.add(new ElkEdgeAdapter(e));
                }
            }
            return this.outgoingEdgeAdapters;
        }

        @Override
        public boolean hasCompoundConnections() {
            ElkNode node = ((ElkPort)this.element).getParent();
            for (ElkEdge edge : ((ElkPort)this.element).getOutgoingEdges()) {
                for (ElkConnectableShape target : edge.getTargets()) {
                    if (ElkGraphUtil.isDescendant(ElkGraphUtil.connectableShapeToNode(target), node)) {
                        return true;
                    }
                    if (ElkGraphUtil.connectableShapeToNode(target) != node || !edge.getProperty(CoreOptions.INSIDE_SELF_LOOPS_YO).booleanValue()) continue;
                    return true;
                }
            }
            for (ElkEdge edge : ((ElkPort)this.element).getIncomingEdges()) {
                for (ElkConnectableShape source : edge.getSources()) {
                    if (!ElkGraphUtil.isDescendant(ElkGraphUtil.connectableShapeToNode(source), node)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class PortComparator
    implements Comparator<ElkPort> {
        @Override
        public int compare(ElkPort port1, ElkPort port2) {
            int indexDifference;
            int ordinalDifference = port1.getProperty(CoreOptions.PORT_SIDE).ordinal() - port2.getProperty(CoreOptions.PORT_SIDE).ordinal();
            if (ordinalDifference != 0) {
                return ordinalDifference;
            }
            Integer index1 = port1.getProperty(CoreOptions.PORT_INDEX);
            Integer index2 = port2.getProperty(CoreOptions.PORT_INDEX);
            if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                return indexDifference;
            }
            switch (port1.getProperty(CoreOptions.PORT_SIDE)) {
                case NORTH: {
                    return Double.compare(port1.getX(), port2.getX());
                }
                case EAST: {
                    return Double.compare(port1.getY(), port2.getY());
                }
                case SOUTH: {
                    return Double.compare(port2.getX(), port1.getX());
                }
                case WEST: {
                    return Double.compare(port2.getY(), port1.getY());
                }
            }
            throw new IllegalStateException("Port side is undefined");
        }
    }
}

