/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.cellsystem;

import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.util.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.core.util.nodespacing.cellsystem.Cell;

public abstract class ContainerCell
extends Cell {
    public abstract void layoutChildrenHorizontally();

    public abstract void layoutChildrenVertically();

    protected static double minWidthOfCell(Cell cell, boolean respectContributionFlag) {
        if (cell == null) {
            return 0.0;
        }
        if (respectContributionFlag && !cell.isContributingToMinimumWidth()) {
            return 0.0;
        }
        if (cell instanceof AtomicCell && ((AtomicCell)cell).getMinimumContentAreaSize().x == 0.0) {
            return 0.0;
        }
        return cell.getMinimumWidth();
    }

    protected static double minHeightOfCell(Cell cell, boolean respectContributionFlag) {
        if (cell == null) {
            return 0.0;
        }
        if (respectContributionFlag && !cell.isContributingToMinimumHeight()) {
            return 0.0;
        }
        if (cell instanceof AtomicCell && ((AtomicCell)cell).getMinimumContentAreaSize().y == 0.0) {
            return 0.0;
        }
        return cell.getMinimumHeight();
    }

    protected void applyHorizontalLayout(Cell cell, double x, double width2) {
        if (cell != null) {
            ElkRectangle cellRect = cell.getCellRectangle();
            cellRect.x = x;
            cellRect.width = width2;
        }
    }

    protected void applyVerticalLayout(Cell cell, double y, double height2) {
        if (cell != null) {
            ElkRectangle cellRect = cell.getCellRectangle();
            cellRect.y = y;
            cellRect.height = height2;
        }
    }
}

