/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.cellsystem;

import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.nodespacing.cellsystem.Cell;
import org.eclipse.elk.core.util.nodespacing.cellsystem.ContainerArea;
import org.eclipse.elk.core.util.nodespacing.cellsystem.ContainerCell;

public class GridContainerCell
extends ContainerCell {
    private static final int ROWS;
    private static final int COLUMNS;
    private final double gap;
    private final boolean tabular;
    private final boolean symmetrical;
    private final Cell[][] cells = new Cell[ROWS][COLUMNS];
    private KVector centerCellMinimumSize = null;
    private boolean onlyCenterCellContributesToMinimumSize = false;
    private ElkRectangle centerCellRect = new ElkRectangle();

    static {
        COLUMNS = ROWS = ContainerArea.values().length;
    }

    public GridContainerCell(boolean tabular, boolean symmetrical, double gap) {
        this.tabular = tabular;
        this.symmetrical = symmetrical;
        this.gap = gap;
    }

    public double getGap() {
        return this.gap;
    }

    public Cell getCell(ContainerArea row, ContainerArea col) {
        return this.cells[row.ordinal()][col.ordinal()];
    }

    public void setCell(ContainerArea row, ContainerArea col, Cell cell) {
        this.cells[row.ordinal()][col.ordinal()] = cell;
    }

    public void setCenterCellMinimumSize(KVector minimumSize) {
        this.centerCellMinimumSize = new KVector(minimumSize);
    }

    public void setOnlyCenterCellContributesToMinimumSize(boolean contribution) {
        this.onlyCenterCellContributesToMinimumSize = contribution;
    }

    public ElkRectangle getCenterCellRectangle() {
        return new ElkRectangle(this.centerCellRect);
    }

    @Override
    public double getMinimumWidth() {
        double width2;
        block5: {
            block3: {
                block4: {
                    width2 = 0.0;
                    if (!this.onlyCenterCellContributesToMinimumSize) break block3;
                    if (this.centerCellMinimumSize == null) break block4;
                    width2 = this.centerCellMinimumSize.x;
                    break block5;
                }
                if (this.cells[1][1] == null) break block5;
                width2 = this.cells[1][1].getMinimumWidth();
                break block5;
            }
            if (this.tabular) {
                width2 = this.sumWithGaps(this.minColumnWidths(null, true));
            } else {
                ContainerArea[] containerAreaArray = ContainerArea.values();
                int n = containerAreaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContainerArea area = containerAreaArray[n2];
                    width2 = Math.max(width2, this.sumWithGaps(this.minColumnWidths(area, true)));
                    ++n2;
                }
            }
        }
        return width2 > 0.0 ? width2 + this.getPadding().left + this.getPadding().right : 0.0;
    }

    @Override
    public double getMinimumHeight() {
        double height2 = 0.0;
        if (this.onlyCenterCellContributesToMinimumSize) {
            if (this.centerCellMinimumSize != null) {
                height2 = this.centerCellMinimumSize.y;
            } else if (this.cells[1][1] != null) {
                height2 = this.cells[1][1].getMinimumHeight();
            }
        } else {
            height2 = this.sumWithGaps(this.minRowHeights(true));
        }
        return height2 > 0.0 ? height2 + this.getPadding().top + this.getPadding().bottom : 0.0;
    }

    @Override
    public void layoutChildrenHorizontally() {
        if (this.tabular) {
            double[] colWidths = this.minColumnWidths(null, false);
            ContainerArea[] containerAreaArray = ContainerArea.values();
            int n = containerAreaArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerArea row = containerAreaArray[n2];
                this.applyWidthsToRow(row, colWidths);
                ++n2;
            }
        } else {
            ContainerArea[] containerAreaArray = ContainerArea.values();
            int n = containerAreaArray.length;
            int n3 = 0;
            while (n3 < n) {
                ContainerArea row = containerAreaArray[n3];
                double[] colWidths = this.minColumnWidths(row, false);
                this.applyWidthsToRow(row, colWidths);
                ++n3;
            }
        }
    }

    @Override
    public void layoutChildrenVertically() {
        ElkRectangle cellRectangle = this.getCellRectangle();
        ElkPadding cellPadding = this.getPadding();
        double[] rowHeights = this.minRowHeights(false);
        this.applyHeightToRow(ContainerArea.BEGIN, cellRectangle.y + cellPadding.top, rowHeights);
        this.applyHeightToRow(ContainerArea.END, cellRectangle.y + cellRectangle.height - cellPadding.bottom - rowHeights[2], rowHeights);
        double freeContentAreaHeight = cellRectangle.height - cellPadding.top - cellPadding.bottom;
        if (rowHeights[0] > 0.0) {
            rowHeights[0] = rowHeights[0] + this.gap;
            freeContentAreaHeight -= rowHeights[0];
        }
        if (rowHeights[2] > 0.0) {
            rowHeights[2] = rowHeights[2] + this.gap;
            freeContentAreaHeight -= rowHeights[2];
        }
        this.centerCellRect.height = Math.max(0.0, freeContentAreaHeight);
        this.centerCellRect.y = cellRectangle.y + cellPadding.top + (this.centerCellRect.height - freeContentAreaHeight) / 2.0;
        rowHeights[1] = Math.max(rowHeights[1], freeContentAreaHeight);
        this.applyHeightToRow(ContainerArea.CENTER, cellRectangle.y + cellPadding.top + rowHeights[0] - (rowHeights[1] - freeContentAreaHeight) / 2.0, rowHeights);
    }

    private double[] minColumnWidths(ContainerArea row, boolean respectContributionFlag) {
        double[] colWidths = new double[]{this.minWidthOfColumn(ContainerArea.BEGIN, row, respectContributionFlag), this.minWidthOfColumn(ContainerArea.CENTER, row, respectContributionFlag), this.minWidthOfColumn(ContainerArea.END, row, respectContributionFlag)};
        if (this.symmetrical) {
            colWidths[0] = Math.max(colWidths[0], colWidths[2]);
            colWidths[2] = colWidths[0];
        }
        return colWidths;
    }

    private double minWidthOfColumn(ContainerArea column, ContainerArea row, boolean respectContributionFlag) {
        double maxMinWidth = 0.0;
        if (row == null) {
            int rowIndex = 0;
            while (rowIndex < ROWS) {
                maxMinWidth = Math.max(maxMinWidth, GridContainerCell.minWidthOfCell(this.cells[rowIndex][column.ordinal()], respectContributionFlag));
                ++rowIndex;
            }
        } else {
            maxMinWidth = GridContainerCell.minWidthOfCell(this.cells[row.ordinal()][column.ordinal()], respectContributionFlag);
        }
        if (column == ContainerArea.CENTER && this.centerCellMinimumSize != null) {
            maxMinWidth = Math.max(maxMinWidth, this.centerCellMinimumSize.x);
        }
        return maxMinWidth;
    }

    private double[] minRowHeights(boolean respectContributionFlag) {
        double[] rowHeights = new double[]{this.minHeightOfRow(ContainerArea.BEGIN, respectContributionFlag), this.minHeightOfRow(ContainerArea.CENTER, respectContributionFlag), this.minHeightOfRow(ContainerArea.END, respectContributionFlag)};
        if (this.symmetrical) {
            rowHeights[0] = Math.max(rowHeights[0], rowHeights[2]);
            rowHeights[2] = rowHeights[0];
        }
        return rowHeights;
    }

    private double minHeightOfRow(ContainerArea row, boolean respectContributionFlag) {
        double maxMinHeight = 0.0;
        int column = 0;
        while (column < COLUMNS) {
            maxMinHeight = Math.max(maxMinHeight, GridContainerCell.minHeightOfCell(this.cells[row.ordinal()][column], respectContributionFlag));
            ++column;
        }
        if (row == ContainerArea.CENTER && this.centerCellMinimumSize != null) {
            maxMinHeight = Math.max(maxMinHeight, this.centerCellMinimumSize.y);
        }
        return maxMinHeight;
    }

    private double sumWithGaps(double[] values2) {
        double sum = 0.0;
        int activeComponents = 0;
        double[] dArray = values2;
        int n = values2.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            if (val > 0.0) {
                sum += val;
                ++activeComponents;
            }
            ++n2;
        }
        if (activeComponents > 1) {
            sum += this.gap * (double)(activeComponents - 1);
        }
        return sum;
    }

    private void applyWidthsToRow(ContainerArea row, double[] colWidths) {
        ElkRectangle cellRectangle = this.getCellRectangle();
        ElkPadding cellPadding = this.getPadding();
        this.applyWidthToColumn(ContainerArea.BEGIN, cellRectangle.x + cellPadding.left, colWidths);
        this.applyWidthToColumn(ContainerArea.END, cellRectangle.x + cellRectangle.width - cellPadding.right - colWidths[2], colWidths);
        double freeContentAreaWidth = cellRectangle.width - cellPadding.left - cellPadding.right;
        if (colWidths[0] > 0.0) {
            colWidths[0] = colWidths[0] + this.gap;
            freeContentAreaWidth -= colWidths[0];
        }
        if (colWidths[2] > 0.0) {
            colWidths[2] = colWidths[2] + this.gap;
            freeContentAreaWidth -= colWidths[2];
        }
        double centerWidth = Math.max(0.0, freeContentAreaWidth);
        colWidths[1] = Math.max(colWidths[1], freeContentAreaWidth);
        this.applyWidthToColumn(ContainerArea.CENTER, cellRectangle.x + cellPadding.left + colWidths[0] - (colWidths[1] - freeContentAreaWidth) / 2.0, colWidths);
        if (row == ContainerArea.CENTER) {
            this.centerCellRect.width = centerWidth;
            this.centerCellRect.x = cellRectangle.x + cellPadding.left + (centerWidth - freeContentAreaWidth) / 2.0;
        }
    }

    private void applyWidthToColumn(ContainerArea column, double x, double[] colWidths) {
        int row = 0;
        while (row < ROWS) {
            this.applyHorizontalLayout(this.cells[row][column.ordinal()], x, colWidths[column.ordinal()]);
            ++row;
        }
    }

    private void applyHeightToRow(ContainerArea row, double y, double[] rowHeights) {
        int column = 0;
        while (column < COLUMNS) {
            this.applyVerticalLayout(this.cells[row.ordinal()][column], y, rowHeights[row.ordinal()]);
            ++column;
        }
    }
}

