/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.internal.algorithm;

import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.util.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;

public final class NodeSizeCalculator {
    private NodeSizeCalculator() {
    }

    public static void setNodeWidth(NodeContext nodeContext) {
        double width2;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            width2 = nodeSize.x;
        } else {
            KVector minNodeSize;
            width2 = nodeContext.nodeContainer.getMinimumWidth();
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                width2 = Math.max(width2, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.NORTH).getMinimumWidth());
                width2 = Math.max(width2, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.SOUTH).getMinimumWidth());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                width2 = Math.max(width2, minNodeSize.x);
            }
        }
        nodeSize.x = width2;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.x = 0.0;
        nodeCellRectangle.width = width2;
        nodeContext.nodeContainer.layoutChildrenHorizontally();
    }

    public static void setNodeHeight(NodeContext nodeContext) {
        double height2;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            height2 = nodeSize.y;
        } else {
            KVector minNodeSize;
            height2 = nodeContext.nodeContainer.getMinimumHeight();
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                height2 = Math.max(height2, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.EAST).getMinimumHeight());
                height2 = Math.max(height2, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.WEST).getMinimumHeight());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                height2 = Math.max(height2, minNodeSize.y);
            }
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORTS) && (nodeContext.portConstraints == PortConstraints.FIXED_RATIO || nodeContext.portConstraints == PortConstraints.FIXED_POS)) {
                height2 = Math.max(height2, nodeContext.insidePortLabelCells.get((Object)PortSide.EAST).getMinimumHeight());
                height2 = Math.max(height2, nodeContext.insidePortLabelCells.get((Object)PortSide.WEST).getMinimumHeight());
            }
        }
        nodeSize.y = height2;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.y = 0.0;
        nodeCellRectangle.height = height2;
        nodeContext.nodeContainer.layoutChildrenVertically();
    }
}

