/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.util;

import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.ecore.xml.type.internal.QName;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;

public final class XMLTypeUtil {
    public static final int EQUALS = 0;
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int INDETERMINATE = 2;
    private static final CharArrayPool VALUE = new CharArrayPool();

    public static int compareCalendar(Object calendar1, Object calendar2) {
        switch (((XMLGregorianCalendar)calendar1).compare((XMLGregorianCalendar)calendar2)) {
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public static int compareDuration(Object duration1, Object duration2) {
        switch (((Duration)duration1).compare((Duration)duration2)) {
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public static boolean isSpace(char value2) {
        return DataValue.XMLChar.isSpace(value2);
    }

    public static String normalize(String value2, boolean collapse) {
        if (value2 == null) {
            return null;
        }
        int length = value2.length();
        if (length == 0) {
            return "";
        }
        CharArrayPool.Buffer pooledBuffer = VALUE.get();
        char[] valueArray = pooledBuffer.get(length);
        value2.getChars(0, length, valueArray, 0);
        StringBuffer buffer = null;
        boolean skipSpace = collapse;
        int i = 0;
        int offset2 = 0;
        while (i < length) {
            char c = valueArray[i];
            if (XMLTypeUtil.isSpace(c)) {
                if (skipSpace) {
                    if (buffer == null) {
                        buffer = new StringBuffer(value2);
                    }
                    buffer.deleteCharAt(i - offset2++);
                } else {
                    skipSpace = collapse;
                    if (c != ' ') {
                        if (buffer == null) {
                            buffer = new StringBuffer(value2);
                        }
                        buffer.setCharAt(i - offset2, ' ');
                    }
                }
            } else {
                skipSpace = false;
            }
            ++i;
        }
        pooledBuffer.finished();
        if (skipSpace) {
            if (buffer == null) {
                return value2.substring(0, length - 1);
            }
            length = buffer.length();
            if (length > 0) {
                return buffer.substring(0, length - 1);
            }
            return "";
        }
        if (buffer == null) {
            return value2;
        }
        return buffer.toString();
    }

    public static EValidator.PatternMatcher createPatternMatcher(String pattern) {
        return new PatternMatcherImpl(pattern);
    }

    public static Object createQName(String namespaceUri, String localPart, String prefix) {
        return new QName(namespaceUri, localPart, prefix);
    }

    @Deprecated
    public static void setQNameValues(Object qName, String namespaceUri, String localPart, String prefix) {
        QName qn;
        if (!(qName instanceof QName)) {
            throw new UnsupportedOperationException("QNames are immutable, so this can't be supported");
        }
        if (namespaceUri == null) {
            namespaceUri = "";
        }
        if (!(qn = (QName)qName).getLocalPart().equals(localPart) || qn.getNamespaceURI().equals(namespaceUri)) {
            throw new UnsupportedOperationException("QNames are immutable, so this can't be supported");
        }
        qn.setPrefix(prefix);
    }

    public static javax.xml.namespace.QName setPrefix(javax.xml.namespace.QName qName, String prefix) {
        if (qName instanceof QName) {
            QName result = (QName)qName;
            result.setPrefix(prefix);
            return result;
        }
        return new QName(qName.getNamespaceURI(), qName.getLocalPart(), prefix);
    }

    public static String getQNameNamespaceURI(Object qName) {
        return ((javax.xml.namespace.QName)qName).getNamespaceURI();
    }

    public static String getQNameLocalPart(Object qName) {
        return ((javax.xml.namespace.QName)qName).getLocalPart();
    }

    public static String getQNamePrefix(Object qName) {
        return ((javax.xml.namespace.QName)qName).getPrefix();
    }

    public static boolean isNameStart(int codePoint) {
        return DataValue.XMLChar.isNameStart(codePoint);
    }

    public static boolean isNamePart(int codePoint) {
        return DataValue.XMLChar.isName(codePoint);
    }

    public static boolean isNCNameStart(int codePoint) {
        return DataValue.XMLChar.isNCNameStart(codePoint);
    }

    public static boolean isNCNamePart(int codePoint) {
        return DataValue.XMLChar.isNCName(codePoint);
    }

    private static final class CharArrayPool {
        private static final int MAX_CACHE_CAPACITY;
        private AtomicReference<Buffer> head = new AtomicReference();

        static {
            int result = 10000;
            try {
                String property = System.getProperty("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil.CharArrayThreadLocal.MAX_CACHE_CAPACITY");
                if (property != null) {
                    result = Integer.valueOf(property);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            MAX_CACHE_CAPACITY = result;
        }

        private CharArrayPool() {
        }

        public Buffer get() {
            Buffer buffer;
            while ((buffer = this.head.get()) != null) {
                if (!this.head.compareAndSet(buffer, buffer.next)) continue;
                return buffer;
            }
            return new Buffer();
        }

        private class Buffer {
            Buffer next;
            char[] value;

            private Buffer() {
            }

            public char[] get(int capacity) {
                if (this.value == null || this.value.length < capacity) {
                    this.value = new char[capacity < 20 ? 20 : capacity];
                }
                return this.value;
            }

            public void finished() {
                if (this.value.length <= MAX_CACHE_CAPACITY) {
                    do {
                        this.next = (Buffer)CharArrayPool.this.head.get();
                    } while (!CharArrayPool.this.head.compareAndSet(this.next, this));
                }
            }
        }
    }

    private static class PatternMatcherImpl
    implements EValidator.PatternMatcher {
        protected RegEx.RegularExpression regularExpression;

        public PatternMatcherImpl(String pattern) {
            this.regularExpression = new RegEx.RegularExpression(pattern, "X");
        }

        public boolean matches(String value2) {
            return this.regularExpression.matches(value2);
        }

        public String toString() {
            return this.regularExpression.getPattern();
        }
    }
}

