/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONException;

class JSON {
    JSON() {
    }

    static double checkDouble(double d) throws JSONException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new JSONException("Forbidden numeric value: " + d);
        }
        return d;
    }

    static Boolean toBoolean(Object value2) {
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof String) {
            String stringValue = (String)value2;
            if ("true".equalsIgnoreCase(stringValue)) {
                return true;
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return false;
            }
        }
        return null;
    }

    static Double toDouble(Object value2) {
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof String) {
            try {
                return Double.valueOf((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static Integer toInteger(Object value2) {
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        if (value2 instanceof String) {
            try {
                return (int)Double.parseDouble((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static Long toLong(Object value2) {
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof String) {
            try {
                return (long)Double.parseDouble((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static String toString(Object value2) {
        if (value2 instanceof String) {
            return (String)value2;
        }
        if (value2 != null) {
            return String.valueOf(value2);
        }
        return null;
    }

    public static JSONException typeMismatch(Object indexOrName, Object actual, String requiredType) throws JSONException {
        if (actual == null) {
            throw new JSONException("Value at " + indexOrName + " is null.");
        }
        throw new JSONException("Value " + actual + " at " + indexOrName + " of type " + actual.getClass().getName() + " cannot be converted to " + requiredType);
    }

    public static JSONException typeMismatch(Object actual, String requiredType) throws JSONException {
        if (actual == null) {
            throw new JSONException("Value is null.");
        }
        throw new JSONException("Value " + actual + " of type " + actual.getClass().getName() + " cannot be converted to " + requiredType);
    }
}

