/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.HashMap;
import java.util.Map;
import org.jsoup.helper.Validate;

public class Tag {
    private static final Map<String, Tag> tags;
    private String tagName;
    private boolean isBlock = true;
    private boolean formatAsBlock = true;
    private boolean canContainBlock = true;
    private boolean canContainInline = true;
    private boolean empty = false;
    private boolean selfClosing = false;
    private boolean preserveWhitespace = false;
    private static final String[] blockTags;
    private static final String[] inlineTags;
    private static final String[] emptyTags;
    private static final String[] formatAsInlineTags;
    private static final String[] preserveWhitespaceTags;

    private Tag(String tagName) {
        this.tagName = tagName.toLowerCase();
    }

    public String getName() {
        return this.tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag valueOf(String tagName) {
        Validate.notNull(tagName);
        tagName = tagName.trim().toLowerCase();
        Validate.notEmpty(tagName);
        Map<String, Tag> map2 = tags;
        synchronized (map2) {
            Tag tag2 = tags.get(tagName);
            if (tag2 == null) {
                tag2 = new Tag(tagName);
                tag2.isBlock = false;
                tag2.canContainBlock = true;
            }
            return tag2;
        }
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean formatAsBlock() {
        return this.formatAsBlock;
    }

    public boolean canContainBlock() {
        return this.canContainBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isData() {
        return !this.canContainInline && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSelfClosing() {
        return this.empty || this.selfClosing;
    }

    public boolean isKnownTag() {
        return tags.containsKey(this.tagName);
    }

    public static boolean isKnownTag(String tagName) {
        return tags.containsKey(tagName);
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    Tag setSelfClosing() {
        this.selfClosing = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag2 = (Tag)o;
        if (this.canContainBlock != tag2.canContainBlock) {
            return false;
        }
        if (this.canContainInline != tag2.canContainInline) {
            return false;
        }
        if (this.empty != tag2.empty) {
            return false;
        }
        if (this.formatAsBlock != tag2.formatAsBlock) {
            return false;
        }
        if (this.isBlock != tag2.isBlock) {
            return false;
        }
        if (this.preserveWhitespace != tag2.preserveWhitespace) {
            return false;
        }
        if (this.selfClosing != tag2.selfClosing) {
            return false;
        }
        return this.tagName.equals(tag2.tagName);
    }

    public int hashCode() {
        int result = this.tagName.hashCode();
        result = 31 * result + (this.isBlock ? 1 : 0);
        result = 31 * result + (this.formatAsBlock ? 1 : 0);
        result = 31 * result + (this.canContainBlock ? 1 : 0);
        result = 31 * result + (this.canContainInline ? 1 : 0);
        result = 31 * result + (this.empty ? 1 : 0);
        result = 31 * result + (this.selfClosing ? 1 : 0);
        result = 31 * result + (this.preserveWhitespace ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tag register(Tag tag2) {
        Map<String, Tag> map2 = tags;
        synchronized (map2) {
            tags.put(tag2.tagName, tag2);
        }
        return tag2;
    }

    static {
        Tag tag2;
        tags = new HashMap<String, Tag>();
        blockTags = new String[]{"html", "head", "body", "frameset", "script", "noscript", "style", "meta", "link", "title", "frame", "noframes", "section", "nav", "aside", "hgroup", "header", "footer", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "pre", "div", "blockquote", "hr", "address", "figure", "figcaption", "form", "fieldset", "ins", "del", "dl", "dt", "dd", "li", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td", "video", "audio", "canvas", "details", "menu", "plaintext"};
        inlineTags = new String[]{"object", "base", "font", "tt", "i", "b", "u", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "time", "acronym", "mark", "ruby", "rt", "rp", "a", "img", "br", "wbr", "map", "q", "sub", "sup", "bdo", "iframe", "embed", "span", "input", "select", "textarea", "label", "button", "optgroup", "option", "legend", "datalist", "keygen", "output", "progress", "meter", "area", "param", "source", "track", "summary", "command", "device"};
        emptyTags = new String[]{"meta", "link", "base", "frame", "img", "br", "wbr", "embed", "hr", "input", "keygen", "col", "command", "device"};
        formatAsInlineTags = new String[]{"title", "a", "p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "address", "li", "th", "td", "script", "style"};
        preserveWhitespaceTags = new String[]{"pre", "plaintext", "title"};
        for (String tagName : blockTags) {
            tag2 = new Tag(tagName);
            Tag.register(tag2);
        }
        for (String tagName : inlineTags) {
            tag2 = new Tag(tagName);
            tag2.isBlock = false;
            tag2.canContainBlock = false;
            tag2.formatAsBlock = false;
            Tag.register(tag2);
        }
        for (String tagName : emptyTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.canContainBlock = false;
            tag2.canContainInline = false;
            tag2.empty = true;
        }
        for (String tagName : formatAsInlineTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.formatAsBlock = false;
        }
        for (String tagName : preserveWhitespaceTags) {
            tag2 = tags.get(tagName);
            Validate.notNull(tag2);
            tag2.preserveWhitespace = true;
        }
    }
}

